/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessage;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.ConnectedRequestIpFrame;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionHeader;
import java.io.IOException;
import java.util.logging.Level;

public final class TunnelRequest
extends ConnectedRequestIpFrame {
    private CemiMessage cemi;

    public TunnelRequest(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public TunnelRequest(int channelId, int sequence, CemiMessage req) {
        this.connectionHeader = new ConnectionHeader(channelId, sequence);
        this.cemi = req;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.tunnellingRequest;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 11;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            super.fromStream(in);
            this.cemi = new CemiMessage(in);
        }
        catch (Exception ex) {
            if (TunnelRequest.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        super.toStream(out);
        this.cemi.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        super.toLogString(sb);
        sb.append(", request = { " + this.cemi + " }");
    }

    @Override
    public CemiMessage getCemi() {
        return this.cemi;
    }
}

