/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.parts.DeviceManagementCri;
import com.tridiumX.knxnetIp.comms.frames.parts.TunnellingCri;
import com.tridiumX.knxnetIp.knxSpec.BServiceFamilyEnum;
import java.io.IOException;

public abstract class ConnectionRequestInformation {
    protected int length;
    protected BServiceFamilyEnum serviceType = BServiceFamilyEnum.DEFAULT;

    public static ConnectionRequestInformation makeFromStream(KnxInputStream in) throws IOException {
        int length = in.read();
        int serviceType = in.read();
        ConnectionRequestInformation cri = null;
        switch (serviceType) {
            case 3: {
                cri = new DeviceManagementCri();
                break;
            }
            case 4: {
                cri = new TunnellingCri();
                break;
            }
            default: {
                throw new IOException("unsupported CRI type " + serviceType);
            }
        }
        cri.length = length;
        cri.serviceType = BServiceFamilyEnum.make(serviceType);
        cri.fromStream(in);
        return cri;
    }

    public abstract void fromStream(KnxInputStream var1) throws IOException;

    public void toStream(KnxOutputStream out) {
        out.write(this.length);
        out.write(this.serviceType.getOrdinal());
        this.toOutputStream(out);
    }

    protected abstract void toOutputStream(KnxOutputStream var1);

    public String getLogString() {
        return "Length = " + this.length + ", serviceType = " + (Object)((Object)this.serviceType);
    }

    public BServiceFamilyEnum getServiceType() {
        return this.serviceType;
    }
}

