/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public final class HostProtocolAddressInformation {
    private InetAddress address;
    private int port;

    public HostProtocolAddressInformation(KnxInputStream in) throws IOException {
        this.fromStream(in);
    }

    public HostProtocolAddressInformation(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    private void fromStream(KnxInputStream in) throws IOException {
        if (in.read() != 8) {
            throw new IOException("incorrect structure length for HPAI");
        }
        if (in.read() != 1) {
            throw new IOException("host protocol not IPV4_UDP");
        }
        byte[] addressBytes = new byte[4];
        int bytesRead = 0;
        try {
            bytesRead = in.read(addressBytes, 0, 4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("reading IP address bytes from an HPAI FAILED \n\r " + ex);
        }
        if (bytesRead != 4) {
            throw new IOException("IP Address not found, received byte stream too short");
        }
        this.address = InetAddress.getByAddress(addressBytes);
        this.port = in.readInt();
    }

    public void toStream(KnxOutputStream out) throws IOException {
        out.write(8);
        out.write(1);
        out.write(this.address.getAddress());
        out.writeInt(this.port);
    }

    public String getLogString() {
        return "Address = " + (this.address == null ? "NULL" : this.address.getHostAddress()) + ", Port = " + (this.port == -1 ? "INVALID" : Integer.toString(this.port));
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }
}

