/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.udp;

import java.io.ByteArrayOutputStream;
import javax.baja.nre.util.ByteArrayUtil;

public class UdpMulticastMessage {
    private boolean traceChecksum;
    byte[] bytes;
    private static final byte[] MULTICAST_MAC_ADDRESS = new byte[]{1, 0, 94};
    private static final int ETHERNET_FRAME_TYPE_IP = 2048;
    private static final byte IP_VERSION_4 = 64;
    private static final int UDP_IP_HEADER_LENGTH = 20;
    private static final int UDP_IP_HEADER_LENGTH_MULTIPLIER = 4;
    private static final byte DIFFERENTIATED_SERVICES_BYTE = 0;
    private static final int UDP_HEADER_SIZE = 8;
    private static final byte IP_PROTOCOL_UDP = 17;

    UdpMulticastMessage() {
    }

    public UdpMulticastMessage(byte[] sourceMacAddress, byte timeToLive, byte[] sourceIpAddress, byte[] destIpAddress, byte[] ipOptions, int sourcePort, int destPort, byte[] udpBytes, boolean debugOutput) {
        this.make(sourceMacAddress, timeToLive, sourceIpAddress, destIpAddress, ipOptions, sourcePort, destPort, udpBytes, debugOutput);
    }

    public final void make(byte[] sourceMacAddress, byte timeToLive, byte[] sourceIpAddress, byte[] destIpAddress, byte[] ipOptions, int sourcePort, int destPort, byte[] udpBytes, boolean debugOutput) {
        this.traceChecksum = debugOutput;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.reset();
        out.write(MULTICAST_MAC_ADDRESS, 0, MULTICAST_MAC_ADDRESS.length);
        out.write(destIpAddress, 1, destIpAddress.length - 1);
        out.write(sourceMacAddress, 0, sourceMacAddress.length);
        UdpMulticastMessage.writeInt(out, 2048);
        int checksum = 0;
        int ipVersion = 64;
        int ipHeaderLength = 20;
        if (ipOptions != null) {
            ipHeaderLength += ipOptions.length;
        }
        ipVersion += (ipHeaderLength + 4 - 1) / 4;
        ipVersion <<= 8;
        UdpMulticastMessage.writeInt(out, ipVersion += 0);
        checksum = this.runningChecksum(checksum, ipVersion);
        int length = ipHeaderLength + 8 + udpBytes.length;
        UdpMulticastMessage.writeInt(out, length);
        checksum = this.runningChecksum(checksum, length);
        int id = (int)(Math.random() * 65536.0) & 0xFFFF;
        if (debugOutput) {
            System.out.println("id:" + Integer.toHexString(id));
        }
        UdpMulticastMessage.writeInt(out, id);
        checksum = this.runningChecksum(checksum, id);
        out.write(0);
        out.write(0);
        checksum = this.runningChecksum(checksum, 0);
        int i = (timeToLive << 8) + 17;
        UdpMulticastMessage.writeInt(out, i);
        checksum = this.runningChecksum(checksum, i);
        checksum = this.runningChecksum(checksum, sourceIpAddress);
        checksum = this.runningChecksum(checksum, destIpAddress);
        if (ipOptions != null) {
            checksum = this.runningChecksum(checksum, ipOptions);
        }
        checksum = ~checksum & 0xFFFF;
        if (debugOutput) {
            System.out.println("  ~ck:" + Integer.toHexString(checksum));
        }
        UdpMulticastMessage.writeInt(out, checksum);
        out.write(sourceIpAddress, 0, sourceIpAddress.length);
        out.write(destIpAddress, 0, destIpAddress.length);
        if (ipOptions != null) {
            out.write(ipOptions, 0, ipOptions.length);
        }
        checksum = 0;
        checksum = this.runningChecksum(checksum, sourceIpAddress);
        checksum = this.runningChecksum(checksum, destIpAddress);
        checksum = this.runningChecksum(checksum, 17);
        checksum = this.runningChecksum(checksum, 8 + udpBytes.length);
        checksum = this.runningChecksum(checksum, sourcePort);
        checksum = this.runningChecksum(checksum, destPort);
        checksum = this.runningChecksum(checksum, 8 + udpBytes.length);
        checksum = this.runningChecksum(checksum, udpBytes);
        checksum = ~checksum & 0xFFFF;
        if (debugOutput) {
            System.out.println("  ~ck:" + Integer.toHexString(checksum));
        }
        UdpMulticastMessage.writeInt(out, sourcePort);
        UdpMulticastMessage.writeInt(out, destPort);
        UdpMulticastMessage.writeInt(out, 8 + udpBytes.length);
        UdpMulticastMessage.writeInt(out, checksum);
        out.write(udpBytes, 0, udpBytes.length);
        this.bytes = out.toByteArray();
    }

    static void writeInt(ByteArrayOutputStream out, int v) {
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
    }

    final int runningChecksum(int int1, int int2) {
        int sum = int1 + int2;
        if (sum > 65535) {
            ++sum;
        }
        if (this.traceChecksum) {
            System.out.println("  ck:" + Integer.toHexString(sum & 0xFFFF));
        }
        return sum & 0xFFFF;
    }

    final int runningChecksum(int startingCheckSum, byte[] bytes) {
        int checkSum = startingCheckSum;
        for (int i = 0; i < bytes.length; i += 2) {
            int word = (bytes[i] & 0xFF) << 8;
            if (i + 1 < bytes.length) {
                word += bytes[i + 1] & 0xFF;
            }
            checkSum = this.runningChecksum(checkSum, word);
        }
        return checkSum;
    }

    public String toString() {
        if (this.bytes == null) {
            return "UdpMulticastMessage:null";
        }
        return "UdpMulticastMessage:" + ByteArrayUtil.toHexString((byte[])this.bytes);
    }

    public final byte[] getBytes() {
        return this.bytes;
    }
}

