/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.knxDataDefs;

import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.knxDataDefs.BDefaultDef;
import com.tridiumX.knxnetIp.knxDataDefs.BEnumDef;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefsStatusEnum;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxImportableComponent;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxStationDataDefs;
import com.tridiumX.knxnetIp.knxDataDefs.DataIntegrityCalculator;
import com.tridiumX.knxnetIp.knxDataDefs.IDataIntegrity;
import com.tridiumX.knxnetIp.knxDataDefs.IKnxDataDefs;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import java.security.NoSuchAlgorithmException;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="xmlNameSpace", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="id", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="version", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="signature", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=5)})
public final class BKnxDataDefs
extends BKnxImportableComponent
implements IKnxDataDefs,
IDataIntegrity {
    public static final Property xmlNameSpace = BKnxDataDefs.newProperty((int)1, (String)"", null);
    public static final Property id = BKnxDataDefs.newProperty((int)1, (String)"", null);
    public static final Property version = BKnxDataDefs.newProperty((int)1, (String)"", null);
    public static final Property signature = BKnxDataDefs.newProperty((int)5, (String)"", null);
    public static final Type TYPE = Sys.loadType(BKnxDataDefs.class);
    private static final String DATA_DEFS_ADMIN_INTEGRITY_CALCULATOR_CLIENT_CLASS_NAME = "com.tridiumX.knxDefsAdmin.dataDefs.db.ui.BKnxDataDefsExportDialog";
    private final Object integrityCheckLock = new Object();
    private static final String NO_REMOVE_DATA_VALUE_TYPE_IN_USE_LEX_KEY = "noRemove.DataValueTypeInUse";

    @Override
    public String getXmlNameSpace() {
        return this.getString(xmlNameSpace);
    }

    public void setXmlNameSpace(String v) {
        this.setString(xmlNameSpace, v, null);
    }

    public String getId() {
        return this.getString(id);
    }

    public void setId(String v) {
        this.setString(id, v, null);
    }

    @Override
    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    @Override
    public String getSignature() {
        return this.getString(signature);
    }

    public void setSignature(String v) {
        this.setString(signature, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void checkRemove(Property property, Context context) {
        BComplex grandParent;
        BComplex parent;
        super.checkRemove(property, context);
        BValue val = this.get(property);
        if (val instanceof BDataValueTypeDef && (parent = this.getParent()) instanceof BKnxStationDataDefs && (grandParent = parent.getParent()) != null && grandParent instanceof BKnxNetwork) {
            BDevice[] devices;
            BKnxNetwork network = (BKnxNetwork)grandParent;
            for (BDevice bDevice : devices = network.getDevices()) {
                BControlPoint[] points;
                if (!(bDevice instanceof BKnxDevice)) continue;
                BKnxDevice device = (BKnxDevice)bDevice.as(BKnxDevice.class);
                for (BControlPoint point : points = device.getPoints().getPoints()) {
                    BKnxProxyExt proxyExt = (BKnxProxyExt)point.getProxyExt();
                    if (!proxyExt.getDataValueTypeId().equals(((BDataValueTypeDef)val).getKNX_ID())) continue;
                    throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), NO_REMOVE_DATA_VALUE_TYPE_IN_USE_LEX_KEY);
                }
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxStationDataDefs;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BDefaultDef || child instanceof BEnumDef || child instanceof BDataValueTypeDef;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        this.setDataDefsStatusToUnknown();
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        this.setDataDefsStatusToUnknown();
    }

    public void reordered(Context context) {
        super.reordered(context);
        this.setDataDefsStatusToUnknown();
    }

    private void setDataDefsStatusToUnknown() {
        BComplex parent = this.getParent();
        if (parent instanceof BKnxStationDataDefs) {
            ((BKnxStationDataDefs)parent).setStatus(BKnxDataDefsStatusEnum.unknownDataDefsStatus);
            ((BKnxStationDataDefs)parent).dataDefsStatusChanged();
        }
    }

    @Override
    public void calcDataIntegrity(DataIntegrityCalculator calc) {
        calc.update(this.getXmlNameSpace());
        calc.update(this.getId());
        calc.update(this.getVersion());
        calc.update("???");
        calc.update(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BKnxDataDefsStatusEnum calculateDataIntegrityStatus(Object caller) {
        String moduleName;
        if (caller instanceof BObject && ((moduleName = ((BObject)caller).getType().getModule().getModuleName()).equals(this.getType().getModule().getModuleName()) || moduleName.equals("knxDefsAdmin"))) {
            try {
                Object object = this.integrityCheckLock;
                synchronized (object) {
                    this.loadSlots();
                    if (this.getDataValueTypeDefs().length > 0) {
                        DataIntegrityCalculator calc = DataIntegrityCalculator.make("MD5");
                        long startTicks = Clock.ticks();
                        this.calcDataIntegrity(calc);
                        long endTicks = Clock.ticks();
                        BKnxStationDataDefs parent = (BKnxStationDataDefs)this.getParent();
                        if (parent != null) {
                            parent.updateIntegrityChecksStatistics(endTicks - startTicks);
                        }
                        byte[] result = calc.digest();
                        String sResult = ByteArrayUtil.toHexString((byte[])result);
                        if (parent == null && "???".equals(this.getSignature())) {
                            StackTraceElement ste;
                            String callerClassName = ((BObject)caller).getType().getTypeInfo().getTypeClassName();
                            if (callerClassName.equals(DATA_DEFS_ADMIN_INTEGRITY_CALCULATOR_CLIENT_CLASS_NAME) && (ste = BKnxDataDefs.getStackTraceElement()).getClassName().startsWith(callerClassName)) {
                                this.setSignature(sResult);
                                return BKnxDataDefsStatusEnum.goodDataDefs;
                            }
                            return BKnxDataDefsStatusEnum.unableToCalculate;
                        }
                        if (sResult.equals(this.getSignature())) {
                            return BKnxDataDefsStatusEnum.goodDataDefs;
                        }
                        return BKnxDataDefsStatusEnum.damagedOrCorruptedDataDefs;
                    }
                    return BKnxDataDefsStatusEnum.missingDataDefs;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return BKnxDataDefsStatusEnum.unableToCalculate;
    }

    private static StackTraceElement getStackTraceElement() {
        try {
            StackTraceElement[] stes = new Throwable().getStackTrace();
            for (int i = 1; i < stes.length; ++i) {
                StackTraceElement ste = stes[i];
                if (ste.getClassName().equals(stes[0].getClassName())) continue;
                return ste;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public String getDefaultDatapointTypeForSize(BKnxComObjectSizeEnum comObjectSize) {
        BDefaultDef[] defaults;
        for (BDefaultDef defaultDef : defaults = (BDefaultDef[])this.getChildren(BDefaultDef.class)) {
            defaultDef.loadSlots();
            if (!defaultDef.getComObjectSize().equals((Object)comObjectSize)) continue;
            return defaultDef.getDatapointSubtypeId();
        }
        return "DPST-0-" + comObjectSize.getOrdinal();
    }

    public String getDefaultDatapointTypeForType(String datapointTypeId) {
        if (datapointTypeId.startsWith("DPT-")) {
            BDataValueTypeDef[] dvtDefs;
            String dsPrefix = TextUtil.replace((String)datapointTypeId, (String)"DPT-", (String)"DPST-");
            for (BDataValueTypeDef dvtDef : dvtDefs = (BDataValueTypeDef[])this.getChildren(BDataValueTypeDef.class)) {
                dvtDef.loadSlots();
                if (!dvtDef.getKNX_ID().startsWith(dsPrefix)) continue;
                return dvtDef.getKNX_ID();
            }
        }
        return "";
    }

    public BEnumDef getEnumDef(int enumDefId) {
        BEnumDef[] dataEncodingEnums;
        String sDataEncodingEnum_ID = "DEE." + enumDefId;
        for (BEnumDef dataEncodingEnum : dataEncodingEnums = (BEnumDef[])this.getChildren(BEnumDef.class)) {
            dataEncodingEnum.loadSlots();
            if (!sDataEncodingEnum_ID.equals(dataEncodingEnum.getEnumId())) continue;
            return dataEncodingEnum;
        }
        return null;
    }

    public BDataValueTypeDef getDataValueTypeDef(String dataValueTypeDefId) {
        BKnxDataDefs container = this;
        String[] a = TextUtil.split((String)dataValueTypeDefId, (char)'-');
        if (a.length == 4) {
            String datapointSubtype_ID = dataValueTypeDefId.substring(0, dataValueTypeDefId.lastIndexOf(45));
            container = (BComponent)this.get(SlotPath.escape((String)datapointSubtype_ID));
        }
        if (a.length == 2) {
            BDataValueTypeDef[] defs;
            String searchString = TextUtil.replace((String)dataValueTypeDefId, (String)"DPT-", (String)"DPST-");
            for (BDataValueTypeDef def : defs = this.getDataValueTypeDefs()) {
                def.loadSlots();
                String defId = def.getKNX_ID();
                if (!defId.startsWith(searchString)) continue;
                return def;
            }
        }
        if (container != null) {
            return (BDataValueTypeDef)container.get(SlotPath.escape((String)dataValueTypeDefId));
        }
        return null;
    }

    public BDataValueTypeDef[] getDataValueTypeDefs() {
        return (BDataValueTypeDef[])this.getChildren(BDataValueTypeDef.class);
    }
}

