/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.point.BIKnxPollable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="nonScheduledPolls", type="int", defaultValue="0", flags=3)
public class BKnxPollScheduler
extends BPollScheduler {
    public static final Property nonScheduledPolls = BKnxPollScheduler.newProperty((int)3, (int)0, null);
    public static final Type TYPE = Sys.loadType(BKnxPollScheduler.class);
    final AtomicInteger unscheduledCounter = new AtomicInteger();

    public int getNonScheduledPolls() {
        return this.getInt(nonScheduledPolls);
    }

    public void setNonScheduledPolls(int v) {
        this.setInt(nonScheduledPolls, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxNetwork;
    }

    public void doPoll(BIPollable p) throws Exception {
        boolean shouldPoll;
        try {
            BKnxNetwork net = (BKnxNetwork)this.getParent();
            shouldPoll = !net.isDisabled() && !net.isDown() && !net.isFault();
        }
        catch (Exception e) {
            shouldPoll = true;
        }
        if (!shouldPoll) {
            return;
        }
        BIKnxPollable dev = (BIKnxPollable)p;
        try {
            if (((BDeviceNetwork)this.getParent()).getLogger().isLoggable(Level.FINE)) {
                ((BDeviceNetwork)this.getParent()).getLogger().fine("Poll <" + p + ">");
            }
        }
        catch (Exception e) {
            System.out.println("Exception when trying to Log 'Poll <???>' - " + e);
        }
        try {
            dev.poll();
        }
        catch (NotRunningException e) {
            this.unsubscribe(dev);
        }
    }

    public void doResetStatistics() {
        super.doResetStatistics();
        this.setNonScheduledPolls(0);
    }

    public void incrementUnscheduledPolls() {
        this.setNonScheduledPolls(this.unscheduledCounter.incrementAndGet());
    }
}

