/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.util;

import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public abstract class Dump {
    private Dump() {
    }

    public static void d(String s) {
        System.out.println(s);
    }

    public static String dump(Object[] obj) {
        return Dump.dump(obj, "");
    }

    public static String dump(Object[] obj, String prefix) {
        StringBuilder sb = new StringBuilder(prefix).append(obj.getClass().getName()).append("\n");
        for (int i = 0; i < obj.length; ++i) {
            sb.append(prefix).append("\t").append(obj[i].getClass().getName()).append("\t").append("obj[" + i + "] = ").append(obj[i].toString()).append("\n");
        }
        return sb.toString();
    }

    public static String dump(BComponentEvent event) {
        return Dump.dump(event, "");
    }

    public static String dump(BComponentEvent event, String prefix) {
        StringBuilder sb = new StringBuilder(prefix).append(event.getType().getTypeName()).append("\n");
        sb.append(prefix).append(event.toString(null));
        return sb.toString();
    }

    public static String dump(BComplex obj) {
        return Dump.dump(obj, "");
    }

    public static String dump(BComplex obj, String prefix) {
        StringBuilder sb = new StringBuilder(prefix).append(obj.getType().getTypeName()).append("\n");
        SlotCursor c = obj.getProperties();
        while (c.next()) {
            if (c.get() instanceof BComplex) {
                sb.append(prefix).append("\t").append(((Property)c.slot()).getName()).append(" = ").append(Dump.dump((BComplex)c.get(), "\t" + prefix));
                continue;
            }
            sb.append(prefix).append("\t").append(((Property)c.slot()).getName()).append(" = ").append(c.get().toString()).append("\n");
        }
        return sb.toString();
    }

    public static String dumpVec(BVector v) {
        StringBuilder sb = new StringBuilder();
        SlotCursor c = v.getProperties();
        while (c.next()) {
            sb.append(c.get().toString()).append(';');
        }
        return sb.toString();
    }

    public static void dumpAgents(BObject obj) {
        AgentFilter filter = AgentFilter.is((Type)BObject.TYPE);
        AgentList agents = obj.getAgents(null).filter(filter);
        AgentInfo[] agentInfos = agents.list();
        for (int i = 0; i < agentInfos.length; ++i) {
            AgentInfo agentInfo = agentInfos[i];
            System.out.println("agentInfos[" + i + "].toString() = " + agentInfo.toString());
            System.out.println("agentInfos[" + i + "].getAgentId() = " + agentInfo.getAgentId());
            System.out.println("agentInfos[" + i + "].getAgentType() = " + agentInfo.getAgentType());
            System.out.println("agentInfos[" + i + "].getAgentType().getTypeClassName() = " + agentInfo.getAgentType().getTypeClassName());
            System.out.println("agentInfos[" + i + "].getAppName() = " + agentInfo.getAppName());
            System.out.println("agentInfos[" + i + "].getDisplayName(null) = " + agentInfo.getDisplayName(null));
        }
    }
}

