/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.util;

import com.tridium.driver.util.DrUtil;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.job.BIJobService;
import javax.baja.job.BJobService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Type;

public final class ThreadPriorityUtil {
    private static final Map<Thread, BComponent> OVERRIDE_THREADS = new ConcurrentHashMap<Thread, BComponent>();
    public static final String THREAD_PRIORITY_PROPERTY_NAME = "rxThreadPriority";
    private static final int MAX_OVERRIDE_PRIORITY = 7;
    private static final int MIN_OVERRIDE_PRIORITY = 1;
    private static final int DEFAULT_OVERRIDE_PRIORITY = 5;
    private static final int NOT_DEFINED = -1;
    private static final Object MUTEX = new Object();
    private static final Logger LOG = Logger.getLogger(BKnxNetwork.TYPE.getModule().getModuleName() + ".ThreadPrtyUtil");
    private static final JobServiceSubscriber subscriber = new JobServiceSubscriber();
    private static final StationSaveListener saveListener = new StationSaveListener();
    private static boolean enabled;
    private static boolean setup;
    private static BIJobService jobService;

    private ThreadPriorityUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnabled(boolean enabledVal) {
        Object object = MUTEX;
        synchronized (object) {
            enabled = enabledVal;
            ThreadPriorityUtil.logFine(() -> "ThreadPriorityUtil enabled: " + enabled);
            if (enabled && !setup) {
                try {
                    ThreadPriorityUtil.subscribeJobService();
                    Station.addSaveListener((Station.SaveListener)saveListener);
                    setup = true;
                }
                catch (ServiceNotFoundException e) {
                    LOG.log(Level.WARNING, ThreadPriorityUtil.class.getSimpleName() + " failed to find JobService", e);
                }
            }
        }
    }

    public static void registerThread(BComponent component) {
        if (!enabled) {
            return;
        }
        Thread fred = Thread.currentThread();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(() -> "registerThread: " + Thread.currentThread().getName());
        }
        if (!OVERRIDE_THREADS.containsKey(fred)) {
            OVERRIDE_THREADS.put(fred, component);
            ThreadPriorityUtil.logFine(() -> "Registered thread: " + Thread.currentThread().getName());
        }
    }

    private static void subscribeJobService() {
        jobService = BJobService.getService();
        subscriber.subscribe(jobService.asObject().asComponent());
        LOG.fine("ThreadPriorityUtil subscribed to JobService");
    }

    public static void slotAdded(BComponent component) {
        Slot prioritySlot = component.getSlot(THREAD_PRIORITY_PROPERTY_NAME);
        if (prioritySlot != null) {
            BFacets facets = component.getSlotFacets(prioritySlot);
            facets = BFacets.make((BFacets)facets, (String)"min", (BIDataValue)BInteger.make((int)1));
            facets = BFacets.make((BFacets)facets, (String)"max", (BIDataValue)BInteger.make((int)7));
            component.setFacets(prioritySlot, facets);
            component.set(THREAD_PRIORITY_PROPERTY_NAME, (BValue)BInteger.make((int)5));
        }
    }

    private static void cleanOldThreads() {
        int threads = OVERRIDE_THREADS.size();
        OVERRIDE_THREADS.keySet().removeIf(fred -> !fred.isAlive());
        ThreadPriorityUtil.logFine(() -> "Cleaned " + (threads - OVERRIDE_THREADS.size()) + " threads");
    }

    private static void logFine(Supplier<String> logSupplier) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(logSupplier);
        }
    }

    static class StationSaveListener
    implements Station.SaveListener {
        StationSaveListener() {
        }

        public void stationSave() throws Exception {
        }

        public void stationSaveOk() throws Exception {
            StationSaveListener.restoreDefaultThreadPriorities();
        }

        public void stationSaveFail(String s) throws Exception {
            StationSaveListener.restoreDefaultThreadPriorities();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void restoreDefaultThreadPriorities() {
            if (enabled) {
                Object object = MUTEX;
                synchronized (object) {
                    ThreadPriorityUtil.cleanOldThreads();
                    OVERRIDE_THREADS.keySet().forEach(thread -> {
                        ThreadPriorityUtil.logFine(() -> "Restoring default ThreadPriority on " + thread.getName());
                        thread.setPriority(5);
                    });
                }
            }
        }
    }

    static class JobServiceSubscriber
    extends Subscriber {
        JobServiceSubscriber() {
        }

        public void event(BComponentEvent event) {
            if (enabled && event.getId() == 1 && event.getValue().getType().is(BStationSaveJob.TYPE)) {
                ThreadPriorityUtil.cleanOldThreads();
                OVERRIDE_THREADS.entrySet().stream().filter(entry -> ((Thread)entry.getKey()).isAlive()).forEach(entry -> {
                    Thread fred = (Thread)entry.getKey();
                    int overridePriority = JobServiceSubscriber.getRxThreadOverridePriority((BComponent)entry.getValue());
                    if (overridePriority != -1 && fred.getPriority() != overridePriority) {
                        ThreadPriorityUtil.logFine(() -> String.format("Overriding ThreadPriority on: %s to: %s", fred.getName(), overridePriority));
                        fred.setPriority(overridePriority);
                    }
                });
            }
        }

        private static int getRxThreadOverridePriority(BComponent component) {
            BComplex device = DrUtil.getParent((BComplex)component, (Type)BKnxDevice.TYPE);
            BValue priorityVal = device.get(ThreadPriorityUtil.THREAD_PRIORITY_PROPERTY_NAME);
            int priority = JobServiceSubscriber.getThreadPriority(priorityVal);
            if (priority == -1) {
                BComplex network = DrUtil.getParent((BComplex)component, (Type)BKnxNetwork.TYPE);
                priorityVal = network.get(ThreadPriorityUtil.THREAD_PRIORITY_PROPERTY_NAME);
                priority = JobServiceSubscriber.getThreadPriority(priorityVal);
            }
            return priority;
        }

        private static int getThreadPriority(BValue priorityVal) {
            if (priorityVal instanceof BNumber) {
                int priority = ((BNumber)priorityVal).getInt();
                priority = Math.min(priority, 7);
                priority = Math.max(priority, 1);
                return priority;
            }
            return -1;
        }
    }
}

