/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.server.management;

import com.tridium.ndriver.util.SfUtil;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.xprotect.BMilestoneXProtectNetwork;
import com.tridium.xprotect.camera.BXProtectCamera;
import com.tridium.xprotect.datatypes.BXProtectAuthAttributes;
import com.tridium.xprotect.datatypes.BXProtectAuthConfig;
import com.tridium.xprotect.datatypes.BXProtectAuthType;
import com.tridium.xprotect.datatypes.BXProtectConnectionEvent;
import com.tridium.xprotect.datatypes.BXProtectConnectionState;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.soap.IMIPService;
import com.tridium.xprotect.soap.LoginAttributes;
import com.tridium.xprotect.util.WebProcessUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.naming.ConfigurationException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Element;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostName", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="webClientHttpPort", type="String", defaultValue="BXProtectManagementConnection.DEFAULT_HTTP_PORT_VALUE", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="webClientHttpsPort", type="String", defaultValue="BXProtectManagementConnection.DEFAULT_HTTPS_PORT_VALUE", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="auth", type="BXProtectAuthConfig", defaultValue="new BXProtectAuthConfig()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN)")}), @NiagaraProperty(name="connectionState", type="BXProtectConnectionState", defaultValue="BXProtectConnectionState.disconnected", flags=3), @NiagaraProperty(name="authAttributes", type="BXProtectAuthAttributes", defaultValue="new BXProtectAuthAttributes()", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="connect"), @NiagaraAction(name="disconnect")})
@NiagaraTopic(name="connectionEvent", eventType="BXProtectConnectionEvent")
public class BXProtectManagementConnection
extends BComponent {
    @Generated
    public static final Property hostName = BXProtectManagementConnection.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property webClientHttpPort = BXProtectManagementConnection.newProperty((int)0, (String)"8081", (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property webClientHttpsPort = BXProtectManagementConnection.newProperty((int)0, (String)"8082", (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property auth = BXProtectManagementConnection.newProperty((int)0, (BValue)new BXProtectAuthConfig(), (BFacets)SfUtil.incl((String)"ed.un"));
    @Generated
    public static final Property connectionState = BXProtectManagementConnection.newProperty((int)3, (BValue)BXProtectConnectionState.disconnected, null);
    @Generated
    public static final Property authAttributes = BXProtectManagementConnection.newProperty((int)3, (BValue)new BXProtectAuthAttributes(), null);
    @Generated
    public static final Action connect = BXProtectManagementConnection.newAction((int)0, null);
    @Generated
    public static final Action disconnect = BXProtectManagementConnection.newAction((int)0, null);
    @Generated
    public static final Topic connectionEvent = BXProtectManagementConnection.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BXProtectManagementConnection.class);
    private BXProtectConnectionState originalState = null;
    private Clock.Ticket reconnectTicket = null;
    private Logger logger = Logger.getLogger(WebProcessUtil.class.getName());
    private static final String DEFAULT_HTTP_PORT_VALUE = "8081";
    private static final String DEFAULT_HTTPS_PORT_VALUE = "8082";

    @Generated
    public String getHostName() {
        return this.getString(hostName);
    }

    @Generated
    public void setHostName(String v) {
        this.setString(hostName, v, null);
    }

    @Generated
    public String getWebClientHttpPort() {
        return this.getString(webClientHttpPort);
    }

    @Generated
    public void setWebClientHttpPort(String v) {
        this.setString(webClientHttpPort, v, null);
    }

    @Generated
    public String getWebClientHttpsPort() {
        return this.getString(webClientHttpsPort);
    }

    @Generated
    public void setWebClientHttpsPort(String v) {
        this.setString(webClientHttpsPort, v, null);
    }

    @Generated
    public BXProtectAuthConfig getAuth() {
        return (BXProtectAuthConfig)this.get(auth);
    }

    @Generated
    public void setAuth(BXProtectAuthConfig v) {
        this.set(auth, (BValue)v, null);
    }

    @Generated
    public BXProtectConnectionState getConnectionState() {
        return (BXProtectConnectionState)this.get(connectionState);
    }

    @Generated
    public void setConnectionState(BXProtectConnectionState v) {
        this.set(connectionState, (BValue)v, null);
    }

    @Generated
    public BXProtectAuthAttributes getAuthAttributes() {
        return (BXProtectAuthAttributes)this.get(authAttributes);
    }

    @Generated
    public void setAuthAttributes(BXProtectAuthAttributes v) {
        this.set(authAttributes, (BValue)v, null);
    }

    @Generated
    public void connect() {
        this.invoke(connect, null, null);
    }

    @Generated
    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Generated
    public void fireConnectionEvent(BXProtectConnectionEvent event) {
        this.fire(connectionEvent, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BXProtectManagementServer;
    }

    BXProtectManagementServer getServer() {
        return (BXProtectManagementServer)this.getParent();
    }

    public void stopped() throws Exception {
        this.disconnect();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == auth || property == hostName) {
            if (this.isConnected()) {
                this.doDisconnect();
                this.doConnect();
            } else {
                this.setAuthAttributes(new BXProtectAuthAttributes());
            }
        }
    }

    public void doConnect() {
        this.getServer().postAsync(new Runnable(){

            @Override
            public void run() {
                BXProtectManagementConnection.this.tryConnectSync();
                BIVideoCamera[] cameras = BXProtectManagementConnection.this.getServer().getCameras().getAllCameras();
                if (cameras != null && cameras.length > 0) {
                    for (int i = 0; i < cameras.length; ++i) {
                        BXProtectCamera xprotectCamera = (BXProtectCamera)cameras[i];
                        xprotectCamera.doPing();
                    }
                }
            }
        });
    }

    public void doDisconnect() {
        if (this.isConnecting()) {
            this.logger.log(Level.INFO, "Disconnect invoked while connecting?!");
        }
        try {
            this.logout();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception occurred during logout", e);
        }
        finally {
            this.setConnectionState(BXProtectConnectionState.disconnected);
            this.setAuthAttributes(new BXProtectAuthAttributes());
        }
    }

    public void tryConnectSync() {
        try {
            this.originalState = this.getConnectionState();
            if (!this.isRunning()) {
                return;
            }
            if (this.isConnecting()) {
                return;
            }
            if (this.getServer() == null) {
                throw new ConfigurationException("Parent server is null");
            }
            if (!this.getServer().getEnabled()) {
                return;
            }
            if (this.getServer().isFatalFault()) {
                return;
            }
            if (this.getServer().getNetwork() == null) {
                throw new ConfigurationException("Parent network is null");
            }
            if (!this.getServer().getNetwork().getEnabled()) {
                return;
            }
            if (this.getServer().getNetwork().isFault()) {
                return;
            }
            this.setConnectionState(BXProtectConnectionState.connecting);
            this.connectSync();
        }
        catch (SOAPFaultException e) {
            String msg = "Unexpected exception on login: " + e.getMessage();
            String type = this.tryFaultType(e.getFault());
            if (type != null) {
                msg = type.contains("InvalidCredentialsMIPException") ? "Invalid Credentials" : (type.contains("ServerNotFoundMIPException") ? "Could not connect to server at: " + this.getHostName() : (type.contains("InvalidOperationException") ? "Invalid address: " + this.getHostName() : "Login exception: " + type));
            }
            this.pingFail(msg);
        }
        catch (ConfigurationException e) {
            this.configFail(e.getMessage(), e);
        }
        catch (WebServiceException e) {
            this.configFail(e.getMessage(), e);
        }
        catch (Exception e) {
            String msg = "Invalid Credentials, Invalid address or Could not connect to server at: " + this.getHostName() + ". Error message: " + e.getMessage();
            this.pingFail(msg);
        }
    }

    private void connectSync() throws ConfigurationException {
        this.cancelReconnect();
        this.validateTcpConfig();
        this.validateAuthConfig();
        this.login();
    }

    private String tryFaultType(SOAPFault fault) {
        if (fault == null) {
            return null;
        }
        Element detail = (Element)fault.getElementsByTagName("detail").item(0);
        if (detail == null) {
            return null;
        }
        Element exDetail = (Element)detail.getElementsByTagName("ExceptionDetail").item(0);
        if (exDetail == null) {
            return null;
        }
        Element type = (Element)exDetail.getElementsByTagName("Type").item(0);
        if (type == null) {
            return null;
        }
        return type.getTextContent();
    }

    private void login() {
        boolean useTls = ((BMilestoneXProtectNetwork)this.getServer().getNetwork()).getHttpConfig().getUseTls();
        IMIPService service = WebProcessUtil.getService(useTls);
        BXProtectAuthConfig auth = this.getAuth();
        String uri = this.getUri();
        try {
            AccessController.doPrivileged(() -> {
                service.logout(uri);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Exception inner = e.getException();
            this.logger.log(Level.SEVERE, "Exception on logout (on connect) : " + e.getLocalizedMessage());
            inner.printStackTrace();
        }
        LoginAttributes la = this.getAuth().getAuthType().equals((Object)BXProtectAuthType.basic) ? AccessController.doPrivileged(() -> service.loginBasic(auth.getUsername(), auth.getPassword().getValue(), uri)) : AccessController.doPrivileged(() -> service.loginWindows(auth.getDomain(), auth.getUsername(), auth.getPassword().getValue(), uri));
        this.connectOk(la);
    }

    private void logout() {
        AccessController.doPrivileged(() -> {
            boolean useTls = ((BMilestoneXProtectNetwork)this.getServer().getNetwork()).getHttpConfig().getUseTls();
            WebProcessUtil.getService(useTls).logout(this.getUri());
            return null;
        });
    }

    private void validateTcpConfig() throws ConfigurationException {
        if (this.getHostName().length() == 0) {
            throw new ConfigurationException("Empty host name.");
        }
        try {
            new URL("http://" + this.getHostName() + "/");
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid host name: " + e.getMessage());
        }
    }

    private void validateAuthConfig() throws ConfigurationException {
        if (this.getAuth().getUsername().length() == 0) {
            throw new ConfigurationException("Empty user name");
        }
    }

    public boolean isConnecting() {
        return this.getConnectionState().equals((Object)BXProtectConnectionState.connecting);
    }

    public boolean isConnected() {
        return this.getConnectionState().equals((Object)BXProtectConnectionState.connected);
    }

    private void pingFail(String cause) {
        this.getServer().pingFail(cause);
        this.onError(cause, null);
    }

    private void configFail(String cause, Exception e) {
        this.getServer().configFail(cause != null ? cause : "null connection exception message");
        this.onError(cause, e);
    }

    private void onError(String cause, Exception e) {
        this.setAuthAttributes(new BXProtectAuthAttributes());
        this.setConnectionState(BXProtectConnectionState.disconnected);
        if (this.originalState.equals((Object)BXProtectConnectionState.connected)) {
            this.fireConnectionEvent(new BXProtectConnectionEvent(this.originalState, BXProtectConnectionState.disconnected));
        }
        this.logger.log(Level.WARNING, "DVR Connection Fail: " + cause, e);
    }

    private void connectOk(LoginAttributes loginAttributes) {
        this.getAuthAttributes().setToken(loginAttributes.getToken().getValue());
        long tokenExpire = Long.parseLong(loginAttributes.getTokenTimeToLive().getValue());
        this.getAuthAttributes().setTokenExpiration(BAbsTime.now().add(BRelTime.make((long)tokenExpire)));
        this.getAuthAttributes().setUri(loginAttributes.getUri().getValue());
        this.getAuthAttributes().setServerId(loginAttributes.getServerid().getValue());
        this.setConnectionState(BXProtectConnectionState.connected);
        this.getServer().configOk();
        this.getServer().pingOk();
        if (this.originalState.equals((Object)BXProtectConnectionState.disconnected)) {
            this.fireConnectionEvent(new BXProtectConnectionEvent(this.originalState, BXProtectConnectionState.connected));
        }
        this.cancelReconnect();
        BRelTime reconnectTime = BRelTime.make((long)(tokenExpire > 60000L ? tokenExpire - 60000L : tokenExpire));
        this.reconnectTicket = Clock.schedule((BComponent)this, (BRelTime)reconnectTime, (Action)connect, null);
        this.logger.log(Level.INFO, "DVR Connect ok (until " + this.getAuthAttributes().getTokenExpiration() + ")");
    }

    public String toString(Context context) {
        return this.getHostName() + " - " + this.getConnectionState().getDisplayTag(context);
    }

    public String getUri() {
        if (this.isConnected()) {
            return this.getAuthAttributes().getUri();
        }
        return "http://" + this.getHostName() + "/";
    }

    public Element getCameras(boolean userHierarchy) throws Exception {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not Connected");
        }
        String serverId = this.getAuthAttributes().getServerId();
        boolean useTls = ((BMilestoneXProtectNetwork)this.getServer().getNetwork()).getHttpConfig().getUseTls();
        if (userHierarchy) {
            return AccessController.doPrivileged(() -> (Element)WebProcessUtil.getService(useTls).getCamerasUser(serverId).getAny());
        }
        return AccessController.doPrivileged(() -> (Element)WebProcessUtil.getService(useTls).getCamerasSystem(serverId).getAny());
    }

    public Element getServers() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not Connected");
        }
        String serverId = this.getAuthAttributes().getServerId();
        boolean useTls = ((BMilestoneXProtectNetwork)this.getServer().getNetwork()).getHttpConfig().getUseTls();
        return AccessController.doPrivileged(() -> (Element)WebProcessUtil.getService(useTls).getServers(serverId).getAny());
    }

    private void cancelReconnect() {
        if (this.reconnectTicket != null) {
            this.reconnectTicket.cancel();
        }
        this.reconnectTicket = null;
    }
}

