/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.server.recording;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.util.AgentInfoUtil;
import com.tridium.nvideo.recordingServer.BVideoRecordingServerDeviceExt;
import com.tridium.xprotect.server.management.BXProtectManagementConnection;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.server.recording.BXProtectRecordingServer;
import com.tridium.xprotect.server.recording.BXProtectRecordingServerDiscoveryLeaf;
import com.tridium.xprotect.server.recording.BXProtectRecordingServerDiscoveryPreferences;
import com.tridium.xprotect.server.recording.BXProtectRecordingServerFolder;
import com.tridium.xprotect.server.recording.BXProtectRecordingServerId;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@NiagaraType
@NiagaraProperty(name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BXProtectRecordingServerDiscoveryPreferences()")
@NiagaraAction(name="submitDiscoveryJob", parameterType="BNDiscoveryPreferences", defaultValue="new BNDiscoveryPreferences()", returnType="BOrd", flags=4)
public class BXProtectRecordingServerDeviceExt
extends BVideoRecordingServerDeviceExt
implements BINDiscoveryHost {
    @Generated
    public static final Property discoveryPreferences = BXProtectRecordingServerDeviceExt.newProperty((int)0, (BValue)new BXProtectRecordingServerDiscoveryPreferences(), null);
    @Generated
    public static final Action submitDiscoveryJob = BXProtectRecordingServerDeviceExt.newAction((int)4, (BValue)new BNDiscoveryPreferences(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BXProtectRecordingServerDeviceExt.class);
    XPathFactory xPathfactory = XPathFactory.newInstance();
    XPath xpath = this.xPathfactory.newXPath();

    @Generated
    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    @Generated
    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    @Generated
    public BOrd submitDiscoveryJob(BNDiscoveryPreferences parameter) {
        return (BOrd)this.invoke(submitDiscoveryJob, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        return AgentInfoUtil.getAgentsHelp((AgentList)agents, (String)this.getType().getTypeInfo().getModuleName(), (String)"ndriver:NDeviceManager", (String)"DeviceManager", (String)"Device Manager");
    }

    public Type getDeviceType() {
        return BXProtectRecordingServer.TYPE;
    }

    public Type getDeviceFolderType() {
        return BXProtectRecordingServerFolder.TYPE;
    }

    public BOrd doSubmitDiscoveryJob(BNDiscoveryPreferences preferences) {
        this.setDiscoveryPreferences((BXProtectRecordingServerDiscoveryPreferences)preferences.newCopy());
        BNDiscoveryJob discoveryJob = new BNDiscoveryJob((BINDiscoveryHost)this);
        discoveryJob.setDiscoveryPreferences((BNDiscoveryPreferences)preferences.newCopy());
        return discoveryJob.submit(null);
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        BXProtectManagementServer dvr = (BXProtectManagementServer)this.getParent();
        BXProtectManagementConnection conn = dvr.getConnection();
        try {
            conn.tryConnectSync();
            Element root = conn.getServers();
            return this.getChildServers(root);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException("Unable to discover cameras in " + dvr.getDisplayName(null), (Throwable)e);
        }
    }

    private BXProtectRecordingServerDiscoveryLeaf[] getChildServers(Element parent) throws XPathExpressionException {
        NodeList list = parent.getChildNodes();
        if (list.getLength() == 0) {
            return new BXProtectRecordingServerDiscoveryLeaf[0];
        }
        BXProtectRecordingServerDiscoveryLeaf[] leafs = new BXProtectRecordingServerDiscoveryLeaf[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            leafs[i] = this.makeDiscoveryLeaf(element);
        }
        return leafs;
    }

    private BXProtectRecordingServerDiscoveryLeaf makeDiscoveryLeaf(Element element) throws XPathExpressionException {
        String name = this.xpath.compile("Name/text()").evaluate(element);
        String serverType = this.xpath.compile("FQID/ServerId/Type/text()").evaluate(element);
        String serverHost = this.xpath.compile("FQID/ServerId/Hostname/text()").evaluate(element);
        Double serverPort = (Double)this.xpath.compile("number(FQID/ServerId/Port/text())").evaluate(element, XPathConstants.NUMBER);
        String serverIdId = this.xpath.compile("FQID/ServerId/Id/text()").evaluate(element);
        BXProtectRecordingServerId serverId = BXProtectRecordingServerId.make(serverType, serverHost, serverPort.intValue(), serverIdId);
        serverId.setDescription(name);
        BXProtectRecordingServerDiscoveryLeaf leaf = new BXProtectRecordingServerDiscoveryLeaf();
        leaf.setId(serverId);
        leaf.setDiscoveryName(name);
        return leaf;
    }
}

