/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.util;

import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class ClientSideNativeLibraryLoader {
    public static Logger log = Logger.getLogger(ClientSideNativeLibraryLoader.class.getName());
    protected static String niagaraHomeBinStr;
    protected static File niagaraHomeBin;
    protected static boolean nativesLoaded;

    protected static void findNiagaraHomeBinDir() {
        niagaraHomeBinStr = Nre.getNiagaraHome().getAbsolutePath() + File.separator + "bin";
        niagaraHomeBin = new File(niagaraHomeBinStr);
    }

    protected static Boolean loadLibraryFromThisModule(String libName) {
        return AccessController.doPrivileged(() -> {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Extracting:> " + libName);
            }
            ClientSideNativeLibraryLoader.extractLibraryFromThisModule(libName);
            if (log.isLoggable(Level.FINE)) {
                log.fine("JNI Loading:> " + libName);
            }
            try {
                if (libName.contains(".dll")) {
                    System.loadLibrary(libName.substring(0, libName.indexOf(".dll")));
                }
                nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Could not load the third party library " + libName + " to client.", e);
            }
            return nativesLoaded;
        });
    }

    protected static void extractLibraryFromThisModule(String libName) {
        File libraryDest;
        BModule xprotectMod = Sys.loadModule((String)"xprotect");
        FilePath resourceFilePath = new FilePath("nativeLib/" + libName);
        BIFile resourceFile = xprotectMod.resolveFile(resourceFilePath);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "niagaraHomeBin = '" + niagaraHomeBin + "'");
        }
        if ((libraryDest = new File(niagaraHomeBin, libName)).exists()) {
            try {
                FileUtil.delete((File)libraryDest);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exception occurred while deleting the existing file '" + libName + "'", e);
            }
        }
        try (FileOutputStream libraryDestOut = new FileOutputStream(libraryDest);
             InputStream libraryBytesInJar = resourceFile.getInputStream();){
            int n;
            byte[] buf = new byte[40960];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Using 40K buffer for module read");
            }
            while ((n = libraryBytesInJar.read(buf)) != -1) {
                libraryDestOut.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException occurred while transferring '" + libName + "' to client", e);
        }
    }

    static {
        nativesLoaded = false;
        ClientSideNativeLibraryLoader.findNiagaraHomeBinDir();
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Platform.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("VideoOS.Platform.SDK.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("Autofac.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("XProtectBridgeService.exe");
    }
}

