/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.util;

import com.tridium.xprotect.util.ClientSideNativeLibraryLoader;
import com.tridium.xprotect.util.WebProcessUtil;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPMessageHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String CUSTOM_HEADER_NAME = "SessionId";
    private static final String CUSTOM_HEADER_NAMESPACE = "http://tempuri.org/";

    @Override
    public Set<QName> getHeaders() {
        return null;
    }

    @Override
    public boolean handleMessage(SOAPMessageContext context) {
        try {
            Boolean outBoundProperty = (Boolean)context.get("javax.xml.ws.handler.message.outbound");
            if (outBoundProperty.booleanValue()) {
                SOAPMessage soapMsg = context.getMessage();
                SOAPEnvelope soapEnv = soapMsg.getSOAPPart().getEnvelope();
                SOAPHeader soapHeader = soapEnv.getHeader();
                QName sessionId = new QName(CUSTOM_HEADER_NAMESPACE, CUSTOM_HEADER_NAME);
                SOAPHeaderElement soapHeaderElement = soapHeader.addHeaderElement(sessionId);
                soapHeaderElement.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                soapHeaderElement.addTextNode(WebProcessUtil.getSessionId());
                soapMsg.saveChanges();
                context.setMessage(soapMsg);
                if (ClientSideNativeLibraryLoader.log.isLoggable(Level.FINE)) {
                    ClientSideNativeLibraryLoader.log.fine("Sending SOAP Message");
                }
            } else if (ClientSideNativeLibraryLoader.log.isLoggable(Level.FINE)) {
                ClientSideNativeLibraryLoader.log.fine("Received SOAP Message");
            }
        }
        catch (SOAPException e) {
            ClientSideNativeLibraryLoader.log.log(Level.SEVERE, "Failed to handle incoming/outgoing soap messages", e);
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    @Override
    public void close(MessageContext context) {
    }
}

