/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.util;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.http.HttpUtil;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.comm.http.NHttpStream;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.VideoStream;
import com.tridium.xprotect.camera.BXProtectCamera;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import com.tridium.xprotect.messages.XProtectVideoStreamReq;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.util.XProtectTcpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BFacets;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class XProtectVideoStreamUtil {
    private static Logger logger = Logger.getLogger(XProtectVideoStreamUtil.class.getName());

    public static void sendStreamRequest(NMessage req, BXProtectCamera camera) {
        if (req instanceof XProtectVideoStreamReq) {
            try {
                XProtectVideoStreamUtil.establishVideoFeed((XProtectVideoStreamReq)req, camera);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void establishVideoFeed(XProtectVideoStreamReq videoStreamReq, BXProtectCamera camera) throws Exception {
        XProtectVideoStreamReq videoStreamReq1 = videoStreamReq;
        try {
            if (camera != null) {
                EstablishVideoConnection establishVideoConnection = new EstablishVideoConnection(videoStreamReq1, camera);
                establishVideoConnection.start();
                establishVideoConnection.join(30000L);
                if (establishVideoConnection.isAlive()) {
                    establishVideoConnection.interrupt();
                }
                if (establishVideoConnection.success) {
                    videoStreamReq1.setVideoSocket(establishVideoConnection.liveVideoSocket);
                } else {
                    videoStreamReq1.getVideoDestination().videoStreamTimeout();
                    if (establishVideoConnection.liveVideoSocket != null) {
                        establishVideoConnection.liveVideoSocket.close();
                    }
                }
            }
        }
        finally {
            XProtectVideoStreamReq xProtectVideoStreamReq = videoStreamReq1;
            synchronized (xProtectVideoStreamReq) {
                ((Object)((Object)videoStreamReq1)).notifyAll();
            }
        }
    }

    public static void streamToDestination(BXProtectCamera cam, BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        BXProtectCameraDeviceId id = (BXProtectCameraDeviceId)cam.getVideoDeviceId();
        XProtectVideoStreamUtil.streamToDestination(cam.getXprotectDvr(), id.getCameraId(), playbackParams, videoDestination);
    }

    static void streamToDestination(BXProtectManagementServer dvr, String id, BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        try {
            BIpAddress addr = (BIpAddress)dvr.getAddress();
            Object hcom = null;
            String uri = XProtectVideoStreamUtil.makeUri(playbackParams);
            NHttpRequest rqst = new NHttpRequest(addr, "GET", uri);
            NHttpStream hstream = hcom.openStream(rqst);
            BFacets f = HttpUtil.responseHeaderToFacets((NHttpResponse)hstream);
            f = BFacets.make((BFacets)playbackParams.getVideoFacets(), (BFacets)f);
            playbackParams.setHttpRspHeader(f);
            XprotectVideoSteam vs = new XprotectVideoSteam(playbackParams, hstream.getInputStream(), hstream);
            videoDestination.receiveVideoStream((IVideoStream)vs);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to establish stream", (Throwable)e);
        }
    }

    static void addCommonParametersToUrl(StringBuilder urlBuffer, BPlaybackParams playbackParams) {
        BVideoCompressionEnum compression = playbackParams.getCompression();
        if (compression == BVideoCompressionEnum.high) {
            urlBuffer.append("&res=").append(playbackParams.getResolution().getTag());
            urlBuffer.append("&format=mp4");
        } else {
            urlBuffer.append("&res=").append(playbackParams.getResolution().getTag());
            urlBuffer.append("&format=jfif");
        }
    }

    static String makeUri(BPlaybackParams playbackParams) {
        StringBuilder urlBuffer = new StringBuilder();
        urlBuffer.append("&pps=").append(30);
        XProtectVideoStreamUtil.addCommonParametersToUrl(urlBuffer, playbackParams);
        return urlBuffer.toString();
    }

    public static void interruptCurrentThread() {
        try {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().interrupt();
                return null;
            });
        }
        catch (PrivilegedActionException pe) {
            Exception inner = pe.getException();
            logger.log(Level.SEVERE, "Exception on calling interrupt : ", pe);
        }
    }

    private static class XprotectVideoSteam
    extends VideoStream {
        NHttpStream hstream;

        XprotectVideoSteam(BPlaybackParams playbackParams, InputStream in, NHttpStream hstream) {
            super(playbackParams, in);
            this.hstream = hstream;
        }

        public void closeVideoStream() throws IOException {
            this.hstream.close();
        }
    }

    public static class EstablishVideoConnection
    extends Thread {
        XProtectVideoStreamReq videoStreamReq;
        public BXProtectCamera milestoneCamera;
        Socket liveVideoSocket;
        OutputStream tcpOut;
        InputStream tcpIn;
        public boolean success;

        public EstablishVideoConnection(XProtectVideoStreamReq videoStreamReq, BXProtectCamera milestoneCamera) {
            super("LiveVideo.Camera" + videoStreamReq.getMilestoneCameraId());
            this.videoStreamReq = videoStreamReq;
            this.milestoneCamera = milestoneCamera;
        }

        protected void establishTcpConnection() throws IOException {
            this.milestoneCamera.lease();
            BXProtectCameraDeviceId camDevId = (BXProtectCameraDeviceId)this.milestoneCamera.get("videoDeviceId");
            this.liveVideoSocket = new Socket(camDevId.getServerId().getHostname(), camDevId.getServerId().getPort());
            this.tcpOut = this.liveVideoSocket.getOutputStream();
            this.tcpIn = this.liveVideoSocket.getInputStream();
        }

        protected void sendMilestoneConnectReq() throws IOException {
            boolean alwaysStdJpeg = this.videoStreamReq.getPlaybackParams().getCompression() != BVideoCompressionEnum.high && this.videoStreamReq.getPlaybackParams().getPlaybackType() != BPlaybackTypeEnum.live;
            alwaysStdJpeg = true;
            this.milestoneCamera.lease();
            this.milestoneCamera.getXprotectDvr().lease(3);
            String liveConnectXml = this.videoStreamReq.getLiveConnectXml(((BXProtectCameraDeviceId)this.milestoneCamera.get("videoDeviceId")).getCameraId(), this.milestoneCamera.getXprotectDvr().getConnection().getAuthAttributes().getToken(), alwaysStdJpeg);
            this.tcpOut.write(liveConnectXml.getBytes());
            this.tcpOut.flush();
        }

        protected boolean receiveMilestoneConnectReply() throws Exception {
            XParser p = XParser.make((InputStream)this.tcpIn);
            XElem methodResponseElem = p.parse(false);
            if (methodResponseElem != null) {
                return XProtectTcpUtil.receiveMilestoneConnectReply(methodResponseElem);
            }
            throw new IllegalStateException("No reply from ImageServer!");
        }

        protected void sendMilestoneVideoReq() throws IOException {
            byte[] videoReqBytes = this.videoStreamReq.toByteArray();
            this.tcpOut.write(videoReqBytes);
            this.tcpOut.flush();
        }

        protected String readLineFromSocket() throws IOException {
            StringBuilder sb = new StringBuilder();
            boolean endl = false;
            int lastByte = -1;
            while (!endl) {
                int bite = this.tcpIn.read();
                if (bite == -1) {
                    endl = true;
                    continue;
                }
                sb.append((char)bite);
                endl = bite == 10 && lastByte == 13;
                lastByte = bite;
            }
            String sbStr = sb.toString();
            if (sbStr.length() > 2) {
                sbStr = sbStr.substring(0, sbStr.length() - 2);
            }
            return sbStr;
        }

        protected boolean receiveMilestoneVideoRsp() throws IOException {
            String line = this.readLineFromSocket();
            while (line != null && line.length() > 0 && !"ImageResponse".equals(line)) {
                line = this.readLineFromSocket();
            }
            return true;
        }

        @Override
        public void run() {
            try {
                this.establishTcpConnection();
                this.sendMilestoneConnectReq();
                this.receiveMilestoneConnectReply();
                this.sendMilestoneVideoReq();
                this.success = this.receiveMilestoneVideoRsp();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                this.success = false;
                e.printStackTrace();
            }
        }
    }
}

