/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import com.tridium.net.HttpDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class HttpHeader {
    protected HashMap<String, String> table = new HashMap(17);

    public Enumeration<String> getFieldNames() {
        Vector<String> names = new Vector<String>(this.table.size() + 3);
        for (String name : this.table.keySet()) {
            names.add(name);
        }
        this.addFieldNames(names);
        return names.elements();
    }

    protected void addFieldNames(Vector<String> names) {
    }

    public String get(String name) {
        return this.table.get(name.toLowerCase());
    }

    public int getInt(String name, int def) {
        try {
            String istr = this.get(name);
            if (istr == null) {
                return def;
            }
            return Integer.parseInt(istr);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public long getDate(String name) {
        String val = this.get(name);
        if (val == null) {
            return -1L;
        }
        return HttpDateFormat.parse(val);
    }

    public boolean getBoolean(String name, boolean def) {
        String val = this.get(name);
        if (val == null) {
            return def;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }

    public boolean contains(String name, String val) {
        String value = this.get(name);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(val);
    }

    public void set(String name, String value) {
        this.table.put(name.toLowerCase(), value);
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public void setDate(String name, long value) {
        this.set(name, HttpDateFormat.format(value));
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, value ? "true" : "false");
    }

    public void read(InputStream in) throws IOException {
        StringBuilder sbuf = new StringBuilder(64);
        while (true) {
            String name = null;
            String value = null;
            int ch = in.read();
            if (ch == -1 || ch == 13) {
                ch = in.read();
                return;
            }
            while (ch != -1 && ch != 58) {
                sbuf.append((char)ch);
                ch = in.read();
            }
            name = sbuf.toString();
            sbuf.setLength(0);
            ch = in.read();
            while (ch != -1 && ch == 32) {
                ch = in.read();
            }
            while (ch != -1 && ch != 13) {
                sbuf.append((char)ch);
                ch = in.read();
            }
            value = sbuf.toString();
            sbuf.setLength(0);
            ch = in.read();
            this.addField(name, value);
        }
    }

    protected void addField(String name, String value) {
        this.table.put(name.toLowerCase(), value);
    }

    public void write(PrintWriter out) throws IOException {
        this.write(out, null);
    }

    public void write(PrintWriter out, StringBuffer trace) throws IOException {
        for (String name : this.table.keySet()) {
            String value = this.table.get(name);
            out.print(name);
            out.print(": ");
            out.print(value);
            out.print("\r\n");
            if (trace == null) continue;
            trace.append("  ");
            trace.append(name);
            trace.append(": ");
            trace.append(value);
            trace.append("\r\n");
        }
        this.doWriteFields(out, trace);
    }

    protected void doWriteFields(PrintWriter out, StringBuffer trace) throws IOException {
    }

    public static String[] parseValue(String s) {
        int index = s.indexOf(44);
        if (index == -1) {
            return new String[]{s};
        }
        StringTokenizer st = new StringTokenizer(s, ", ");
        Vector<String> vals = new Vector<String>(2);
        while (st.hasMoreTokens()) {
            vals.addElement(st.nextToken());
        }
        Object[] res = new String[vals.size()];
        vals.copyInto(res);
        return res;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(256);
        for (String key : this.table.keySet()) {
            s.append("  ").append(key).append(": ");
            s.append(this.table.get(key));
            s.append('\n');
        }
        try {
            this.doAppendFields(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    protected void doAppendFields(StringBuffer s) throws IOException {
    }
}

