/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import com.tridium.net.BProxyAuthenticationType;
import com.tridium.net.HttpDigestClient;
import com.tridium.net.NiagaraHttpProxySelector;
import com.tridium.net.NiagaraProxyAuthenticator;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.util.Base64;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", override=true), @NiagaraProperty(name="server", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="0"), @NiagaraProperty(name="exclusions", type="String", defaultValue="10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16"), @NiagaraProperty(name="authenticationScheme", type="BProxyAuthenticationType", defaultValue="BProxyAuthenticationType.none"), @NiagaraProperty(name="user", type="String", defaultValue=""), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.make(\"\")")})
public class BHttpProxyService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property enabled = BHttpProxyService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property server = BHttpProxyService.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property port = BHttpProxyService.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property exclusions = BHttpProxyService.newProperty((int)0, (String)"10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16", null);
    @Generated
    public static final Property authenticationScheme = BHttpProxyService.newProperty((int)0, (BValue)BProxyAuthenticationType.none, null);
    @Generated
    public static final Property user = BHttpProxyService.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property password = BHttpProxyService.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpProxyService.class);
    private static final BIcon icon = BIcon.make((String)"module://net/icons/proxy.png");
    public static final ProxySelector DEFAULT_PROXY_SELECTOR = AccessController.doPrivileged(ProxySelector::getDefault);
    private HttpDigestClient digestClient;
    private IFilter[] exclusionList;
    public static final Logger log = Logger.getLogger("http.proxy");

    @Generated
    public String getServer() {
        return this.getString(server);
    }

    @Generated
    public void setServer(String v) {
        this.setString(server, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public String getExclusions() {
        return this.getString(exclusions);
    }

    @Generated
    public void setExclusions(String v) {
        this.setString(exclusions, v, null);
    }

    @Generated
    public BProxyAuthenticationType getAuthenticationScheme() {
        return (BProxyAuthenticationType)this.get(authenticationScheme);
    }

    @Generated
    public void setAuthenticationScheme(BProxyAuthenticationType v) {
        this.set(authenticationScheme, (BValue)v, null);
    }

    @Generated
    public String getUser() {
        return this.getString(user);
    }

    @Generated
    public void setUser(String v) {
        this.setString(user, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public static BHttpProxyService get(BHost host) {
        BComponent[] candidates;
        if (!(host instanceof BIpHost)) {
            return null;
        }
        if (!Sys.findService((Type)TYPE).isPresent()) {
            return null;
        }
        try {
            candidates = Sys.getServices((Type)TYPE);
        }
        catch (ServiceNotFoundException snf) {
            log.log(Level.FINEST, "no services found", snf);
            return null;
        }
        for (BComponent candidate : candidates) {
            BHttpProxyService proxy = (BHttpProxyService)candidate;
            if (!proxy.getEnabled((BIpHost)host)) continue;
            log.fine(() -> String.format("Connecting to %s through proxy %s", host.toString(null), proxy.getServer()));
            return proxy;
        }
        return null;
    }

    public static BHttpProxyService find(String hostname, int port) {
        BComponent[] candidates;
        if (!Sys.findService((Type)TYPE).isPresent()) {
            return null;
        }
        try {
            candidates = Sys.getServices((Type)TYPE);
        }
        catch (ServiceNotFoundException snf) {
            log.finest("no proxy services configured");
            return null;
        }
        log.fine(() -> String.format("looking for proxy authentication for requestor %s:%d", hostname, port));
        for (BComponent candidate : candidates) {
            BHttpProxyService proxy = (BHttpProxyService)candidate;
            if (!hostname.equalsIgnoreCase(proxy.getServer()) || port != proxy.getPort()) continue;
            log.fine(() -> String.format("authenticating to %s", proxy.getServer()));
            return proxy;
        }
        return null;
    }

    public Proxy getProxy() {
        InetSocketAddress sockAddr = new InetSocketAddress(this.getServer(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, sockAddr);
    }

    private boolean getEnabled(BIpHost host) {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.exclusionList == null) {
            this.loadExclusionList();
        }
        for (IFilter iFilter : this.exclusionList) {
            if (!iFilter.accept((Object)host)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Host " + host.toString(null) + " matches exclusion '" + iFilter + "' for proxy " + this.getServer());
            }
            return false;
        }
        return true;
    }

    public Socket openSocket() throws IOException {
        try {
            return new BIpHost(this.getServer()).openSocket(this.getPort());
        }
        catch (ConnectException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to connect to proxy server.");
            log.log(Level.SEVERE, "Unable to connect to proxy server at " + this.getServer(), e);
            throw e;
        }
        catch (UnknownHostException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unknown host: " + e.getMessage());
            log.log(Level.SEVERE, "Unable to resolve proxy server " + this.getServer(), e);
            throw e;
        }
        catch (IOException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(e.getMessage());
            log.log(Level.SEVERE, "Unable to connect to proxy server.", e);
            throw e;
        }
    }

    public Socket openSocket(int timeout) throws IOException {
        try {
            return new BIpHost(this.getServer()).openSocket(this.getPort(), timeout);
        }
        catch (ConnectException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to connect to proxy server.");
            log.log(Level.SEVERE, "Unable to connect to proxy server at " + this.getServer(), e);
            throw e;
        }
        catch (UnknownHostException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unknown host: " + e.getMessage());
            log.log(Level.SEVERE, "Unable to resolve proxy server " + this.getServer(), e);
            throw e;
        }
        catch (IOException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(e.getMessage());
            log.log(Level.SEVERE, "Unable to connect to proxy server.", e);
            throw e;
        }
    }

    public String getAuthentication() {
        return this.getAuthentication(null, null, null);
    }

    public String getAuthentication(String authenticateHeader, String method, String uri) {
        StringBuilder out = new StringBuilder();
        if (this.getAuthenticationScheme().getOrdinal() == 1) {
            out.append("Basic ");
            out.append(new String(Base64.getEncoder().encode((this.getUser() + ':' + AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue())).getBytes(StandardCharsets.UTF_8))));
            return out.toString();
        }
        if (this.getAuthenticationScheme().getOrdinal() == 2) {
            if (this.digestClient == null) {
                this.digestClient = new HttpDigestClient(this.getUser(), this.getPassword());
            }
            try {
                return this.digestClient.getAuthentication(authenticateHeader, method, uri);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Proxy authentication failed.", e);
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        this.loadExclusionList();
        super.started();
        ProxySelector proxySelector = DEFAULT_PROXY_SELECTOR;
        synchronized (proxySelector) {
            AccessController.doPrivileged(() -> {
                if (ProxySelector.getDefault() == DEFAULT_PROXY_SELECTOR) {
                    ProxySelector.setDefault(new NiagaraHttpProxySelector(DEFAULT_PROXY_SELECTOR));
                    Authenticator.setDefault(new NiagaraProxyAuthenticator());
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                }
                return null;
            });
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(exclusions)) {
            this.loadExclusionList();
        }
        if (property.equals(user) || property.equals(password)) {
            this.digestClient = null;
        }
    }

    private void loadExclusionList() {
        Array exclusions = new Array(IFilter.class);
        StringBuilder exclusionText = new StringBuilder();
        boolean isHostName = false;
        for (int i = 0; i < this.getExclusions().length(); ++i) {
            char c = this.getExclusions().charAt(i);
            if (c != ' ' && c != ',' && c != ';') {
                exclusionText.append(c);
                if (!(isHostName || c == '.' || c == '/' || c == '\\' || c >= '0' && c <= '9')) {
                    isHostName = true;
                }
            }
            if (c != ' ' && c != ',' && c != ';' && i != this.getExclusions().length() - 1 || exclusionText.length() <= 1) continue;
            if (isHostName) {
                try {
                    exclusions.add((Object)new HostNameFilter(exclusionText.toString()));
                }
                catch (InvalidParameterException e) {
                    this.setFaultCause(e.getMessage());
                    this.setStatus(BStatus.fault);
                    log.log(Level.SEVERE, "Invalid exclusion", e);
                }
            } else {
                try {
                    exclusions.add((Object)new Ip4Filter(exclusionText.toString()));
                }
                catch (InvalidParameterException e) {
                    this.setFaultCause(e.getMessage());
                    this.setStatus(BStatus.fault);
                    log.log(Level.SEVERE, "Invalid exclusion", e);
                }
            }
            exclusionText = new StringBuilder();
            isHostName = false;
        }
        exclusions.add((Object)new HostNameFilter("localhost"));
        exclusions.add((Object)new Ip4Filter("127.0.0.1/8"));
        this.exclusionList = (IFilter[])exclusions.trim();
    }

    private static class HostNameFilter
    implements IFilter {
        String filter;

        public HostNameFilter(String filter) {
            this.filter = filter.toLowerCase(Locale.ENGLISH);
        }

        public boolean accept(Object obj) {
            BIpHost host = (BIpHost)obj;
            if (host.isNumericAddress()) {
                try {
                    InetAddress addr = host.getInetAddress();
                    host = new BIpHost(addr.getHostName());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error resolving " + host, e);
                }
            }
            if (this.filter.charAt(0) == '.') {
                if (host.getHostname().endsWith(this.filter)) {
                    return true;
                }
                return host.getHostname().endsWith(this.filter.substring(1)) && host.getHostname().length() == this.filter.length() - 1;
            }
            return host.getHostname().equalsIgnoreCase(this.filter);
        }

        public String toString() {
            return this.filter;
        }
    }

    private static class Ip4Filter
    implements IFilter {
        byte[] filterAddr;
        int subnet;
        String ip;

        public Ip4Filter(String ip) throws InvalidParameterException {
            this.ip = ip;
            try {
                if (ip.indexOf(47) > -1) {
                    this.filterAddr = InetAddress.getByName(ip.substring(0, ip.indexOf(47))).getAddress();
                    this.subnet = Integer.parseInt(ip.substring(ip.indexOf(47) + 1));
                } else if (ip.indexOf(92) > -1) {
                    this.filterAddr = InetAddress.getByName(ip.substring(0, ip.indexOf(92))).getAddress();
                    this.subnet = Integer.parseInt(ip.substring(ip.indexOf(92) + 1));
                } else {
                    this.filterAddr = InetAddress.getByName(ip).getAddress();
                    this.subnet = 32;
                }
                if (this.subnet > 32 || this.subnet < 1) {
                    throw new InvalidParameterException("Invalid number of bits in subnet: " + this.subnet);
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException("Incorrect subnet format.");
            }
            catch (UnknownHostException e) {
                log.log(Level.SEVERE, "unknown host: " + ip, e);
                throw new InvalidParameterException("Host could not be resolved.");
            }
        }

        public boolean accept(Object obj) {
            BIpHost host = (BIpHost)obj;
            try {
                InetAddress addr = host.getInetAddress();
                byte[] checkAddr = addr.getAddress();
                int mask = this.subnet;
                for (int j = 0; j < 4 && mask - j * 8 > 0; ++j) {
                    int filter;
                    int check = checkAddr[j] >>> 8 - Math.min(8, mask - j * 8) & 0xFF;
                    if (check == (filter = this.filterAddr[j] >>> 8 - Math.min(8, mask - j * 8) & 0xFF)) continue;
                    return false;
                }
                return true;
            }
            catch (IOException ioe) {
                log.log(Level.FINE, String.format(Locale.ENGLISH, "unable to resolve %s", host), ioe);
                return false;
            }
        }

        public String toString() {
            return this.ip;
        }
    }
}

