/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.ui;

import com.tridium.modbusCore.BModbusDevice;
import java.util.ArrayList;
import java.util.List;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType
public class BModbusDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusDeviceManager.class);
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final Lexicon lexicon = Lexicon.make(BModbusDeviceManager.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new ModbusModel(this);
    }

    protected MgrController makeController() {
        return new ModbusController(this);
    }

    public class ModbusController
    extends DeviceController {
        public ModbusController(BDeviceManager manager) {
            super(manager);
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BComponent mockDevice = types[0].newInstance();
            Property prop = mockDevice.getProperty("deviceAddress");
            int maxAddress = prop.getFacets().geti("max", 247);
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem((Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BTextField startAddressField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            grid.add(null, (BValue)new BLabel(lexicon.getText("devManager.add.start", new Object[]{maxAddress})));
            grid.add(null, (BValue)startAddressField);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            int count = 0;
            int startAddress = 1;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                type = (MgrTypeInfo)typeField.getSelectedItem();
                count = Integer.parseInt(countField.getText());
                startAddress = Integer.parseInt(startAddressField.getText());
                if (startAddress + count - 1 > maxAddress) {
                    BDialog.error((BWidget)this.getManager(), (Object)lexicon.getText("devManager.error.invalidCount", new Object[]{maxAddress}));
                    continue;
                }
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                if (startAddress < 1 || startAddress > maxAddress) {
                    startAddress = 1;
                }
                MgrEditRow row = new MgrEditRow(((ModbusModel)this.getManager().getModel()).newInstance(type, startAddress), null, types);
                edit.addRow(row);
                row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + startAddress)));
                ++startAddress;
            }
            return edit;
        }
    }

    public class ModbusModel
    extends DeviceModel {
        public ModbusModel(BModbusDeviceManager manager) {
            super((BDeviceManager)manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BModbusDevice.TYPE);
        }

        public BComponent newInstance(MgrTypeInfo type, int address) throws Exception {
            BComponent obj = super.newInstance(type);
            if (obj instanceof BModbusDevice) {
                ((BModbusDevice)obj).setDeviceAddress(address);
            }
            return obj;
        }

        public MgrColumn[] makeColumns() {
            ArrayList<MgrColumn> list = new ArrayList<MgrColumn>();
            this.addDefaultModbusColumns(list);
            this.addCustomModbusColumns(list);
            return list.toArray(new MgrColumn[0]);
        }

        public void addDefaultModbusColumns(List<MgrColumn> list) {
            list.add((MgrColumn)new MgrColumn.Name());
            list.add((MgrColumn)new MgrColumn.Type(3));
            list.add((MgrColumn)new DeviceExtsColumn((BDevice)this.getModbusDeviceInstance()));
            list.add((MgrColumn)new MgrColumn.Prop(BModbusDevice.status));
            list.add((MgrColumn)new MgrColumn.Prop(BModbusDevice.enabled, 3));
            list.add((MgrColumn)new MgrColumn.Prop(BModbusDevice.health, 2));
            list.add((MgrColumn)new MgrColumn.Prop(BModbusDevice.deviceAddress, 1));
            list.add((MgrColumn)new MgrColumn.Prop(BModbusDevice.modbusConfig, 3));
        }

        public void addCustomModbusColumns(List<MgrColumn> list) {
        }

        protected BModbusDevice getModbusDeviceInstance() {
            return null;
        }
    }
}

