/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.ui;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.point.BEnumBitsPoint;
import com.tridium.modbusCore.point.BEnumBitsWritable;
import com.tridium.modbusCore.point.BIModbusBooleanProxyExt;
import com.tridium.modbusCore.point.BIModbusEnumBitsProxyExt;
import com.tridium.modbusCore.point.BIModbusNumericBitsProxyExt;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import com.tridium.modbusCore.point.BIModbusReadProxyExt;
import com.tridium.modbusCore.point.BIModbusRegisterBitProxyExt;
import com.tridium.modbusCore.point.BIModbusStringProxyExt;
import com.tridium.modbusCore.point.BModbusProxyExt;
import com.tridium.modbusCore.point.BNumericBitsPoint;
import com.tridium.modbusCore.point.BNumericBitsWritable;
import com.tridium.modbusCore.point.BRegisterBitPoint;
import com.tridium.modbusCore.point.BRegisterBitWritable;
import com.tridium.modbusCore.util.DataTypeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType
public class BModbusPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusPointManager.class);
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BModbusPointManager.class);
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new ModbusType(3);
    MgrColumn colValue = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colPollFreq = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.pollFrequency}, 3);
    MgrColumn colDataAddress = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.dataAddress}, 3);
    MgrColumn colRegType = new ModbusRegType();
    MgrColumn colDataType = new ModbusDataType();
    MgrColumn colStatusType = new ModbusStatusType();
    MgrColumn colBitNumber = new ModbusBitNumber();
    MgrColumn colBeginningBit = new ModbusBeginningBit();
    MgrColumn colNumberOfBits = new ModbusNumberOfBits();
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.deviceFacets}, 3);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.conversion}, 3);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colAbsAddress = new ModbusAbsAddress();
    MgrColumn colDataSource = new ModbusDataSource();
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colNumRegisters = new ModbusNumRegisters();
    MgrColumn[] modbusCols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colTuning, this.colAbsAddress, this.colFaultCause, this.colPollFreq, this.colDataAddress, this.colRegType, this.colDataType, this.colStatusType, this.colBitNumber, this.colBeginningBit, this.colNumberOfBits, this.colDataSource, this.colNumRegisters, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult};
    MgrColumn[] modbusSlaveCols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colTuning, this.colPollFreq, this.colDataAddress, this.colFaultCause, this.colRegType, this.colDataType, this.colStatusType, this.colBitNumber, this.colBeginningBit, this.colNumberOfBits, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new ModbusPointModel(this);
    }

    protected MgrController makeController() {
        return new ModbusPointController(this);
    }

    protected boolean isModbusSlave() {
        return false;
    }

    protected BAbstractProxyExt makeModbusRegisterBitExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusBooleanExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusEnumBitsExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusNumericExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusNumericBitsExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusStringExt() {
        return new BNullProxyExt();
    }

    public static class ModbusNumberOfBits
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusNumberOfBits() {
            super(lexicon.getText("table.columnTitle.numberOfBits"), 3);
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)row).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    return ((BIModbusEnumBitsProxyExt)ext).getNumberOfBits();
                }
                if (ext instanceof BIModbusNumericBitsProxyExt) {
                    return ((BIModbusNumericBitsProxyExt)ext).getNumberOfBits();
                }
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && ((ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusEnumBitsProxyExt || ext instanceof BIModbusNumericBitsProxyExt)) {
                return ext.get(ext.getProperty("numberOfBits")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    ((BIModbusEnumBitsProxyExt)ext).setNumberOfBits(((BInteger)value).getInt());
                } else if (ext instanceof BIModbusNumericBitsProxyExt) {
                    ((BIModbusNumericBitsProxyExt)ext).setNumberOfBits(((BInteger)value).getInt());
                }
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt || ext instanceof BIModbusNumericBitsProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("numberOfBits")};
            return ModbusNumberOfBits.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("numberOfBits")};
            ModbusNumberOfBits.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusBeginningBit
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusBeginningBit() {
            super(lexicon.getText("table.columnTitle.beginningBit"), 3);
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)row).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    return ((BIModbusEnumBitsProxyExt)ext).getBeginningBit();
                }
                if (ext instanceof BIModbusNumericBitsProxyExt) {
                    return ((BIModbusNumericBitsProxyExt)ext).getBeginningBit();
                }
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && ((ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusEnumBitsProxyExt || ext instanceof BIModbusNumericBitsProxyExt)) {
                return ext.get(ext.getProperty("beginningBit")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    ((BIModbusEnumBitsProxyExt)ext).setBeginningBit(((BInteger)value).getInt());
                } else if (ext instanceof BIModbusNumericBitsProxyExt) {
                    ((BIModbusNumericBitsProxyExt)ext).setBeginningBit(((BInteger)value).getInt());
                }
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt || ext instanceof BIModbusNumericBitsProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("beginningBit")};
            return ModbusBeginningBit.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("beginningBit")};
            ModbusBeginningBit.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusNumRegisters
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusNumRegisters() {
            super(lexicon.getText("table.columnTitle.numRegisters"), 3);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BIModbusStringProxyExt) {
                return ((BIModbusStringProxyExt)ext).getNumberRegisters();
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusStringProxyExt) {
                return ext.get(ext.getProperty("numberRegisters")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAbstractProxyExt ext;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusStringProxyExt) {
                ((BIModbusStringProxyExt)ext).setNumberRegisters(((BInteger)value).getInt());
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusStringProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("numberRegisters")};
            return ModbusNumRegisters.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("numberRegisters")};
            ModbusNumRegisters.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusDataSource
    extends MgrColumn {
        public ModbusDataSource() {
            super(lexicon.getText("table.columnTitle.dataSource"), 2);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BIModbusReadProxyExt) {
                return ((BIModbusReadProxyExt)ext).getDataSource();
            }
            return "";
        }
    }

    public static class ModbusAbsAddress
    extends MgrColumn {
        public ModbusAbsAddress() {
            super(lexicon.getText("table.columnTitle.absAddress"), 0);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BIModbusReadProxyExt) {
                return ((BIModbusReadProxyExt)ext).getAbsoluteAddress();
            }
            return "";
        }
    }

    public static class ModbusBitNumber
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusBitNumber() {
            super(lexicon.getText("table.columnTitle.bitNumber"), 3);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BIModbusRegisterBitProxyExt) {
                return ((BIModbusRegisterBitProxyExt)ext).getBitNumber();
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusRegisterBitProxyExt) {
                return ext.get(ext.getProperty("bitNumber")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAbstractProxyExt ext;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusRegisterBitProxyExt) {
                ((BIModbusRegisterBitProxyExt)ext).setBitNumber(((BInteger)value).getInt());
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusRegisterBitProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("bitNumber")};
            return ModbusBitNumber.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("bitNumber")};
            ModbusBitNumber.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusStatusType
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusStatusType() {
            super(lexicon.getText("table.columnTitle.statusType"), 3);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BIModbusBooleanProxyExt) {
                return ((BIModbusBooleanProxyExt)ext).getStatusType();
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusBooleanProxyExt) {
                return ((BIModbusBooleanProxyExt)ext).getStatusType().newCopy();
            }
            this.isDefault = true;
            return BStatusTypeEnum.coil;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint) {
                if (((BControlPoint)val).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusBooleanProxyExt) {
                    ((BIModbusBooleanProxyExt)ext).setStatusType((BStatusTypeEnum)value.newCopy());
                }
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                if (((BControlPoint)val).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusBooleanProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("statusType")};
            return ModbusStatusType.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("statusType")};
            ModbusStatusType.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusDataType
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusDataType() {
            super(lexicon.getText("table.columnTitle.dataType"), 3);
        }

        public Object get(Object row) {
            BAbstractProxyExt ext;
            if (row instanceof BControlPoint && (ext = ((BControlPoint)row).getProxyExt()) instanceof BIModbusNumericProxyExt) {
                return ((BIModbusNumericProxyExt)ext).getDataType();
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            BAbstractProxyExt ext;
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusNumericProxyExt) {
                return ((BIModbusNumericProxyExt)ext).getDataType().newCopy();
            }
            this.isDefault = true;
            return BDataTypeEnum.integerType;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAbstractProxyExt ext;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint && (ext = ((BControlPoint)val).getProxyExt()) instanceof BIModbusNumericProxyExt) {
                ((BIModbusNumericProxyExt)ext).setDataType((BDataTypeEnum)value.newCopy());
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusNumericProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("dataType")};
            return ModbusDataType.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("dataType")};
            ModbusDataType.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusRegType
    extends MgrColumn {
        boolean isDefault = false;

        public ModbusRegType() {
            super(lexicon.getText("table.columnTitle.regType"), 3);
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)row).getProxyExt();
                if (ext instanceof BIModbusNumericProxyExt) {
                    return ((BIModbusNumericProxyExt)ext).getRegType();
                }
                if (ext instanceof BIModbusRegisterBitProxyExt) {
                    return ((BIModbusRegisterBitProxyExt)ext).getRegType();
                }
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    return ((BIModbusEnumBitsProxyExt)ext).getRegType();
                }
                if (ext instanceof BIModbusNumericBitsProxyExt) {
                    return ((BIModbusNumericBitsProxyExt)ext).getRegType();
                }
            }
            return "";
        }

        public BValue load(MgrEditRow row) {
            this.isDefault = false;
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusNumericProxyExt) {
                    return ((BIModbusNumericProxyExt)ext).getRegType().newCopy();
                }
                if (ext instanceof BIModbusRegisterBitProxyExt) {
                    return ((BIModbusRegisterBitProxyExt)ext).getRegType().newCopy();
                }
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    return ((BIModbusEnumBitsProxyExt)ext).getRegType().newCopy();
                }
                if (ext instanceof BIModbusNumericBitsProxyExt) {
                    return ((BIModbusNumericBitsProxyExt)ext).getRegType().newCopy();
                }
            }
            this.isDefault = true;
            return BRegisterTypeEnum.holding;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent val = row.getTarget();
            if (val instanceof BControlPoint) {
                if (((BControlPoint)val).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusNumericProxyExt) {
                    ((BIModbusNumericProxyExt)ext).setRegType((BRegisterTypeEnum)value.newCopy());
                } else if (ext instanceof BIModbusRegisterBitProxyExt) {
                    ((BIModbusRegisterBitProxyExt)ext).setRegType((BRegisterTypeEnum)value.newCopy());
                } else if (ext instanceof BIModbusEnumBitsProxyExt) {
                    ((BIModbusEnumBitsProxyExt)ext).setRegType((BRegisterTypeEnum)value.newCopy());
                } else if (ext instanceof BIModbusNumericBitsProxyExt) {
                    ((BIModbusNumericBitsProxyExt)ext).setRegType((BRegisterTypeEnum)value.newCopy());
                }
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows == null || rows.length <= 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent val = rows[i].getTarget();
                if (!(val instanceof BControlPoint)) {
                    return null;
                }
                if (((BControlPoint)val).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return null;
                }
                BAbstractProxyExt ext = ((BControlPoint)val).getProxyExt();
                if (ext instanceof BIModbusNumericProxyExt || ext instanceof BIModbusRegisterBitProxyExt || ext instanceof BIModbusEnumBitsProxyExt || ext instanceof BIModbusNumericBitsProxyExt) continue;
                return null;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("regType")};
            return ModbusRegType.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            if (rows == null || rows.length <= 0) {
                return;
            }
            BAbstractProxyExt val = ((BControlPoint)rows[0].getTarget()).getProxyExt();
            Property[] props = new Property[]{BControlPoint.proxyExt, val.loadSlots().getProperty("regType")};
            ModbusRegType.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
        }
    }

    public static class ModbusType
    extends MgrColumn.Type {
        public ModbusType(int flags) {
            super(flags);
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)row).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    if (row instanceof BEnumWritable) {
                        return BEnumBitsWritable.TYPE;
                    }
                    if (row instanceof BEnumPoint) {
                        return BEnumBitsPoint.TYPE;
                    }
                } else if (ext instanceof BIModbusNumericBitsProxyExt) {
                    if (row instanceof BNumericWritable) {
                        return BNumericBitsWritable.TYPE;
                    }
                    if (row instanceof BNumericPoint) {
                        return BNumericBitsPoint.TYPE;
                    }
                } else if (ext instanceof BIModbusRegisterBitProxyExt) {
                    if (row instanceof BBooleanWritable) {
                        return BRegisterBitWritable.TYPE;
                    }
                    if (row instanceof BBooleanPoint) {
                        return BRegisterBitPoint.TYPE;
                    }
                }
            }
            return super.get(row);
        }

        public BValue load(MgrEditRow row) {
            BComponent target = row.getTarget();
            if (target != null && target instanceof BControlPoint) {
                BAbstractProxyExt ext = ((BControlPoint)target).getProxyExt();
                if (ext instanceof BIModbusEnumBitsProxyExt) {
                    MgrTypeInfo type;
                    if (target instanceof BEnumWritable) {
                        type = MgrTypeInfo.make((Type)BEnumBitsWritable.TYPE);
                    } else if (target instanceof BEnumPoint) {
                        type = MgrTypeInfo.make((Type)BEnumBitsPoint.TYPE);
                    } else {
                        return super.load(row);
                    }
                    BFacets dummy = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BEnumRange.NULL), (Object)type);
                    return dummy;
                }
                if (ext instanceof BIModbusNumericBitsProxyExt) {
                    MgrTypeInfo type;
                    if (target instanceof BNumericWritable) {
                        type = MgrTypeInfo.make((Type)BNumericBitsWritable.TYPE);
                    } else if (target instanceof BNumericPoint) {
                        type = MgrTypeInfo.make((Type)BNumericBitsPoint.TYPE);
                    } else {
                        return super.load(row);
                    }
                    BFacets dummy = BFacets.makePickle((BFacets)BFacets.DEFAULT, (Object)type);
                    return dummy;
                }
                if (ext instanceof BIModbusRegisterBitProxyExt) {
                    MgrTypeInfo type;
                    if (target instanceof BBooleanWritable) {
                        type = MgrTypeInfo.make((Type)BRegisterBitWritable.TYPE);
                    } else if (target instanceof BBooleanPoint) {
                        type = MgrTypeInfo.make((Type)BRegisterBitPoint.TYPE);
                    } else {
                        return super.load(row);
                    }
                    BFacets dummy = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)type);
                    return dummy;
                }
            }
            return super.load(row);
        }
    }

    public class ModbusPointController
    extends PointController {
        String errorMsg;

        public ModbusPointController(BPointManager manager) {
            super(manager);
            this.errorMsg = lexicon.getText("pointManager.addressError.unknown");
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            int i;
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i2 = 0; i2 < types.length; ++i2) {
                typeField.getList().addItem((Object)types[i2]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BFlexAddress val = new BFlexAddress();
            val.setAddressFormat(BAddressFormatEnum.modbus);
            BWbFieldEditor startAddressEditor = BWbFieldEditor.makeFor((BObject)val);
            startAddressEditor.loadValue((BObject)val);
            BListDropDown dataType = new BListDropDown();
            int[] ordinals = BDataTypeEnum.integerType.getRange().getOrdinals();
            String[] tags = new String[ordinals.length];
            for (i = 0; i < tags.length; ++i) {
                tags[i] = BDataTypeEnum.integerType.getRange().get(ordinals[i]).getTag();
            }
            for (i = 0; i < tags.length; ++i) {
                dataType.getList().addItem((Object)tags[i]);
            }
            dataType.setSelectedIndex(0);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            grid.add(null, (BValue)new BLabel(lexicon.getText("pointManager.add.startAddress")));
            grid.add(null, (BValue)startAddressEditor);
            grid.add(null, (BValue)new BLabel(lexicon.getText("pointManager.add.dataType")));
            grid.add(null, (BValue)dataType);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            int count = 0;
            BFlexAddress startAddress = null;
            BDataTypeEnum dType = null;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                type = (MgrTypeInfo)typeField.getSelectedItem();
                count = Integer.parseInt(countField.getText());
                startAddress = (BFlexAddress)startAddressEditor.saveValue();
                dType = (BDataTypeEnum)BDataTypeEnum.integerType.getRange().get((String)dataType.getSelectedItem());
                if (!this.validAddress(type, startAddress)) {
                    BDialog.error((BWidget)this.getManager(), (Object)this.errorMsg);
                    continue;
                }
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i3 = 0; i3 < count; ++i3) {
                BComponent comp = ((ModbusPointModel)this.getManager().getModel()).newInstance(type, startAddress, i3, dType);
                MgrEditRow row = new MgrEditRow(comp, null, types);
                edit.addRow(row);
                if (comp instanceof BControlPoint) {
                    BAbstractProxyExt ext = ((BControlPoint)comp).getProxyExt();
                    if (ext instanceof BModbusProxyExt) {
                        if (ext instanceof BIModbusEnumBitsProxyExt) {
                            row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + ((BModbusProxyExt)ext).getDataAddress().getAddress() + "-" + i3)));
                            continue;
                        }
                        if (ext instanceof BIModbusNumericBitsProxyExt) {
                            row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + ((BModbusProxyExt)ext).getDataAddress().getAddress() + "-" + i3)));
                            continue;
                        }
                        if (ext instanceof BIModbusRegisterBitProxyExt) {
                            row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + ((BModbusProxyExt)ext).getDataAddress().getAddress() + lexicon.getText("pointManager.bit") + i3 % 16)));
                            continue;
                        }
                        row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + ((BModbusProxyExt)ext).getDataAddress().getAddress())));
                        continue;
                    }
                    row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + i3)));
                    continue;
                }
                row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + i3)));
            }
            return edit;
        }

        private boolean validAddress(MgrTypeInfo type, BFlexAddress address) {
            if (!address.isModbusFormat()) {
                return true;
            }
            boolean valid = true;
            if (type.equals((Object)MgrTypeInfo.make((Type)BRegisterBitPoint.TYPE)) || type.equals((Object)MgrTypeInfo.make((Type)BNumericPoint.TYPE)) || type.equals((Object)MgrTypeInfo.make((Type)BNumericBitsPoint.TYPE)) || type.equals((Object)MgrTypeInfo.make((Type)BEnumBitsPoint.TYPE))) {
                valid = address.isModbusAnalogAddress();
                if (!valid) {
                    this.errorMsg = lexicon.getText("pointManager.addressError.notAnalog");
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BRegisterBitWritable.TYPE)) || type.equals((Object)MgrTypeInfo.make((Type)BNumericWritable.TYPE)) || type.equals((Object)MgrTypeInfo.make((Type)BNumericBitsWritable.TYPE)) || type.equals((Object)MgrTypeInfo.make((Type)BEnumBitsWritable.TYPE))) {
                if (BModbusPointManager.this.isModbusSlave()) {
                    valid = address.isModbusAnalogAddress();
                    if (!valid) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notAnalog");
                    }
                } else {
                    valid = address.isModbusHoldingAddress();
                    if (!valid) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notHolding");
                    }
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BBooleanPoint.TYPE))) {
                valid = address.isModbusDigitalAddress();
                if (!valid) {
                    this.errorMsg = lexicon.getText("pointManager.addressError.notDigital");
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BBooleanWritable.TYPE))) {
                if (BModbusPointManager.this.isModbusSlave()) {
                    valid = address.isModbusDigitalAddress();
                    if (!valid) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notDigital");
                    }
                } else {
                    valid = address.isModbusCoilAddress();
                    if (!valid) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notCoil");
                    }
                }
            }
            return valid;
        }
    }

    public class ModbusPointModel
    extends PointModel {
        ModbusPointModel(BModbusPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            if (BModbusPointManager.this.isModbusSlave()) {
                return BModbusPointManager.this.modbusSlaveCols;
            }
            return BModbusPointManager.this.modbusCols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
            ModbusPointModel.addBooleanPointTypes(list, (boolean)true);
            ModbusPointModel.addNumericPointTypes(list, (boolean)true);
            this.addRegisterBitPointTypes(list, true);
            if (!BModbusPointManager.this.isModbusSlave()) {
                ModbusPointModel.addStringPointTypes(list, (boolean)false);
                this.addEnumBitsPointTypes(list, true);
                this.addNumericBitsPointTypes(list, true);
            }
            return list.toArray(new MgrTypeInfo[0]);
        }

        public void addEnumBitsPointTypes(List<MgrTypeInfo> list, boolean writable) {
            if (writable) {
                list.add(MgrTypeInfo.make((TypeInfo)BEnumBitsWritable.TYPE.getTypeInfo()));
            }
            list.add(MgrTypeInfo.make((TypeInfo)BEnumBitsPoint.TYPE.getTypeInfo()));
        }

        public void addNumericBitsPointTypes(List<MgrTypeInfo> list, boolean writable) {
            if (writable) {
                list.add(MgrTypeInfo.make((TypeInfo)BNumericBitsWritable.TYPE.getTypeInfo()));
            }
            list.add(MgrTypeInfo.make((TypeInfo)BNumericBitsPoint.TYPE.getTypeInfo()));
        }

        public void addRegisterBitPointTypes(List<MgrTypeInfo> list, boolean writable) {
            if (writable) {
                list.add(MgrTypeInfo.make((TypeInfo)BRegisterBitWritable.TYPE.getTypeInfo()));
            }
            list.add(MgrTypeInfo.make((TypeInfo)BRegisterBitPoint.TYPE.getTypeInfo()));
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BBooleanPoint pt = null;
            BNullProxyExt ext = new BNullProxyExt();
            if (type.equals((Object)MgrTypeInfo.make((TypeInfo)BRegisterBitPoint.TYPE.getTypeInfo()))) {
                pt = new BBooleanPoint();
                ext = BModbusPointManager.this.makeModbusRegisterBitExt();
            } else if (type.equals((Object)MgrTypeInfo.make((TypeInfo)BRegisterBitWritable.TYPE.getTypeInfo()))) {
                pt = new BBooleanWritable();
                ext = BModbusPointManager.this.makeModbusRegisterBitExt();
            } else if (type.equals((Object)MgrTypeInfo.make((TypeInfo)BEnumBitsPoint.TYPE.getTypeInfo()))) {
                pt = new BEnumPoint();
                ext = BModbusPointManager.this.makeModbusEnumBitsExt();
            } else if (type.equals((Object)MgrTypeInfo.make((TypeInfo)BEnumBitsWritable.TYPE.getTypeInfo()))) {
                pt = new BEnumWritable();
                ext = BModbusPointManager.this.makeModbusEnumBitsExt();
            } else if (type.equals((Object)MgrTypeInfo.make((TypeInfo)BNumericBitsPoint.TYPE.getTypeInfo()))) {
                pt = new BNumericPoint();
                ext = BModbusPointManager.this.makeModbusNumericBitsExt();
            } else if (type.equals((Object)MgrTypeInfo.make((TypeInfo)BNumericBitsWritable.TYPE.getTypeInfo()))) {
                pt = new BNumericWritable();
                ext = BModbusPointManager.this.makeModbusNumericBitsExt();
            } else {
                pt = (BControlPoint)type.newInstance();
                if (pt instanceof BBooleanPoint) {
                    ext = BModbusPointManager.this.makeModbusBooleanExt();
                } else if (pt instanceof BNumericPoint) {
                    ext = BModbusPointManager.this.makeModbusNumericExt();
                } else if (pt instanceof BStringPoint) {
                    ext = BModbusPointManager.this.makeModbusStringExt();
                }
            }
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }

        public BComponent newInstance(MgrTypeInfo type, BFlexAddress startAddress, int offset, BDataTypeEnum dataType) throws Exception {
            BBooleanPoint pt = null;
            BNullProxyExt ext = new BNullProxyExt();
            if (type.equals((Object)MgrTypeInfo.make((Type)BRegisterBitPoint.TYPE))) {
                pt = new BBooleanPoint();
                ext = BModbusPointManager.this.makeModbusRegisterBitExt();
                BFlexAddress addr = new BFlexAddress();
                addr.setAddressFormat(startAddress.getAddressFormat());
                addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset / 16);
                ((BModbusProxyExt)ext).setDataAddress(addr);
                ((BIModbusRegisterBitProxyExt)ext).setBitNumber(offset % 16);
                if (addr.isModbusFormat()) {
                    if (addr.isModbusHoldingAddress()) {
                        ((BIModbusRegisterBitProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                    } else if (addr.isModbusInputAddress()) {
                        ((BIModbusRegisterBitProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BRegisterBitWritable.TYPE))) {
                pt = new BBooleanWritable();
                ext = BModbusPointManager.this.makeModbusRegisterBitExt();
                BFlexAddress addr = new BFlexAddress();
                addr.setAddressFormat(startAddress.getAddressFormat());
                addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset / 16);
                ((BModbusProxyExt)ext).setDataAddress(addr);
                ((BIModbusRegisterBitProxyExt)ext).setBitNumber(offset % 16);
                if (addr.isModbusFormat()) {
                    if (addr.isModbusHoldingAddress()) {
                        ((BIModbusRegisterBitProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                    } else if (addr.isModbusInputAddress()) {
                        ((BIModbusRegisterBitProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BEnumBitsPoint.TYPE))) {
                pt = new BEnumPoint();
                ext = BModbusPointManager.this.makeModbusEnumBitsExt();
                BFlexAddress addr = new BFlexAddress();
                addr.setAddressFormat(startAddress.getAddressFormat());
                addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset / 16);
                ((BModbusProxyExt)ext).setDataAddress(addr);
                ((BIModbusNumericBitsProxyExt)ext).setBeginningBit(offset % 16);
                if (addr.isModbusFormat()) {
                    if (addr.isModbusHoldingAddress()) {
                        ((BIModbusNumericBitsProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                    } else if (addr.isModbusInputAddress()) {
                        ((BIModbusNumericBitsProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BEnumBitsWritable.TYPE))) {
                pt = new BEnumWritable();
                ext = BModbusPointManager.this.makeModbusEnumBitsExt();
                BFlexAddress addr = new BFlexAddress();
                addr.setAddressFormat(startAddress.getAddressFormat());
                addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset / 16);
                ((BModbusProxyExt)ext).setDataAddress(addr);
                ((BIModbusEnumBitsProxyExt)ext).setBeginningBit(offset % 16);
                if (addr.isModbusFormat()) {
                    if (addr.isModbusHoldingAddress()) {
                        ((BIModbusEnumBitsProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                    } else if (addr.isModbusInputAddress()) {
                        ((BIModbusEnumBitsProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BNumericBitsPoint.TYPE))) {
                pt = new BNumericPoint();
                ext = BModbusPointManager.this.makeModbusNumericBitsExt();
                BFlexAddress addr = new BFlexAddress();
                addr.setAddressFormat(startAddress.getAddressFormat());
                addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset / 16);
                ((BModbusProxyExt)ext).setDataAddress(addr);
                ((BIModbusNumericBitsProxyExt)ext).setBeginningBit(offset % 16);
                if (addr.isModbusFormat()) {
                    if (addr.isModbusHoldingAddress()) {
                        ((BIModbusNumericBitsProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                    } else if (addr.isModbusInputAddress()) {
                        ((BIModbusNumericBitsProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (type.equals((Object)MgrTypeInfo.make((Type)BNumericBitsWritable.TYPE))) {
                pt = new BNumericWritable();
                ext = BModbusPointManager.this.makeModbusNumericBitsExt();
                BFlexAddress addr = new BFlexAddress();
                addr.setAddressFormat(startAddress.getAddressFormat());
                addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset / 16);
                ((BModbusProxyExt)ext).setDataAddress(addr);
                ((BIModbusNumericBitsProxyExt)ext).setBeginningBit(offset % 16);
                if (addr.isModbusFormat()) {
                    if (addr.isModbusHoldingAddress()) {
                        ((BIModbusNumericBitsProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                    } else if (addr.isModbusInputAddress()) {
                        ((BIModbusNumericBitsProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else {
                pt = (BControlPoint)type.newInstance();
                if (pt instanceof BBooleanPoint) {
                    ext = BModbusPointManager.this.makeModbusBooleanExt();
                    BFlexAddress addr = new BFlexAddress();
                    addr.setAddressFormat(startAddress.getAddressFormat());
                    addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset);
                    ((BModbusProxyExt)ext).setDataAddress(addr);
                    if (addr.isModbusFormat()) {
                        if (addr.isModbusCoilAddress()) {
                            ((BIModbusBooleanProxyExt)ext).setStatusType(BStatusTypeEnum.coil);
                        } else if (addr.isModbusStatusAddress()) {
                            ((BIModbusBooleanProxyExt)ext).setStatusType(BStatusTypeEnum.input);
                        }
                    }
                } else if (pt instanceof BNumericPoint) {
                    ext = BModbusPointManager.this.makeModbusNumericExt();
                    BFlexAddress addr = new BFlexAddress();
                    addr.setAddressFormat(startAddress.getAddressFormat());
                    addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset * DataTypeUtil.getRegisterCount((BDataTypeEnum)dataType));
                    ((BModbusProxyExt)ext).setDataAddress(addr);
                    ((BIModbusNumericProxyExt)ext).setDataType(dataType);
                    if (addr.isModbusFormat()) {
                        if (addr.isModbusHoldingAddress()) {
                            ((BIModbusNumericProxyExt)ext).setRegType(BRegisterTypeEnum.holding);
                        } else if (addr.isModbusInputAddress()) {
                            ((BIModbusNumericProxyExt)ext).setRegType(BRegisterTypeEnum.input);
                        }
                    }
                } else if (pt instanceof BStringPoint) {
                    ext = BModbusPointManager.this.makeModbusStringExt();
                    BFlexAddress addr = new BFlexAddress();
                    addr.setAddressFormat(startAddress.getAddressFormat());
                    addr.setAddressFromInt(startAddress.getDataAddressNoModbusAltering() + offset);
                    ((BModbusProxyExt)ext).setDataAddress(addr);
                }
            }
            BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
            ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

