/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.authn;

import com.tridium.fox.message.FoxMessage;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.fox.authn.BFoxCallbackHandler;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType
public class BFoxUsernamePasswordCallbackHandler
extends BFoxCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxUsernamePasswordCallbackHandler.class);
    protected String username = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        FoxMessage login = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                try {
                    if (login == null) {
                        login = this.getLogin();
                    }
                    this.handleNameCallback((NameCallback)callback, login);
                    continue;
                }
                catch (Exception e) {
                    AuthenticationUtil.debug((Level)Level.SEVERE, (String)"Could not acquire username from NameCallback", (Throwable)e);
                    throw new IOException("Could not acquire username.");
                }
            }
            if (callback instanceof PasswordCallback) {
                try {
                    if (login == null) {
                        login = this.getLogin();
                    }
                    this.handlePasswordCallback((PasswordCallback)callback, login);
                    continue;
                }
                catch (Exception e) {
                    AuthenticationUtil.debug((Level)Level.SEVERE, (String)"Could not acquire password from PasswordCallback", (Throwable)e);
                    throw new IOException("Could not acquire password.");
                }
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }

    protected void handleNameCallback(NameCallback nameCallback, FoxMessage login) {
        this.username = login.getString("username", null);
        nameCallback.setName(this.username);
    }

    protected void handlePasswordCallback(PasswordCallback passwordCallback, FoxMessage login) {
        String password = login.getString("password", null);
        passwordCallback.setPassword(password.toCharArray());
    }

    private FoxMessage getLogin() throws Exception {
        this.session.setState("FoxBasicCallbackHandler receive login");
        return this.session.receiveTuning("login");
    }

    @Override
    public String getUsername() {
        return this.username;
    }
}

