/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.message;

import com.tridium.fox.message.ReadLimitExceededException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;

public class MessageReader {
    private static final int CM_NAME = 1;
    private static final int CM_DIGIT = 2;
    private static final int CM_HEX = 4;
    private static final byte[] charMap;
    private static final int HISTORY_SIZE = 160;
    private static final Logger LOGGER;
    private final InputStream in;
    private final String clientHint;
    private int pushBack = -1;
    private final byte[] history = new byte[160];
    private int historyIndex = -1;
    private long bytesRead;
    private long readLimit = Long.MAX_VALUE;

    public MessageReader(InputStream in) {
        this(in, null);
    }

    public MessageReader(InputStream in, String clientHint) {
        this.in = in;
        this.clientHint = clientHint;
    }

    public void setReadLimit(long readLimit) {
        this.resetBytesRead();
        this.readLimit = readLimit;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void resetBytesRead() {
        this.bytesRead = 0L;
    }

    public final void assertReadLimit(int numBytes) throws ReadLimitExceededException {
        if (this.bytesRead + (long)numBytes > this.readLimit) {
            throw new ReadLimitExceededException(this.readLimit, numBytes, this.bytesRead);
        }
    }

    public final int read() throws IOException {
        if (this.pushBack != -1) {
            int v = this.pushBack;
            this.pushBack = -1;
            return v;
        }
        this.assertReadLimit(1);
        int v = this.in.read();
        if (v < 0) {
            throw new EOFException("EOF");
        }
        ++this.bytesRead;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = (byte)v;
        return v;
    }

    public final void readFully(byte[] buf, int off, int len) throws IOException {
        this.assertReadLimit(len);
        this.read(buf, off, len);
    }

    public final byte[] readFully(int len) throws IOException {
        this.assertReadLimit(len);
        byte[] buf = new byte[len];
        this.read(buf, 0, len);
        return buf;
    }

    private final void read(byte[] buf, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len; n += count) {
            count = this.in.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw this.error("EOF");
        }
        this.bytesRead += (long)n;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 98;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 108;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 111;
        this.historyIndex = (this.historyIndex + 1) % 160;
        this.history[this.historyIndex] = 98;
    }

    public final void pushBack(int pushBack) {
        if (this.pushBack != -1) {
            throw new IllegalStateException("Double push back");
        }
        this.pushBack = pushBack;
    }

    public final String readName() throws IOException {
        StringBuilder s = new StringBuilder();
        while (true) {
            int c;
            if ((charMap[c = this.read()] & 1) == 0) {
                if (s.length() == 0) {
                    throw this.error("Expected name");
                }
                this.pushBack(c);
                return s.toString();
            }
            s.append((char)c);
        }
    }

    public final String readTo(char stopChar) throws IOException {
        StringBuilder s = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.read()) == stopChar) {
                this.pushBack(c);
                return s.toString();
            }
            s.append((char)c);
        }
    }

    public final int readInt() throws IOException {
        int intValue = 0;
        boolean negative = false;
        int c = this.read();
        if ((charMap[c] & 2) != 0) {
            intValue = c - 48;
        } else if (c == 45) {
            negative = true;
        } else {
            throw this.error("Expecting int");
        }
        while (true) {
            if ((charMap[c = this.read()] & 2) == 0) break;
            intValue = intValue * 10 + (c - 48);
        }
        this.pushBack(c);
        if (negative) {
            intValue = -intValue;
        }
        return intValue;
    }

    public final long readLong() throws IOException {
        long longValue = 0L;
        boolean negative = false;
        int c = this.read();
        if ((charMap[c] & 2) != 0) {
            longValue = c - 48;
        } else if (c == 45) {
            negative = true;
        } else {
            throw this.error("Expecting int");
        }
        while (true) {
            if ((charMap[c = this.read()] & 2) == 0) break;
            longValue = longValue * 10L + (long)(c - 48);
        }
        this.pushBack(c);
        if (negative) {
            longValue = -longValue;
        }
        return longValue;
    }

    public final int readHex() throws IOException {
        int c;
        int intValue = 0;
        while (true) {
            if ((charMap[c = this.read()] & 4) == 0) break;
            if ((charMap[c] & 2) != 0) {
                intValue = (intValue << 4) + (c - 48);
                continue;
            }
            intValue = (intValue << 4) + 10 + (c - 97);
        }
        this.pushBack(c);
        return intValue;
    }

    public final long readHexLong() throws IOException {
        int c;
        long longValue = 0L;
        while (true) {
            if ((charMap[c = this.read()] & 4) == 0) break;
            if ((charMap[c] & 2) != 0) {
                longValue = (longValue << 4) + (long)(c - 48);
                continue;
            }
            longValue = (longValue << 4) + 10L + (long)(c - 97);
        }
        this.pushBack(c);
        return longValue;
    }

    public final String readSafe() throws IOException {
        int c;
        StringBuilder s = new StringBuilder();
        while (true) {
            if ((c = this.read()) < 32) break;
            if (c == 35) {
                if (s.length() == 0) {
                    int n = this.read();
                    if (n == 110) {
                        this.consume(117);
                        this.consume(108);
                        this.consume(108);
                        this.consume(59);
                        return null;
                    }
                    this.pushBack(n);
                }
                int hex = this.readHex();
                this.consume(59);
                s.append((char)hex);
                continue;
            }
            s.append((char)c);
        }
        this.pushBack(c);
        return s.toString();
    }

    public final void consume(String expected) throws IOException {
        int len = expected.length();
        for (int i = 0; i < len; ++i) {
            this.consume(expected.charAt(i));
        }
    }

    public final void consume(int expected) throws IOException {
        int actual = this.read();
        if (actual == -1) {
            throw new EOFException();
        }
        if (actual != expected) {
            throw this.error("invalid message, expected '" + this.toString(expected) + "', got '" + this.toString(actual) + "'");
        }
    }

    public final void close() throws IOException {
        this.in.close();
    }

    public IOException error(String msg) {
        if (LOGGER.isLoggable(Level.INFO)) {
            try (StringWriter writer = new StringWriter();
                 PrintWriter pwriter = new PrintWriter((Writer)writer, true);){
                if (this.clientHint != null) {
                    pwriter.println(msg + " (client hint: " + this.clientHint + ")");
                } else {
                    pwriter.println(msg);
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    Exception stack = new Exception("Stack trace");
                    stack.printStackTrace(pwriter);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    byte[] his = this.getHistory();
                    pwriter.println("--- History ---");
                    ByteArrayUtil.hexDump((PrintWriter)pwriter, (byte[])his, (int)0, (int)his.length);
                    byte[] fut = this.getFuture();
                    if (fut.length > 0) {
                        pwriter.println("--- Future ---");
                        ByteArrayUtil.hexDump((PrintWriter)pwriter, (byte[])fut, (int)0, (int)fut.length);
                    }
                }
                pwriter.flush();
                LOGGER.info(writer.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new IOException(msg);
    }

    public byte[] getHistory() {
        int i;
        byte[] ordered = new byte[160];
        int end = this.historyIndex + 1;
        int left = 160 - end;
        for (i = 0; i < left; ++i) {
            ordered[i] = this.history[i + end];
        }
        for (i = 0; i < end; ++i) {
            ordered[i + left] = this.history[i];
        }
        return ordered;
    }

    public byte[] getFuture() {
        try {
            int available = this.in.available();
            int toRead = Math.min(available, 160);
            if (toRead > 0) {
                byte[] buf = new byte[toRead];
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)this.read();
                }
                return buf;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    public String toString(int c) {
        if (c == 10) {
            return "\\n";
        }
        if (c < 32 || c > 126) {
            return "0x" + Integer.toHexString(c);
        }
        return String.valueOf((char)c);
    }

    static {
        int i;
        charMap = new byte[256];
        for (i = 97; i <= 122; ++i) {
            MessageReader.charMap[i] = 1;
        }
        for (i = 65; i <= 90; ++i) {
            MessageReader.charMap[i] = 1;
        }
        for (i = 48; i <= 57; ++i) {
            MessageReader.charMap[i] = 7;
        }
        i = 97;
        while (i <= 102) {
            int n = i++;
            charMap[n] = (byte)(charMap[n] | 4);
        }
        MessageReader.charMap[46] = 1;
        MessageReader.charMap[45] = 1;
        MessageReader.charMap[95] = 1;
        MessageReader.charMap[36] = 1;
        LOGGER = Logger.getLogger("fox.message");
    }
}

