/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.crypto.core.exchange.KeyExchange;
import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidChannelException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.fox.sys.UnreachableStationException;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.SecretBytes;
import com.tridium.sys.transfer.TransferListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BAes256CbcPasswordEncoder;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BAliasedAes256CbcPasswordEncoder;
import javax.baja.security.BAliasedAes256PasswordEncoder;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPermissions;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.status.BIStatus;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XException;

@NiagaraType
public abstract class BFoxChannel
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxChannel.class);
    private static final BIcon icon = BIcon.std((String)"bookmark.png");
    protected static final int ROUTED_CIRCUIT_BUFFER_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.fox.routedCircuitBufferSize", 8192));
    protected static final BiConsumer<FoxCircuit, FoxCircuit> DEFAULT_CIRCUIT_ROUTER = (sourceCircuit, destCircuit) -> {
        boolean bytesWritten = false;
        try {
            int len;
            FoxMessage req = sourceCircuit.readMessage();
            InputStream destInput = destCircuit.getInputStream();
            OutputStream sourceOutput = sourceCircuit.getOutputStream();
            destCircuit.writeMessage(req);
            destCircuit.flush();
            byte[] byteBuffer = new byte[ROUTED_CIRCUIT_BUFFER_SIZE];
            while ((len = destInput.read(byteBuffer, 0, ROUTED_CIRCUIT_BUFFER_SIZE)) >= 0) {
                sourceOutput.write(byteBuffer, 0, len);
                bytesWritten = true;
            }
        }
        catch (Exception e) {
            UnreachableStationException ex = e instanceof LocalizableRuntimeException && "fox.channel.unsupportedRemoteVersion".equals(((LocalizableRuntimeException)e).getLexiconKey()) ? new LocalizableRuntimeException("fox", "fox.channel.unsupportedRemoteVersionAlongRoute", ((LocalizableRuntimeException)e).getLexiconArguments()) : new UnreachableStationException(e);
            if (!bytesWritten && sourceCircuit.isOpen()) {
                try {
                    sourceCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)((Object)ex)));
                    sourceCircuit.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ex;
        }
    };
    private static final Set<String> LEGACY_BLACKLIST_TYPES;
    static final FoxResponse UNHANDLED_RESPONSE;
    private static final String KEY_HANDSHAKE_MESSAGE = "Simplify, then add lightness";
    private static final String REQ_TARGET_STATION_ROUTE = "nrsRoute";
    public static final Version VER_4_13;
    static final FoxLog foxLog;
    public final FoxLog log;
    private SecretBytes sharedEncodingKey = null;
    protected EncryptionAlgorithmBundle encryptionAlgorithmBundle = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BFoxChannel(String logName) {
        this.log = FoxLog.make("fox." + logName);
    }

    final void fwSessionOpened() throws Exception {
        FoxSession session;
        if (this.useSharedKeyEncryption() && !(session = this.getConnection().session()).isServer()) {
            this.initializeSharedKey(session);
        }
    }

    final void fwSessionClosed(Throwable cause) {
        if (this.sharedEncodingKey != null) {
            this.sharedEncodingKey.close();
            this.sharedEncodingKey = null;
        }
    }

    public void sessionOpened() throws Exception {
    }

    public void sessionClosed(Throwable cause) throws Exception {
    }

    final FoxResponse fwProcess(FoxRequest request) throws Throwable {
        FoxResponse resp;
        if (this.allowRoutingRequestToReachableStation(request) && (resp = BFoxChannel.checkRouteRequestToReachableStation(this, request)) != UNHANDLED_RESPONSE) {
            return resp;
        }
        switch (request.command) {
            case "initializeSharedKey": {
                return this.initializeSharedKey(request);
            }
            case "acceptSharedKey": {
                return this.acceptSharedKey(request);
            }
        }
        return UNHANDLED_RESPONSE;
    }

    public void checkProcess(FoxRequest req) throws Throwable {
        if (this.getConnection().session().isLegacyConnection()) {
            if (foxLog.isTraceOn()) {
                foxLog.trace("N4 station blocked AX station request (channel: " + req.channel + ", command: " + req.command + ")");
            }
            throw new IncompatibleVersionException("Niagara4 station cannot process NiagaraAX station request");
        }
    }

    final boolean fwCircuitOpened(FoxCircuit circuit) throws Throwable {
        if (this.allowRoutingCircuitToReachableStation(circuit)) {
            return BFoxChannel.checkRouteCircuitToReachableStation(this, circuit);
        }
        return false;
    }

    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
        if (this.getConnection().session().isLegacyConnection()) {
            if (foxLog.isTraceOn()) {
                foxLog.trace("N4 station blocked AX station circuit request (channel: " + circuit.channel + ", command: " + circuit.command + ")");
            }
            throw new IncompatibleVersionException("Niagara4 station cannot process NiagaraAX station request");
        }
    }

    public abstract FoxResponse process(FoxRequest var1) throws Throwable;

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        throw new InvalidCommandException(circuit.command);
    }

    public final FoxRequest makeRequest(String command) {
        return new FoxRequest(this.getName(), command);
    }

    public void checkSendRequest(FoxRequest req) throws Exception {
    }

    public void checkOpenCircuit(String command, FoxMessage metadata) throws Exception {
    }

    public final FoxCircuit openCircuit(String command) throws Exception {
        return this.openCircuit(command, null);
    }

    public final FoxCircuit openCircuit(String command, FoxMessage metadata) throws Exception {
        this.checkOpenCircuit(command, metadata);
        return this.getConnection().session().openCircuit(this.getName(), command, metadata);
    }

    public final FoxResponse sendSync(FoxRequest request) throws Exception {
        this.checkSendRequest(request);
        try {
            return this.getConnection().sendSync(request);
        }
        catch (NullPointerException e) {
            if (this.getConnection() == null) {
                throw new NotConnectedException();
            }
            throw e;
        }
    }

    public final void sendAsync(FoxRequest request) throws Exception {
        this.checkSendRequest(request);
        try {
            this.getConnection().sendAsync(request);
        }
        catch (NullPointerException e) {
            if (this.getConnection() == null) {
                throw new NotConnectedException();
            }
            throw e;
        }
    }

    public Map<String, Integer> getCircuitCommandThreadPriorities() {
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    public final BFoxConnection getConnection() {
        try {
            return (BFoxConnection)this.getParent().getParent();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public final BFoxClientConnection getClientConnection() {
        try {
            return (BFoxClientConnection)this.getParent().getParent();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public final BFoxServerConnection getServerConnection() {
        try {
            return (BFoxServerConnection)this.getParent().getParent();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public final Context getSessionContext() {
        return this.getServerConnection().getSessionContext();
    }

    public final BPermissions getPermissionsFor(Object object) {
        return this.getPermissionsFor(object, true);
    }

    public final BPermissions getPermissionsFor(Object object, boolean dumpError) {
        block3: {
            try {
                if (object instanceof BIProtected) {
                    return ((BIProtected)object).getPermissions(this.getSessionContext());
                }
            }
            catch (Exception e) {
                if (!dumpError) break block3;
                e.printStackTrace();
            }
        }
        return BPermissions.all;
    }

    public final BFoxSession getFoxSession() {
        return this.getClientConnection().getFoxSession();
    }

    protected ValueDocEncoder makeDefaultEncoder(OutputStream stream, Context cx) throws Exception {
        return new LegacyEncoder(this, stream, this.makeEncodingContext(cx));
    }

    protected ValueDocDecoder makeDefaultDecoder(InputStream stream, Context cx) throws Exception {
        return new ValueDocDecoder(stream, this.makeDecodingContext(cx));
    }

    protected SyncEncoder makeDefaultSyncEncoder(OutputStream stream, Context baseContext) throws Exception {
        return new FoxSyncEncoder(this, stream, this.makeEncodingContext(baseContext));
    }

    protected SyncDecoder makeDefaultSyncDecoder(InputStream stream, Context baseContext) throws Exception {
        return new SyncDecoder(stream, this.makeDecodingContext(baseContext));
    }

    protected void encodeValue(FoxMessage req, String name, BValue object, Context context) throws IOException {
        BogCodec.add(req, name, object, this.makeEncodingContext(context));
    }

    protected BValue decodeValue(FoxMessage msg, String key, Object arg) throws Exception {
        return (BValue)DecoderFactory.decode(msg, key, arg, this.makeDecodingContext(null));
    }

    protected String marshal(BValue value) throws Exception {
        return this.marshal(value, null);
    }

    protected String marshal(BValue value, Context cx) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LegacyEncoder encoder = new LegacyEncoder(this, out, this.makeEncodingContext(cx));
        encoder.encode(value);
        encoder.close();
        return new String(out.toByteArray());
    }

    protected BValue unmarshal(String xml) throws Exception {
        return this.unmarshal(xml, null);
    }

    protected BValue unmarshal(String xml, Context cx) throws Exception {
        return ValueDocDecoder.unmarshal((String)xml, (Context)this.makeDecodingContext(cx));
    }

    protected void encodeSimple(FoxMessage msg, String key, BSimple value, Context baseContext) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outStream);
        if (value instanceof BIContextEncodable) {
            ((BIContextEncodable)value).encode((DataOutput)out, this.makeEncodingContext(baseContext));
        } else {
            value.encode((DataOutput)out);
        }
        msg.add(key, outStream.toByteArray());
    }

    protected boolean useSharedKeyEncryption() {
        return false;
    }

    protected Context makeEncryptionContext(Context baseContext, boolean outgoing) {
        if (!this.useSharedKeyEncryption()) {
            return PasswordEncodingContext.updateForNone((Context)baseContext);
        }
        return AccessController.doPrivileged(() -> PasswordEncodingContext.updateContext((Context)baseContext, pContext -> {
            if (!pContext.hasEncryptionKey()) {
                if (this.sharedEncodingKey != null) {
                    if (outgoing) {
                        pContext.setDecryptionUndefined();
                        pContext.setEncryptionKey(EncryptionKeySource.shared, Optional.of(ISecretBytesSupplier.wrap((SecretBytes)this.sharedEncodingKey.newCopy())));
                        pContext.setEncryptionAlgorithmBundle(this.encryptionAlgorithmBundle);
                    } else {
                        pContext.setEncryptionKey(EncryptionKeySource.keyring, Optional.empty());
                        pContext.setDecryptionKey(EncryptionKeySource.shared, Optional.of(ISecretBytesSupplier.wrap((SecretBytes)this.sharedEncodingKey.newCopy())));
                    }
                } else {
                    pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.none, Optional.empty());
                }
            }
        }));
    }

    protected Context makeEncodingContext(Context baseContext) {
        return this.makeEncryptionContext(baseContext, true);
    }

    protected Context makeDecodingContext(Context baseContext) {
        return this.makeEncryptionContext(baseContext, false);
    }

    private void initializeSharedKey(FoxSession session) throws Exception {
        if (session.hasSessionKey()) {
            this.encryptionAlgorithmBundle = session.getEncryptionAlgorithmBundle();
            int keySize = this.encryptionAlgorithmBundle.getKeySize() / 8;
            byte[] salt = new byte[keySize];
            new SecureRandom().nextBytes(salt);
            this.sharedEncodingKey = new SecretBytes(session.makeSharedSecret(salt), 0, keySize);
            byte[] iv = new byte[keySize];
            new SecureRandom().nextBytes(iv);
            try {
                byte[] message = Aes256PasswordManager.encrypt((byte[])KEY_HANDSHAKE_MESSAGE.getBytes(), (byte[])iv, (byte[])this.sharedEncodingKey.get(), (String)this.getAesTransformation());
                FoxRequest req = this.makeRequest("initializeSharedKey");
                Base64.Encoder encoder = Base64.getEncoder();
                req.add("salt", encoder.encodeToString(salt));
                req.add("iv", encoder.encodeToString(iv));
                req.add("message", encoder.encodeToString(message));
                this.sendSync(req);
            }
            catch (InvalidKeyException ike) {
                this.log.warning("Could not negotiate shared key", ike);
            }
            catch (ServerException e) {
                if (e.getMessage().contains("InvalidChannelException")) {
                    InvalidChannelException ice = new InvalidChannelException(e.toString());
                    ice.initCause(e);
                    throw ice;
                }
                throw e;
            }
        } else if (session.isSecure() && !session.isLegacyConnection()) {
            byte[] randomBytes = new byte[16];
            BPassword keyPbk = BPassword.make((String)ByteArrayUtil.toHexString((byte[])randomBytes), (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
            this.sharedEncodingKey = new SecretBytes(((BPbkdf2HmacSha256PasswordEncoder)keyPbk.getPasswordEncoder()).getKey(), true);
            try {
                FoxRequest req = this.makeRequest("acceptSharedKey");
                Base64.Encoder encoder = Base64.getEncoder();
                req.add("key", encoder.encodeToString(this.sharedEncodingKey.get()));
                req.add("encryptionAlgorithmBundles", KeyExchange.getPreferredKeyExchangeCiphers256());
                FoxResponse resp = this.sendSync(req);
                String algorithmBundle = resp != null ? resp.getString("encryptionAlgorithmBundle", "aes-256.1") : "aes-256.1";
                this.encryptionAlgorithmBundle = (EncryptionAlgorithmBundle)CryptographicAlgorithmBundle.getInstance((String)algorithmBundle);
            }
            catch (ServerException e) {
                if (e.getMessage().contains("InvalidCommandException")) {
                    this.log.warning("Remote host's broker channel (pre-release version?) uses incompatible password value encoding", e);
                }
                if (e.getMessage().contains("InvalidChannelException")) {
                    InvalidChannelException ice = new InvalidChannelException(e.toString());
                    ice.initCause(e);
                    throw ice;
                }
                throw e;
            }
        }
    }

    private FoxResponse initializeSharedKey(FoxRequest req) throws Exception {
        FoxSession session = this.getConnection().session();
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] iv = decoder.decode(req.getString("iv"));
        byte[] salt = decoder.decode(req.getString("salt"));
        byte[] message = decoder.decode(req.getString("message"));
        byte[] key = session.makeSharedSecret(salt);
        int keySize = session.getSharedKeySize() / 8;
        this.sharedEncodingKey = new SecretBytes(key, 0, keySize);
        SecurityUtil.zeroByteArray((byte[])key);
        this.encryptionAlgorithmBundle = session.getEncryptionAlgorithmBundle();
        byte[] decryptedMessage = Aes256PasswordManager.decrypt((byte[])this.sharedEncodingKey.get(), (byte[])message, (byte[])iv, (String)this.getAesTransformation());
        if (!KEY_HANDSHAKE_MESSAGE.equals(new String(decryptedMessage))) {
            this.sharedEncodingKey.close();
            this.sharedEncodingKey = null;
            throw new Exception("Could not decrypt message");
        }
        return null;
    }

    private FoxResponse acceptSharedKey(FoxRequest req) throws Exception {
        if (this.getServerConnection().session().isSecure()) {
            String[] bundles;
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] key = decoder.decode(req.getString("key"));
            this.sharedEncodingKey = new SecretBytes(key, true);
            String algorithmBundles = req.getString("encryptionAlgorithmBundles", "aes-256.1");
            for (String bundle : bundles = algorithmBundles.split(":")) {
                CryptographicAlgorithmBundle algorithmBundle = CryptographicAlgorithmBundle.getInstance((String)bundle);
                if (!(algorithmBundle instanceof EncryptionAlgorithmBundle)) continue;
                this.encryptionAlgorithmBundle = (EncryptionAlgorithmBundle)algorithmBundle;
                break;
            }
            if (this.encryptionAlgorithmBundle == null) {
                this.encryptionAlgorithmBundle = (EncryptionAlgorithmBundle)CryptographicAlgorithmBundle.getInstance((String)"aes-256.1");
            }
            FoxResponse resp = new FoxResponse();
            resp.add("encryptionAlgorithmBundle", this.encryptionAlgorithmBundle.getAlgorithmName());
            return resp;
        }
        throw new IOException("Not a TLS connection");
    }

    protected String getAesTransformation() {
        if (this.encryptionAlgorithmBundle instanceof AesAlgorithmBundle) {
            return ((AesAlgorithmBundle)this.encryptionAlgorithmBundle).getAesTransformation();
        }
        return "AES/GCM/NoPadding";
    }

    public boolean isTraceOn() {
        return this.log.isTraceOn();
    }

    public void trace(String s) {
        System.out.print("-- ");
        System.out.print(this.log.getLogName());
        System.out.print(" ");
        System.out.println(s);
        this.log.logRecOnly(0, s);
    }

    protected static void verifyRemoteVersion(BFoxChannel channel, Version minimumVersion) {
        Version remoteVersion = new Version(channel.getConnection().session().getRemoteHello().getString("app.version", ""));
        if (remoteVersion.compareTo(minimumVersion) < 0) {
            throw new LocalizableRuntimeException("fox", "fox.channel.unsupportedRemoteVersion", new Object[]{minimumVersion.toString()});
        }
    }

    private BSimple getSimple(BSimple simple) throws IOException {
        BAes256PasswordEncoder newEncoder;
        BAbstractPasswordEncoder encoder;
        if (simple instanceof BPassword && this.getConnection().getRemoteVersion().compareTo(BAliasedAes256PasswordEncoder.MIN_VERSION) < 0 && (encoder = ((BPassword)simple).getPasswordEncoder()) instanceof BAliasedAes256PasswordEncoder) {
            try {
                newEncoder = new BAes256PasswordEncoder();
                newEncoder.encode(AccessController.doPrivileged(() -> ((BAbstractPasswordEncoder)encoder).getValue()));
                simple = BPassword.make((BAbstractPasswordEncoder)newEncoder);
            }
            catch (Exception e) {
                throw new IOException("could not transcode password", e);
            }
        }
        if (simple instanceof BPassword && this.getAesTransformation().equals("AES/CBC/PKCS5Padding")) {
            encoder = ((BPassword)simple).getPasswordEncoder();
            if (encoder instanceof BAliasedAes256PasswordEncoder) {
                try {
                    newEncoder = new BAliasedAes256CbcPasswordEncoder(((BAliasedAes256PasswordEncoder)encoder).getKeyAlias());
                    newEncoder.encode(AccessController.doPrivileged(() -> ((BAbstractPasswordEncoder)encoder).getValue()));
                    simple = BPassword.make((BAbstractPasswordEncoder)newEncoder);
                }
                catch (Exception e) {
                    throw new IOException("could not transcode password", e);
                }
            }
            if (encoder instanceof BAes256PasswordEncoder) {
                try {
                    newEncoder = new BAes256CbcPasswordEncoder();
                    newEncoder.encode(AccessController.doPrivileged(() -> ((BAbstractPasswordEncoder)encoder).getValue()));
                    simple = BPassword.make((BAbstractPasswordEncoder)newEncoder);
                }
                catch (Exception e) {
                    throw new IOException("could not transcode password", e);
                }
            }
        }
        return simple;
    }

    protected static final BValue checkNewInstance(BFoxChannel channel, ValueDocDecoder decoder, BComplex parent, String propName, Property prop, BValue newInstance, boolean skipLegacyEncodings) throws RuntimeException {
        if (newInstance == null) {
            return null;
        }
        if (BFoxChannel.isUnsupportedLegacyValue(channel, newInstance)) {
            if (skipLegacyEncodings) {
                try {
                    decoder.skip();
                }
                catch (XException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XException((Throwable)e);
                }
                return null;
            }
            throw new SecurityException("Niagara4 station cannot decode " + newInstance.getType() + " from AX station");
        }
        return newInstance;
    }

    private static boolean isUnsupportedLegacyValue(BFoxChannel channel, BValue val) {
        if (!channel.getConnection().session().isLegacyConnection()) {
            return false;
        }
        return BFoxChannel.isBlacklistedLegacyType(val.getType());
    }

    public static final boolean isBlacklistedLegacyType(Type type) {
        return LEGACY_BLACKLIST_TYPES.contains(type.toString());
    }

    protected static FoxMessage makeFoxMessageWithReachableStationRoute(BFoxChannel channel, FoxMessage baseMessage, Version minRouteVersion, String ... targetStationRoute) {
        if (targetStationRoute == null || targetStationRoute.length < 1) {
            return baseMessage;
        }
        FoxMessage message = baseMessage != null ? baseMessage : new FoxMessage();
        NiagaraStation station = channel.getConnection().getConnectionTarget(NiagaraStation.class).orElse(null);
        String remoteStationName = station != null ? station.getStationName() : null;
        boolean foundReachableStationName = false;
        for (String stationName : targetStationRoute) {
            if (!foundReachableStationName && stationName.equals(remoteStationName)) continue;
            foundReachableStationName = true;
            message.add(REQ_TARGET_STATION_ROUTE, stationName);
        }
        if (foundReachableStationName) {
            if (minRouteVersion == null || minRouteVersion.isNull() || minRouteVersion.compareTo(VER_4_13) < 0) {
                minRouteVersion = VER_4_13;
            }
            BFoxChannel.verifyRemoteVersion(channel, minRouteVersion);
        }
        return message;
    }

    protected boolean allowRoutingRequestToReachableStation(FoxRequest req) {
        return false;
    }

    protected Version getMinReachableStationVersionForRequest(FoxRequest req) {
        return null;
    }

    protected Version getMinVersionAlongRouteForRequest(FoxRequest req) {
        return null;
    }

    protected FoxResponse routeRequestToDestinationChannel(BFoxChannel destChannel, FoxRequest req) throws Exception {
        return destChannel.sendSync(req);
    }

    private static FoxResponse checkRouteRequestToReachableStation(BFoxChannel sourceChannel, FoxRequest req) throws Throwable {
        if (req.getOptional(REQ_TARGET_STATION_ROUTE) == null) {
            return UNHANDLED_RESPONSE;
        }
        String[] targetStationRoute = req.listStrings(REQ_TARGET_STATION_ROUTE);
        int routeLength = targetStationRoute.length;
        String firstRemoteStationName = null;
        if (routeLength > 0 && !targetStationRoute[routeLength - 1].equals(Sys.getStation().getStationName())) {
            req.remove(REQ_TARGET_STATION_ROUTE);
            Version minRemoteVersion = sourceChannel.getMinReachableStationVersionForRequest(req);
            boolean setVersionForRoute = false;
            for (String stationName : targetStationRoute) {
                if (firstRemoteStationName == null && stationName.equals(Sys.getStation().getStationName())) continue;
                if (firstRemoteStationName == null) {
                    firstRemoteStationName = stationName;
                    continue;
                }
                req.add(REQ_TARGET_STATION_ROUTE, stationName);
                if (setVersionForRoute) continue;
                minRemoteVersion = sourceChannel.getMinVersionAlongRouteForRequest(req);
                if (minRemoteVersion == null || minRemoteVersion.isNull() || minRemoteVersion.compareTo(VER_4_13) < 0) {
                    minRemoteVersion = VER_4_13;
                }
                setVersionForRoute = true;
            }
            if (firstRemoteStationName != null) {
                return BFoxChannel.doRouteRequestToReachableStation(firstRemoteStationName, sourceChannel, req, minRemoteVersion);
            }
        }
        return UNHANDLED_RESPONSE;
    }

    private static FoxResponse doRouteRequestToReachableStation(String stationName, BFoxChannel sourceChannel, FoxRequest req, Version minRemoteVersion) throws Throwable {
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest("FoxChannel - RouteRequest at " + Clock.ticks());
        BFoxClientConnection connection = null;
        try {
            NiagaraNetwork network = (NiagaraNetwork)Sys.getService((Type)Sys.getType((String)"niagaraDriver:NiagaraNetwork"));
            BComponent station = (BComponent)network.getStation(stationName);
            if (station == null) {
                throw new UnreachableStationException("Could not find station '" + stationName + "' in the NiagaraNetwork of station '" + Sys.getStation().getStationName() + '\'');
            }
            if (station instanceof BIStatus && (((BIStatus)station).getStatus().isDisabled() || ((BIStatus)station).getStatus().isDown() || ((BIStatus)station).getStatus().isFault())) {
                throw UnreachableStationException.makeUnoperationalStationException(stationName, Sys.getStation().getStationName());
            }
            connection = (BFoxClientConnection)station.get("clientConnection");
            connection.engageNoRetry(interest);
            BFoxChannel destChannel = connection.getChannels().get(sourceChannel.getName(), sourceChannel.getType());
            if (minRemoteVersion != null) {
                BFoxChannel.verifyRemoteVersion(destChannel, minRemoteVersion);
            }
            FoxResponse foxResponse = sourceChannel.routeRequestToDestinationChannel(destChannel, req);
            return foxResponse;
        }
        catch (Exception e) {
            Exception ex = e;
            boolean isLocalizable = false;
            if (ex instanceof LocalizableRuntimeException) {
                isLocalizable = true;
                if ("fox.channel.unsupportedRemoteVersion".equals(((LocalizableRuntimeException)ex).getLexiconKey())) {
                    ex = new LocalizableRuntimeException("fox", "fox.channel.unsupportedRemoteVersionAlongRoute", ((LocalizableRuntimeException)ex).getLexiconArguments());
                }
            }
            if (sourceChannel.log.log().isLoggable(Level.FINE)) {
                sourceChannel.log.log().log(Level.WARNING, "Failed to route request through remote station " + stationName, ex);
            }
            if (isLocalizable || ex instanceof UnreachableStationException) {
                throw ex;
            }
            throw new UnreachableStationException(ex);
        }
        finally {
            if (connection != null && connection.isEngaged(interest)) {
                connection.disengage(interest);
            }
        }
    }

    protected boolean allowRoutingCircuitToReachableStation(FoxCircuit circuit) {
        return false;
    }

    protected Version getMinReachableStationVersionForCircuit(FoxCircuit circuit) {
        return null;
    }

    protected Version getMinVersionAlongRouteForCircuit(FoxCircuit circuit) {
        return null;
    }

    protected BiConsumer<FoxCircuit, FoxCircuit> getCircuitRouter(String sourceCircuitCommand, BFoxChannel sourceChannel) {
        return DEFAULT_CIRCUIT_ROUTER;
    }

    private static boolean checkRouteCircuitToReachableStation(BFoxChannel channel, FoxCircuit circuit) throws Throwable {
        if (circuit.metadata == null || circuit.metadata.getOptional(REQ_TARGET_STATION_ROUTE) == null) {
            return false;
        }
        String[] targetStationRoute = circuit.metadata.listStrings(REQ_TARGET_STATION_ROUTE);
        int routeLength = targetStationRoute.length;
        String firstRemoteStationName = null;
        if (routeLength > 0 && !targetStationRoute[routeLength - 1].equals(Sys.getStation().getStationName())) {
            circuit.metadata.remove(REQ_TARGET_STATION_ROUTE);
            Version minRemoteVersion = channel.getMinReachableStationVersionForCircuit(circuit);
            boolean setVersionForRoute = false;
            for (String stationName : targetStationRoute) {
                if (firstRemoteStationName == null && stationName.equals(Sys.getStation().getStationName())) continue;
                if (firstRemoteStationName == null) {
                    firstRemoteStationName = stationName;
                    continue;
                }
                circuit.metadata.add(REQ_TARGET_STATION_ROUTE, stationName);
                if (setVersionForRoute) continue;
                minRemoteVersion = channel.getMinVersionAlongRouteForCircuit(circuit);
                if (minRemoteVersion == null || minRemoteVersion.isNull() || minRemoteVersion.compareTo(VER_4_13) < 0) {
                    minRemoteVersion = VER_4_13;
                }
                setVersionForRoute = true;
            }
            if (firstRemoteStationName != null) {
                BFoxChannel.doRouteCircuitToReachableStation(firstRemoteStationName, channel, circuit, minRemoteVersion);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void doRouteCircuitToReachableStation(String stationName, BFoxChannel sourceChannel, FoxCircuit sourceCircuit, Version minRemoteVersion) throws Throwable {
        block62: {
            boolean circuitRouted;
            FoxCircuit destinationCircuit;
            BFoxClientConnection.StringInterest interest;
            BFoxClientConnection connection;
            block58: {
                block59: {
                    connection = null;
                    interest = null;
                    destinationCircuit = null;
                    circuitRouted = false;
                    NiagaraNetwork network2333333332 = (NiagaraNetwork)Sys.getService((Type)Sys.getType((String)"niagaraDriver:NiagaraNetwork"));
                    BComponent station = (BComponent)network2333333332.getStation(stationName);
                    if (station == null) {
                        throw new UnreachableStationException("Could not find station '" + stationName + "' in the NiagaraNetwork of station '" + Sys.getStation().getStationName() + '\'');
                    }
                    if (station instanceof BIStatus && (((BIStatus)station).getStatus().isDisabled() || ((BIStatus)station).getStatus().isDown() || ((BIStatus)station).getStatus().isFault())) {
                        throw UnreachableStationException.makeUnoperationalStationException(stationName, Sys.getStation().getStationName());
                    }
                    interest = new BFoxClientConnection.StringInterest("FoxChannel - RouteCircuit at " + Clock.ticks());
                    connection = (BFoxClientConnection)station.get("clientConnection");
                    connection.engageNoRetry(interest);
                    BFoxChannel destChannel = connection.getChannels().get(sourceChannel.getName(), sourceChannel.getType());
                    if (minRemoteVersion != null) {
                        BFoxChannel.verifyRemoteVersion(destChannel, minRemoteVersion);
                    }
                    String sourceCircuitCommand = sourceCircuit.command;
                    destinationCircuit = destChannel.openCircuit(sourceCircuitCommand, sourceCircuit.metadata);
                    circuitRouted = true;
                    destChannel.getCircuitRouter(sourceCircuitCommand, sourceChannel).accept(sourceCircuit, destinationCircuit);
                    if (destinationCircuit == null) break block58;
                    if (destinationCircuit.getInputStream() == null) break block59;
                    try {
                        destinationCircuit.getInputStream().close();
                    }
                    catch (IOException network2333333332) {
                        // empty catch block
                    }
                }
                if (destinationCircuit.getOutputStream() != null) {
                    try {
                        destinationCircuit.getOutputStream().close();
                    }
                    catch (IOException network2333333332) {
                        // empty catch block
                    }
                }
                try {
                    destinationCircuit.close();
                }
                catch (RuntimeException network2333333332) {
                    // empty catch block
                }
            }
            if (sourceCircuit.getInputStream() != null) {
                try {
                    sourceCircuit.getInputStream().close();
                }
                catch (IOException network2333333332) {
                    // empty catch block
                }
            }
            if (sourceCircuit.getOutputStream() != null) {
                try {
                    sourceCircuit.getOutputStream().close();
                }
                catch (IOException network2333333332) {
                    // empty catch block
                }
            }
            if (connection != null && connection.isEngaged(interest)) {
                connection.disengage(interest);
            }
            break block62;
            catch (Exception e) {
                block60: {
                    block61: {
                        try {
                            Throwable ex = e;
                            if (ex instanceof LocalizableRuntimeException && "fox.channel.unsupportedRemoteVersion".equals(((LocalizableRuntimeException)ex).getLexiconKey())) {
                                ex = new LocalizableRuntimeException("fox", "fox.channel.unsupportedRemoteVersionAlongRoute", ((LocalizableRuntimeException)ex).getLexiconArguments());
                            } else if (ex instanceof BajaRuntimeException && ex.getCause() != null) {
                                ex = e.getCause();
                            }
                            if (sourceChannel.log.log().isLoggable(Level.FINE)) {
                                sourceChannel.log.log().log(Level.WARNING, "Failed to route circuit through remote station " + stationName, ex);
                            }
                            if (!circuitRouted && sourceCircuit.isOpen()) {
                                try {
                                    sourceCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage(ex));
                                    sourceCircuit.flush();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (destinationCircuit == null) break block60;
                            if (destinationCircuit.getInputStream() == null) break block61;
                        }
                        catch (Throwable throwable) {
                            if (destinationCircuit != null) {
                                if (destinationCircuit.getInputStream() != null) {
                                    try {
                                        destinationCircuit.getInputStream().close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (destinationCircuit.getOutputStream() != null) {
                                    try {
                                        destinationCircuit.getOutputStream().close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    destinationCircuit.close();
                                }
                                catch (RuntimeException runtimeException) {
                                    // empty catch block
                                }
                            }
                            if (sourceCircuit.getInputStream() != null) {
                                try {
                                    sourceCircuit.getInputStream().close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (sourceCircuit.getOutputStream() != null) {
                                try {
                                    sourceCircuit.getOutputStream().close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (connection != null && connection.isEngaged(interest)) {
                                connection.disengage(interest);
                            }
                            throw throwable;
                        }
                        try {
                            destinationCircuit.getInputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (destinationCircuit.getOutputStream() != null) {
                        try {
                            destinationCircuit.getOutputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        destinationCircuit.close();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (sourceCircuit.getInputStream() != null) {
                    try {
                        sourceCircuit.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (sourceCircuit.getOutputStream() != null) {
                    try {
                        sourceCircuit.getOutputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (connection != null && connection.isEngaged(interest)) {
                    connection.disengage(interest);
                }
            }
        }
    }

    static {
        HashSet blacklistTypes = new HashSet();
        Collections.addAll(blacklistTypes, "baja:Password", "baja:UsernameAndPassword", "baja:PasswordHistory");
        try {
            Collections.addAll(blacklistTypes, AccessController.doPrivileged(() -> System.getProperty("niagara.legacy.blacklistTypes", null)).split(";"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        LEGACY_BLACKLIST_TYPES = Collections.unmodifiableSet(blacklistTypes);
        UNHANDLED_RESPONSE = new FoxResponse();
        VER_4_13 = new Version("4.13");
        foxLog = FoxLog.make("fox");
    }

    protected static class LegacyTypeResolver
    extends ValueDocDecoder.BogTypeResolver {
        BFoxChannel channel;
        boolean skipLegacyEncodings = false;

        public LegacyTypeResolver(BFoxChannel channel, boolean skipLegacyEncodings) {
            this.channel = channel;
            this.skipLegacyEncodings = skipLegacyEncodings;
        }

        public BValue newInstance(ValueDocDecoder decoder, BComplex parent, String propName, Property prop, String typeStr) {
            BValue result = super.newInstance(decoder, parent, propName, prop, typeStr);
            return BFoxChannel.checkNewInstance(this.channel, decoder, parent, propName, prop, result, this.skipLegacyEncodings);
        }

        public void setSkipLegacyEncodings(boolean skipLegacyEncodings) {
            this.skipLegacyEncodings = skipLegacyEncodings;
        }

        public boolean getSkipLegacyEncodings() {
            return this.skipLegacyEncodings;
        }
    }

    protected static class LegacyEncoder
    extends ValueDocEncoder {
        BFoxChannel channel;

        public LegacyEncoder(BFoxChannel channel, OutputStream out, Context context) throws IOException {
            super(out, context);
            this.channel = channel;
        }

        protected void encodingValue(BValue val, Context cx) throws IOException {
            if (val == null) {
                return;
            }
            if (BFoxChannel.isUnsupportedLegacyValue(this.channel, val)) {
                throw new SecurityException("Niagara4 station cannot encode " + val.getType() + " to AX station");
            }
        }

        protected String encodeSimple(BSimple simple) throws IOException {
            return super.encodeSimple(this.channel.getSimple(simple));
        }
    }

    protected static class FoxSyncEncoder
    extends SyncEncoder {
        BFoxChannel channel;

        public FoxSyncEncoder(BFoxChannel channel, OutputStream out, Context cx) throws Exception {
            super(out, cx);
            this.channel = channel;
        }

        protected boolean encodePropertyValue(BComplex parent, Property prop, int depth, BPermissions permissions, Context context) throws IOException {
            FoxSession session = this.channel.getConnection().session();
            if (session.isServer() && !session.supportsSecureData() && prop.getType().is(BPassword.TYPE)) {
                BPassword newValue = BPassword.DEFAULT;
                String s = this.encodeSimple((BSimple)newValue);
                this.plugin.attrSafe("v", s);
                this.plugin.end().newLine();
                return true;
            }
            return super.encodePropertyValue(parent, prop, depth, permissions, context);
        }

        protected String encodeSimple(BSimple simple) throws IOException {
            return super.encodeSimple(this.channel.getSimple(simple));
        }
    }

    public class TransferStatusPipe
    implements TransferListener {
        FoxCircuit circuit;

        public TransferStatusPipe(FoxCircuit circuit) {
            this.circuit = circuit;
        }

        public void updateStatus(String status) {
            try {
                FoxMessage msg = new FoxMessage();
                msg.add("s", status);
                this.circuit.writeMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

