/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.spy;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.fox.sys.spy.FoxSessionSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;

public class FoxIndexSpy
extends SpyDir {
    public Spy find(String name) {
        if (name.equals("log")) {
            return new FoxLog.Index();
        }
        String id = name.substring("session-".length());
        FoxSession session = Fox.getSession(id);
        return new FoxSessionSpy(session);
    }

    public void write(SpyWriter out) {
        int i;
        FoxSession[] sessions = Fox.getSessions();
        out.startProps();
        out.trTitle((Object)"Fox", 2);
        out.prop((Object)"requestTimeout", Fox.requestTimeout);
        out.prop((Object)"keepAliveInterval", Fox.keepAliveInterval);
        out.prop((Object)"soTimeout", Fox.soTimeout);
        out.prop((Object)"tcpNoDelay", Fox.tcpNoDelay);
        out.prop((Object)"failsafeTimeouts", Fox.failsafeTimeouts);
        out.prop((Object)"maxServerSessions", Fox.maxServerSessions);
        out.prop((Object)"maxQueueSize", Fox.maxQueueSize);
        out.prop((Object)"circuitChunkSize", Fox.circuitChunkSize);
        out.prop((Object)"circuitMaxReceiveBuffer", Fox.circuitMaxReceiveBuffer);
        out.prop((Object)"hostName", (Object)Fox.hostName);
        out.prop((Object)"hostAddress", (Object)Fox.hostAddress);
        out.prop((Object)"app", (Object)(Fox.appName + " " + Fox.appVersion));
        out.prop((Object)"vm", (Object)(Fox.vmName + " " + Fox.vmVersion));
        out.prop((Object)"os", (Object)(Fox.osName + " " + Fox.osVersion));
        out.prop((Object)"exceptionTranslator", (Object)Fox.exceptionTranslator.getClass().getName());
        out.prop((Object)"engageLinger", (Object)("" + BFoxClientConnection.engageLinger));
        out.prop((Object)"preAuthFrameSizeLimit", (Object)("" + Fox.getPreAuthFrameSizeLimit()));
        out.prop((Object)"invalidFrameCount", (Object)("" + Fox.getInvalidFrameCount()));
        out.trTitle((Object)"Fox Log", 2);
        out.propNameLink((Object)"log", (Object)"Fox Log Index", (Object)("size=" + FoxLog.size));
        out.trTitle((Object)"Client Sessions", 2);
        for (i = 0; i < sessions.length; ++i) {
            if (sessions[i].isServer()) continue;
            this.prop(out, sessions[i]);
        }
        out.trTitle((Object)("Server Sessions [cached count=" + Fox.getServerSessionCount() + "]"), 2);
        for (i = 0; i < sessions.length; ++i) {
            if (!sessions[i].isServer()) continue;
            this.prop(out, sessions[i]);
        }
        out.trTitle((Object)"Fox Thread Pool Worker", 2);
        out.endProps();
        BFoxClientConnection.spyThreadPoolWorker(out);
    }

    private void prop(SpyWriter out, FoxSession s) {
        Object val;
        String n = "session-" + s.getId();
        FoxConnection conn = s.conn();
        int fwConnType = -1;
        if (conn instanceof BObject && (val = ((BObject)conn).fw(803, null, null, null, null)) instanceof Integer) {
            fwConnType = (Integer)val;
        }
        String displayName = fwConnType != -1 ? n + "-fw" : n;
        out.propNameLink((Object)n, (Object)displayName, (Object)s);
    }
}

