/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mcquay.comm.McQuayComm;
import com.tridium.mcquay.messages.McQuayMessageConst;
import com.tridium.mcquay.messages.McQuayReceivedMessage;
import javax.baja.nre.util.ByteBuffer;

public class McQuayCommReceiver
extends CommReceiver
implements McQuayMessageConst {
    int rcvCount = 0;
    private int state = 0;
    private ByteBuffer rcvBuffer = new ByteBuffer();

    protected ReceivedMessage receive() throws Exception {
        this.state = 0;
        this.rcvBuffer.reset();
        boolean done = false;
        while (!done) {
            byte b;
            boolean newChar;
            try {
                int charIn = this.getInputStream().read();
                newChar = charIn != -1;
                b = (byte)(charIn &= 0xFF);
            }
            catch (Exception e) {
                done = true;
                break;
            }
            if (!newChar) continue;
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (b == 32) {
                        this.state = 2;
                        this.rcvBuffer.write((int)b);
                        break;
                    }
                    this.state = 0;
                    this.rcvBuffer.reset();
                    break;
                }
                case 2: {
                    if (b == 49) {
                        this.rcvBuffer.write((int)b);
                        this.state = 0;
                        done = true;
                        break;
                    }
                    if (b == 66) {
                        this.rcvBuffer.write((int)b);
                        this.state = 3;
                        this.rcvCount = 0;
                        break;
                    }
                    if (b != 56) break;
                    this.rcvBuffer.write((int)b);
                    this.state = 0;
                    done = true;
                    break;
                }
                case 3: {
                    this.rcvBuffer.write((int)b);
                    ++this.rcvCount;
                    if (this.rcvCount != this.getMcQuayComm().responseMessageSize) break;
                    this.state = 0;
                    done = true;
                }
            }
        }
        if (this.rcvBuffer.getLength() <= 0) {
            return null;
        }
        byte[] tempBA = this.rcvBuffer.toByteArray();
        McQuayReceivedMessage msg = new McQuayReceivedMessage(tempBA, this.rcvBuffer.getLength());
        this.resetReceiveBuffer();
        return msg;
    }

    public synchronized void resetReceiveBuffer() {
        this.rcvBuffer.reset();
    }

    public synchronized void setState(int newState) {
        this.state = newState;
    }

    public McQuayComm getMcQuayComm() {
        return (McQuayComm)this.getComm();
    }
}

