/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.auth;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.workbench.auth.BCredentialsEditor;
import com.tridium.workbench.fieldeditors.BDefaultPasswordFE;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"baja:CertificateAliasCredential"})})
public class BCertificateAliasCredentialFE
extends BCredentialsEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateAliasCredentialFE.class);
    private BCertificateAliasCredential credential;
    private final BTextDropDown certField = new BTextDropDown();
    private final BDefaultPasswordFE certFieldPassword = new BDefaultPasswordFE();
    private final BTextField usernameField = new BTextField();
    private ICoreCryptoManager coreCryptoManager;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateAliasCredentialFE() {
        BGridPane mainPane = new BGridPane(2);
        mainPane.setHalign(BHalign.left);
        mainPane.setColumnGap(20.0);
        UiLexicon lex = UiLexicon.bajaui();
        mainPane.add(null, (BValue)new BLabel(lex.getText("auth.username")));
        mainPane.add(null, (BValue)this.usernameField);
        mainPane.add(null, (BValue)new BLabel(lex.getText("auth.certificate")));
        mainPane.add(null, (BValue)this.certField);
        mainPane.add(null, (BValue)new BLabel(lex.getText("auth.certificatePassword")));
        mainPane.add(null, (BValue)this.certFieldPassword);
        this.setContent((BWidget)mainPane);
        this.linkTo("lk0", (BComponent)this.usernameField, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.certField, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.certField, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk3", (BComponent)this.certFieldPassword, (Slot)BDefaultPasswordFE.pluginModified, (Slot)setModified);
    }

    protected void doSetReadonly(boolean readonly) {
        this.usernameField.setEnabled(!readonly);
        this.certField.getDisplayWidget().setEnabled(!readonly);
        this.certField.getDropDownWidget().setEnabled(!readonly);
        this.certField.setDropDownEnabled(!readonly);
        this.certFieldPassword.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.credential = (BCertificateAliasCredential)value;
        this.certField.getList().removeAllItems();
        this.usernameField.setText(this.credential.getUsername());
        this.certFieldPassword.loadValue((BObject)this.credential.getCertificatePassword());
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            throw new BajaException("Widget is not mounted in a shell or the shell isn't an instanceof BWbShell");
        }
        BOrd ord = shell.getActiveOrd();
        BComponent component = (BComponent)ord.get();
        BISession session = component.getSession();
        if (session == null) {
            throw new BajaException("Unable to retrieve session");
        }
        if (!(session instanceof BFoxSession)) {
            throw new BajaException("Fox session not available");
        }
        this.coreCryptoManager = new ChannelCryptoManager(component);
        ICoreKeyStore keyStore = this.coreCryptoManager.getKeyStore();
        AccessController.doPrivileged(() -> {
            Enumeration aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = (String)aliases.nextElement();
                if (!CertUtils.isClientCert((X509Certificate)keyStore.getCertificate(alias))) continue;
                this.certField.getList().addItem((Object)alias);
            }
            return null;
        });
        int index = this.certField.getList().indexOfItem((Object)this.credential.getCertificateAlias());
        if (index != -1) {
            this.certField.getList().setSelectedIndex(index);
            this.certField.setText(this.credential.getCertificateAlias());
        }
    }

    protected BObject doSaveValue(BObject v, Context cx) throws Exception {
        BCertificateAliasCredential certCredential = (BCertificateAliasCredential)v;
        BString username = BString.make((String)this.usernameField.getText());
        BString alias = BString.make((String)this.certField.getText());
        BPassword keyPassword = (BPassword)this.certFieldPassword.saveValue();
        Property[] properties = new Property[]{BCertificateAliasCredential.username, BCertificateAliasCredential.certificateAlias, BCertificateAliasCredential.certificatePassword};
        BValue[] values = new BValue[]{username, alias, keyPassword};
        certCredential.set(properties, values, cx);
        return certCredential;
    }
}

