/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.platcrypto.ui.BCryptoDialog;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="selectionModified"), @NiagaraAction(name="cancelButtonPressed")})
public class BCertImportChooserDialog
extends BCryptoDialog {
    @Generated
    public static final Action selectionModified = BCertImportChooserDialog.newAction((int)0, null);
    @Generated
    public static final Action cancelButtonPressed = BCertImportChooserDialog.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertImportChooserDialog.class);
    private BButton okButton;
    private BButton cancelButton;
    private BCheckList certCheckList;
    private final List<X509Certificate> certs = new ArrayList<X509Certificate>();

    @Generated
    public void selectionModified() {
        this.invoke(selectionModified, null, null);
    }

    @Generated
    public void cancelButtonPressed() {
        this.invoke(cancelButtonPressed, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BCertImportChooserDialog(BWidget owner, Array<X509Certificate> certs) throws Exception {
        super(owner, lex.getText("cert.import.chooser.title"));
        this.certs.addAll(certs.list());
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    static List<NX509Certificate> prompt(BWidget owner, Array<X509Certificate> certs) throws Exception {
        BCertImportChooserDialog dialog = new BCertImportChooserDialog(owner, certs);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getSelectedCerts();
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.getTitle(), lex.getText(lex.getText("cert.import.chooser.dialog.header")));
    }

    @Override
    protected BWidget buildBody() throws Exception {
        this.certCheckList = new BCheckList();
        for (X509Certificate cert : this.certs) {
            this.certCheckList.getModel().addItem((Object)new CertificateListItem(cert));
        }
        this.certCheckList.computePreferredSize();
        BGridPane mainPane = new BGridPane(1);
        BLabel introLabel = new BLabel(lex.getText("cert.import.chooser.dialog.intro"), BHalign.left);
        introLabel.setSize(this.certCheckList.getPreferredWidth(), 0.0);
        introLabel.setWordWrapEnabled(true);
        BLabel detailsLabel = new BLabel(lex.getText("cert.import.chooser.dialog.details"), BHalign.left);
        detailsLabel.setSize(this.certCheckList.getPreferredWidth(), 0.0);
        detailsLabel.setWordWrapEnabled(true);
        mainPane.add(null, (BValue)introLabel);
        mainPane.add(null, (BValue)this.certCheckList);
        mainPane.add(null, (BValue)detailsLabel);
        this.linkTo(null, (BComponent)this.certCheckList, (Slot)BCheckList.selectionModified, (Slot)selectionModified);
        return mainPane;
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doCancelButtonPressed() {
        this.certCheckList.getSelection().deselectAll();
        this.close();
    }

    public void doSelectionModified() {
        if (this.certCheckList.getSelectedItems().length == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private List<NX509Certificate> getSelectedCerts() {
        ArrayList<NX509Certificate> selectedCerts = new ArrayList<NX509Certificate>();
        for (Object certificateListItem : this.certCheckList.getSelectedItems()) {
            selectedCerts.add(((CertificateListItem)certificateListItem).getCertificate());
        }
        return selectedCerts;
    }

    private static class CertificateListItem {
        private NX509Certificate certificate;

        CertificateListItem(X509Certificate certificate) {
            this.certificate = NX509Certificate.make((X509Certificate)certificate);
        }

        public String toString() {
            return this.certificate.getSubject() + " (Key Usages: " + this.certificate.getKeyUsage() + ")";
        }

        public NX509Certificate getCertificate() {
            return this.certificate;
        }
    }
}

