/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.nre.security.CryptoProvider;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.ui.BCertEntryViewDialog;
import com.tridium.platcrypto.ui.BCertManagerView;
import com.tridium.platcrypto.ui.BLocalCertsTable;
import com.tridium.platcrypto.ui.BTrustCertsTable;
import com.tridium.platcrypto.ui.PrivateKeyPasswordFinder;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.RestartWebServerMessage;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.NHyperlinkInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.util.BNotifyPane;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

@NiagaraType
public abstract class BCertsTable
extends BCommandBoundTable
implements CommandBindings.Support {
    @Generated
    public static final Type TYPE = Sys.loadType(BCertsTable.class);
    public static final int COL_ALIAS = 0;
    public static final int COL_ISSUER = 1;
    public static final int COL_SUBJECT = 2;
    public static final int COL_NOT_BEFORE = 3;
    public static final int COL_NOT_AFTER = 4;
    public static final int COL_KEY_ALG = 5;
    public static final int COL_KEY_SIZE = 6;
    public static final int COL_SIG_ALG = 7;
    public static final int COL_SIG_SIZE = 8;
    public static final int COL_VALID = 9;
    public static final int COL_SELF_SIGNED = 10;
    protected HashMap<Integer, CertGenRequest> certGenRequests = new HashMap();
    protected CertGenMonitor certGenMonitor = null;
    protected static final Logger log = Logger.getLogger("platCrypto");
    public static final Lexicon lex = Lexicon.make((String)"platCrypto");
    public static final ExtFileFilter PEM_FILTER = new ExtFileFilter("", "pem,crt,cer");
    public static final String MISSING_ROOT_CA_ERROR_MESSAGE = "the trustAnchors parameter must be";
    public static final String EXPIRED_CERTIFICATE_ERROR_MESSAGE = "certificate expired";
    public static final String NOT_BEFORE_CERTIFICATE_ERROR_MESSAGE = "certificate not valid till";
    protected static String certsDirectoryPath = null;
    static final BImage securityHigh = BImage.make((String)lex.get("security.high.x16.icon", "module://icons/x16/security-high.png"));
    static final BImage securityMedium = BImage.make((String)lex.get("security.medium.x16.icon", "module://icons/x16/security-medium.png"));
    static final BImage securityLow = BImage.make((String)lex.get("security.low.x16.icon", "module://icons/x16/security-low.png"));
    static final BImage securityDefault = BImage.make((BIcon)BIcon.make((BIcon)BIcon.make((String)lex.get("security.medium.x16.icon", "module://icons/x16/security-medium.png")), (BIcon)BIcon.make((String)lex.get("security.default.badge.x16.icon", "module://icons/x16/badges/gear.png"))));
    static final BImage jobIcon = BImage.make((String)"module://icons/x16/doc.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    protected ICoreCryptoManager mgr = null;
    protected ICoreTrustStore trustStore = null;
    protected boolean readonly = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertsTable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BCertsTable(ICoreCryptoManager mgr, ICoreTrustStore trustStore) throws Exception {
        super((TableModel)new DynamicTableModel((TableModel)new CertModel(trustStore), new int[]{0, 2, 4, 5, 6, 9}));
        this.mgr = mgr;
        this.trustStore = trustStore;
        this.initCommands();
        BCertsTable.initCertDirectory();
    }

    public BCertsTable(ICoreCryptoManager mgr, ICoreTrustStore trustStore, CertModel model) throws Exception {
        super((TableModel)new DynamicTableModel((TableModel)model, new int[]{0, 2, 4, 5, 6, 9}));
        this.mgr = mgr;
        this.trustStore = trustStore;
        this.initCommands();
        BCertsTable.initCertDirectory();
    }

    public void load() throws Exception {
        this.certModel().load();
    }

    private static void initCertDirectory() {
        File certificateHome = Sys.getNiagaraUserHome();
        if (certificateHome.getPath().contains("n4applet")) {
            certificateHome = certificateHome.getParentFile().getParentFile();
        }
        if (!(certificateHome = new File(certificateHome, "certManagement")).exists() && !certificateHome.mkdirs()) {
            log.severe("CertsTable failed to create certificate directory");
            throw new BajaRuntimeException("CertsTable failed to create certificate directory");
        }
        certsDirectoryPath = certificateHome.toString().replace("\\", "/");
    }

    protected static String getCertsDirectoryPath() {
        if (certsDirectoryPath == null) {
            BCertsTable.initCertDirectory();
        }
        return certsDirectoryPath;
    }

    protected abstract void initCommands();

    protected CertModel certModel() {
        DynamicTableModel model = (DynamicTableModel)this.getModel();
        return (CertModel)model.getRootModel();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
        this.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (this.readonly && (command instanceof ImportCommand || command instanceof DeleteCommand)) {
            command.setEnabled(false);
        } else {
            command.setEnabled(bindingBasedState);
        }
    }

    protected synchronized void checkCertMonitorThread() {
        if (this.certGenMonitor == null || !this.certGenMonitor.isAlive()) {
            this.certGenMonitor = new CertGenMonitor();
            this.certGenMonitor.start();
        }
    }

    protected void notify(String title, BImage statusIcon, String status, String msg) {
        BLabel nameLbl = new BLabel(jobIcon, title);
        nameLbl.setFont(Theme.widget().getBoldText());
        BLabel statusLbl = new BLabel(statusIcon, status);
        BLabel msgLbl = new BLabel(msg);
        msgLbl.setForeground(Theme.widget().getControlShadow());
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)nameLbl);
        grid.add(null, (BValue)statusLbl);
        grid.add(null, (BValue)msgLbl);
        BNotifyPane pane = new BNotifyPane();
        pane.setCenter((BWidget)grid);
        pane.open();
    }

    public static class CertGenRequest {
        private final int requestId;
        private final String alias;
        private final long submitted;
        private long completed;
        private final boolean restartServerOnSuccess;

        public CertGenRequest(int requestId, String alias, boolean restartServerOnSuccess) {
            this.requestId = requestId;
            this.alias = alias;
            this.submitted = Clock.ticks();
            this.restartServerOnSuccess = restartServerOnSuccess;
        }

        public int getRequestId() {
            return this.requestId;
        }

        public String getAlias() {
            return this.alias;
        }

        static /* synthetic */ int access$000(CertGenRequest x0) {
            return x0.requestId;
        }

        static /* synthetic */ long access$102(CertGenRequest x0, long x1) {
            x0.completed = x1;
            return x0.completed;
        }

        static /* synthetic */ long access$100(CertGenRequest x0) {
            return x0.completed;
        }

        static /* synthetic */ long access$200(CertGenRequest x0) {
            return x0.submitted;
        }

        static /* synthetic */ boolean access$300(CertGenRequest x0) {
            return x0.restartServerOnSuccess;
        }
    }

    protected class CertGenMonitor
    extends Thread {
        private long lastRefresh;
        private static final long SLEEP_TIME = 2500L;
        private static final long REFRESH_PATIENCE = 60000L;

        public CertGenMonitor() {
            super("tCertGenMonitor");
            this.lastRefresh = Clock.ticks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (BCertsTable.this.certGenRequests != null && !BCertsTable.this.certGenRequests.isEmpty()) {
                for (CertGenRequest request : BCertsTable.this.certGenRequests.values()) {
                    try {
                        status = BCertsTable.this.mgr.getCertGenerationStatus(CertGenRequest.access$000(request));
                        if (status == -1) {
                            CertGenRequest.access$102(request, Clock.ticks());
                            BCertsTable.this.certGenRequests.remove(CertGenRequest.access$000(request));
                            BCertsTable.log.severe("cert generation failed for '" + request.getAlias() + "', job duration = " + (CertGenRequest.access$100(request) - CertGenRequest.access$200(request)));
                            BCertsTable.this.notify(BCertsTable.lex.get("cert.generate.title"), BCertsTable.failedIcon, BCertsTable.lex.get("cert.generate.failed"), BCertsTable.lex.getText("cert.generate.failed.msg", new Object[]{request.getAlias()}));
                            continue;
                        }
                        if (status != 2) continue;
                        BCertsTable.this.certGenRequests.remove(CertGenRequest.access$000(request));
                        CertGenRequest.access$102(request, Clock.ticks());
                        BCertsTable.log.fine("cert generation succeeded for '" + request.getAlias() + "', job duration = " + (CertGenRequest.access$100(request) - CertGenRequest.access$200(request)));
                        BCertsTable.this.notify(BCertsTable.lex.get("cert.generate.title"), BCertsTable.successIcon, BCertsTable.lex.get("cert.generate.success"), BCertsTable.lex.getText("cert.generate.success.msg", new Object[]{request.getAlias()}));
                        if (CertGenRequest.access$300(request)) {
                            if (BCertsTable.this.mgr instanceof BPlatCryptoManager) {
                                cryptoManager = (BPlatCryptoManager)BCertsTable.this.mgr;
                                session = cryptoManager.getDaemonSession();
                                if (new Version(session.getHostProperties().getDaemonVersion()).compareTo(new Version("4.6")) >= 0) {
                                    BCertsTable.log.fine("cert generation requests server restart, attempting web server restart");
                                    shell = BCertsTable.this.getShell();
                                    try {
                                        if (shell != null) {
                                            shell.enterBusy();
                                        }
                                        session.sendMessage((DaemonMessage)new RestartWebServerMessage(false));
                                        try {
                                            Thread.sleep(3500L);
                                        }
                                        catch (Exception var7_14) {
                                            // empty catch block
                                        }
                                        BCertsTable.log.fine("reconnecting to session");
                                        session.reconnect(null, null);
                                        BCertsTable.log.fine("session reconnected");
                                        if (!(shell instanceof BWbShell)) ** GOTO lbl53
                                        wbShell = (BWbShell)shell;
                                        hyperlinkOrd = BOrd.make((BOrd)session.getAbsoluteOrd().normalize(), (OrdQuery)new ViewQuery(BCertManagerView.TYPE.toString()));
                                        wbShell.hyperlink((HyperlinkInfo)new NHyperlinkInfo(hyperlinkOrd, BHyperlinkMode.replace, true, session.getCredentials()));
                                        if (!(shell instanceof BNiagaraWbShell) || (nwbShell = (BNiagaraWbShell)shell).getActiveOrdTarget() == null) ** GOTO lbl53
                                        nwbShell.syncTree();
                                    }
                                    finally {
                                        if (shell != null) {
                                            shell.exitBusy();
                                        }
                                    }
                                } else {
                                    BCertsTable.log.fine("cert generation requests restart but remote daemon version can not restart webserver, ignoring restart request");
                                }
lbl53:
                                // 4 sources

                                BCertsTable.this.certModel().load();
                                continue;
                            }
                            BCertsTable.this.certModel().load();
                            continue;
                        }
                        BCertsTable.this.certModel().load();
                    }
                    catch (NotConnectedException nce) {
                        BCertsTable.log.log(Level.SEVERE, "NotConnectedException occurred while monitoring certificate status", nce);
                        BCertsTable.this.certGenRequests.clear();
                        break;
                    }
                    catch (BDaemonSession.DaemonConnectException dce) {
                        BCertsTable.log.log(Level.SEVERE, "DaemonConnectException occurred while monitoring certificate status", dce);
                        BCertsTable.this.certGenRequests.clear();
                        break;
                    }
                    catch (Exception e) {
                        BCertsTable.log.log(Level.SEVERE, "Exception occurred while monitoring certificate status", e);
                    }
                }
                if (BCertsTable.this.certGenRequests.isEmpty()) break;
                now = Clock.ticks();
                if (now - this.lastRefresh > 60000L) {
                    BCertsTable.log.fine("detected long running cert generation, refreshing certificate model");
                    try {
                        BCertsTable.this.certModel().load();
                    }
                    catch (Exception e) {
                        BCertsTable.log.log(Level.WARNING, "unexpected error occurred while refreshing certificate model during status monitor", e);
                    }
                    this.lastRefresh = now;
                }
                try {
                    Thread.sleep(2500L);
                }
                catch (Exception var3_9) {}
            }
        }
    }

    protected class ViewCommand
    extends Command {
        public ViewCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.view");
        }

        public CommandArtifact doInvoke() {
            try {
                int row = BCertsTable.this.certModel().getSelection().getRow();
                BCertEntryViewDialog.show((BWidget)BCertsTable.this, BCertsTable.this.certModel().cert(row));
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.delete");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BCertsTable.this, (String)lex.getText("cert.delete.dialog.title"), (Object)lex.getText("cert.delete.dialog.info"), (int)12)) {
                    int[] rows = BCertsTable.this.getSelection().getRows();
                    String[] aliases = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        aliases[i] = BCertsTable.this.certModel().cert(rows[i]).getAlias();
                        log.fine("request to delete alias " + aliases[i]);
                    }
                    BCertsTable.this.trustStore.deleteEntries(aliases);
                    BCertsTable.this.trustStore.save();
                    BCertsTable.this.certModel().load();
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected abstract class ImportCommand
    extends Command {
        public ImportCommand() {
            super((BWidget)BCertsTable.this, lex, "cert.button.import");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() {
            block51: {
                try {
                    PrivateKey pkey;
                    Array certs;
                    BIFile importFile;
                    block54: {
                        CommandArtifact commandArtifact;
                        char[] password;
                        Object obj;
                        BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                        chooser.setTitle(lex.getText("cert.import.chooser.title"));
                        chooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("cert.extension.info"), "pem,p12,crt,cer,cert"));
                        chooser.setCurrentDirectory(BOrd.make((String)("file:/" + certsDirectoryPath)));
                        BOrd ord = chooser.show();
                        if (ord == null) {
                            return null;
                        }
                        importFile = (BIFile)ord.get();
                        if (importFile == null) break block51;
                        certs = new Array(X509Certificate.class);
                        pkey = null;
                        InputStreamReader isr = new InputStreamReader(importFile.getInputStream());
                        FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);
                        PEMParser pr = new PEMParser((Reader)fpr);
                        try {
                            obj = pr.readObject();
                            while (obj != null) {
                                if (obj instanceof X509Certificate) {
                                    certs.add((Object)((X509Certificate)obj));
                                    break block52;
                                }
                                if (obj instanceof X509CertificateHolder) {
                                    X509Certificate cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj);
                                    certs.add((Object)cert);
                                    break block52;
                                }
                                if (obj instanceof PrivateKey) {
                                    if (pkey == null) {
                                        pkey = (PrivateKey)obj;
                                        break block52;
                                    }
                                    throw new IOException("can't import multiple private keys from one file");
                                }
                                if (obj instanceof KeyPair) {
                                    if (pkey == null) {
                                        pkey = ((KeyPair)obj).getPrivate();
                                        break block52;
                                    }
                                    throw new IOException("can't import multiple private keys from one file");
                                }
                                if (obj instanceof PEMKeyPair) {
                                    if (pkey == null) {
                                        pkey = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).getPrivateKey(((PEMKeyPair)obj).getPrivateKeyInfo());
                                        break block52;
                                    }
                                    throw new IOException("can't import multiple private keys from one file");
                                }
                                if (obj instanceof PEMEncryptedKeyPair) {
                                    if (pkey == null) {
                                        while (true) {
                                            PEMDecryptorProvider decryptor;
                                            password = null;
                                            try {
                                                JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                                                decryptor = builder.build(new PrivateKeyPasswordFinder(this.getOwner(), lex.get("cert.import.privatekey.dialog.title"), lex.get("cert.import.privatekey.dialog.info")).getPassword());
                                                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                                                pkey = converter.getPrivateKey(((PEMEncryptedKeyPair)obj).decryptKeyPair(decryptor).getPrivateKeyInfo());
                                                break block52;
                                            }
                                            catch (Exception e) {
                                                if (password == null) {
                                                    decryptor = null;
                                                    try {
                                                        pr.close();
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                    return decryptor;
                                                }
                                                BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.errDialog.title"), (Object)lex.get("cert.import.privatekey.errDialog.info"));
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    throw new IOException("can't import multiple private keys from one file");
                                }
                                if (!(obj instanceof PKCS8EncryptedPrivateKeyInfo)) break block53;
                            }
                            break block54;
                        }
                        catch (AssertionError e) {
                            if (CryptoProvider.CryptoError.FIPS_PASSWORD_LENGTH == SecurityInitializer.getInstance().getCryptoProvider().parseThrowable((Throwable)((Object)e))) {
                                BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("cert.import.privatekey.badFipsPassword", new Object[]{PasswordStrength.MINIMUM_ALLOWED_LENGTH}));
                                commandArtifact = null;
                                return commandArtifact;
                            }
                            throw e;
                        }
                        catch (PasswordException pe) {
                            BDialog.error((BWidget)this.getOwner(), (Object)lex.get("cert.import.privatekey.badpassword"));
                            commandArtifact = null;
                            return commandArtifact;
                        }
                        finally {
                            try {
                                pr.close();
                            }
                            catch (Exception exception) {}
                        }
                        {
                            block52: {
                                block53: {
                                    while (true) {
                                        password = null;
                                        try {
                                            password = new PrivateKeyPasswordFinder(this.getOwner(), lex.get("cert.import.privatekey.dialog.title"), lex.get("cert.import.privatekey.dialog.info")).getPassword();
                                            InputDecryptorProvider pkcs8Prov = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).build(password);
                                            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                                            pkey = converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)obj).decryptPrivateKeyInfo(pkcs8Prov));
                                            break block52;
                                        }
                                        catch (Exception e) {
                                            if (password == null) {
                                                CommandArtifact commandArtifact2 = null;
                                                try {
                                                    pr.close();
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                return commandArtifact2;
                                            }
                                            BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.privatekey.errDialog.title"), (Object)lex.get("cert.import.privatekey.errDialog.info"));
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                if (obj instanceof PrivateKeyInfo) {
                                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                                    pkey = converter.getPrivateKey((PrivateKeyInfo)obj);
                                } else {
                                    throw new IOException("unsupported object type: " + obj.getClass().getName());
                                }
                            }
                            obj = pr.readObject();
                            continue;
                            break;
                        }
                    }
                    String defAlias = importFile.getFileName();
                    defAlias = defAlias.substring(0, defAlias.length() - importFile.getExtension().length() - 1);
                    this.importCertData((Array<X509Certificate>)certs, pkey, defAlias);
                    BCertsTable.this.trustStore.save();
                    BCertsTable.this.certModel().load();
                }
                catch (EncryptionException ee) {
                    BDialog.error((BWidget)this.getOwner(), (Object)lex.get("cert.import.privatekey.badpassword"));
                    return null;
                }
                catch (Exception e) {
                    if (e.getMessage() == null) {
                        CommandUtil.error((Command)this, (Throwable)e);
                    }
                    if (e.getMessage().contains(BCertsTable.MISSING_ROOT_CA_ERROR_MESSAGE)) {
                        CommandUtil.error((Command)this, (Throwable)e, (String)lex.getText("cert.import.missingRootCA"));
                    }
                    if (e.getMessage().contains(BCertsTable.EXPIRED_CERTIFICATE_ERROR_MESSAGE)) {
                        CommandUtil.error((Command)this, (Throwable)e, (String)lex.getText("cert.import.expiredCertificateMessage"));
                    }
                    if (e.getMessage().contains(BCertsTable.NOT_BEFORE_CERTIFICATE_ERROR_MESSAGE)) {
                        CommandUtil.error((Command)this, (Throwable)e, (String)lex.getText("cert.import.notBeforeCertificateMessage"));
                    }
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
            return null;
        }

        protected abstract void importCertData(Array<X509Certificate> var1, PrivateKey var2, String var3) throws Exception;
    }

    protected static class CertificateRow {
        private IX509CertificateEntry certificate;
        private String keySize = "";
        private String keyAlg = "";

        public CertificateRow(IX509CertificateEntry certificate) {
            this.certificate = certificate;
        }

        public void setCertificate(IX509CertificateEntry certificate) {
            this.certificate = certificate;
        }

        public void setKeySize(String keySize) {
            this.keySize = keySize;
        }

        public void setKeyAlg(String keyAlg) {
            this.keyAlg = keyAlg;
        }

        public IX509CertificateEntry getCertificate() {
            return this.certificate;
        }

        public String getKeyAlg() {
            return this.keyAlg;
        }

        public String getKeySize() {
            return this.keySize;
        }
    }

    protected static class CertModel
    extends TableModel {
        protected Array<CertificateRow> certs;
        protected ICoreTrustStore mgr;

        public CertModel(ICoreTrustStore mgr) {
            this.mgr = mgr;
        }

        public BImage getRowIcon(int row) {
            if (this.getTable() instanceof BTrustCertsTable) {
                if (!this.cert(row).getCertificate(0).checkValidity()) {
                    return securityLow;
                }
                return securityHigh;
            }
            try {
                if (!this.cert(row).getCertificate(0).checkValidity()) {
                    return securityLow;
                }
                if (this.getTable() instanceof BLocalCertsTable && "default".equalsIgnoreCase(this.cert(row).getAlias())) {
                    return securityDefault;
                }
                if (!this.cert(row).getCertificate(0).isSelfSigned()) {
                    return securityHigh;
                }
                return securityMedium;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception occurred while building row icon", e);
                return securityLow;
            }
        }

        public void load() throws Exception {
            this.certs = new Array(CertificateRow.class);
            try {
                for (IX509CertificateEntry certificateEntry : this.mgr.getCertificateEntries()) {
                    this.certs.add((Object)new CertificateRow(certificateEntry));
                }
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            this.updateTable(true);
            new Thread((Runnable)new AsyncLoader(), "AsyncCertificateLoader").start();
        }

        public int getColumnCount() {
            return 11;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("cert.field.alias");
                }
                case 1: {
                    return lex.getText("cert.field.issuedBy");
                }
                case 2: {
                    return lex.getText("cert.field.subject");
                }
                case 3: {
                    return lex.getText("cert.field.notBefore");
                }
                case 4: {
                    return lex.getText("cert.field.notAfter");
                }
                case 5: {
                    return lex.getText("cert.field.keyAlgorithm");
                }
                case 6: {
                    return lex.getText("cert.field.keySize");
                }
                case 7: {
                    return lex.getText("cert.field.signatureAlgorithm");
                }
                case 8: {
                    return lex.getText("cert.field.signatureSize");
                }
                case 10: {
                    return lex.getText("cert.field.selfSigned");
                }
                case 9: {
                    return lex.getText("cert.field.valid");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public synchronized void sortByColumn(int col, boolean ascending) {
            Object[] keys = this.getColumnValues(col);
            Object[] certs = (CertificateRow[])this.certs.trim();
            SortUtil.sort((Object[])keys, (Object[])certs, (boolean)ascending);
            this.certs.clear();
            this.certs.addAll(certs);
        }

        public int getRowCount() {
            return this.certs != null ? this.certs.size() : 0;
        }

        public IX509CertificateEntry cert(int row) {
            return ((CertificateRow)this.certs.get(row)).getCertificate();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.cert(row).getAlias();
                }
                case 1: {
                    return this.cert(row).getCertificate(0).getIssuer();
                }
                case 2: {
                    return this.cert(row).getCertificate(0).getSubject();
                }
                case 3: {
                    return this.cert(row).getCertificate(0).getNotBefore();
                }
                case 4: {
                    return this.cert(row).getCertificate(0).getNotAfter();
                }
                case 5: {
                    return ((CertificateRow)this.certs.get(row)).getKeyAlg();
                }
                case 6: {
                    return ((CertificateRow)this.certs.get(row)).getKeySize();
                }
                case 7: {
                    return this.cert(row).getCertificate(0).getSignatureAlgorithm();
                }
                case 8: {
                    return String.valueOf(this.cert(row).getCertificate(0).getSignatureSize());
                }
                case 10: {
                    return this.cert(row).getCertificate(0).isSelfSigned() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false");
                }
                case 9: {
                    return this.cert(row).getCertificate(0).checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        protected class AsyncLoader
        implements Runnable {
            protected AsyncLoader() {
            }

            @Override
            public void run() {
                for (CertificateRow row : CertModel.this.certs) {
                    row.setKeySize(String.valueOf(row.getCertificate().getCertificate(0).getKeySize()));
                    row.setKeyAlg(row.getCertificate().getCertificate(0).getKeyAlgorithm());
                    CertModel.this.updateTable();
                }
            }
        }
    }
}

