/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.platcrypto.ui.BPasswordField;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BPrivateKeyPasswordDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BPrivateKeyPasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BPrivateKeyPasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BPrivateKeyPasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPrivateKeyPasswordDialog.class);
    private static final Lexicon lex = Lexicon.make((String)"platCrypto");
    private static final Logger log = Logger.getLogger("platCrypto");
    private static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    protected BButton okButton;
    protected BButton cancelButton;
    private BPassword password = null;
    private BPasswordField passwordField = null;
    private BPasswordField confirmField = null;
    private BCheckBox defaultCheckBox = null;
    private final boolean passwordRequired;
    private final boolean confirmPasswordRequired;
    private final String title;
    private final String message;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BPassword open(BWidget owner) {
        return BPrivateKeyPasswordDialog.open(owner, false);
    }

    public static BPassword open(BWidget owner, boolean passwordRequired) {
        BPrivateKeyPasswordDialog dialog = new BPrivateKeyPasswordDialog(owner, lex.get("cert.export.privatekey.title"), lex.get("cert.export.privatekey.title"), passwordRequired, true);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getPassword();
    }

    public static BPassword open(BWidget owner, String title, String message, boolean passwordRequired) {
        BPrivateKeyPasswordDialog dialog = new BPrivateKeyPasswordDialog(owner, title, message, passwordRequired, true);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getPassword();
    }

    public static BPassword open(BWidget owner, String title, String message, boolean passwordRequired, boolean confirmPasswordRequired) {
        BPrivateKeyPasswordDialog dialog = new BPrivateKeyPasswordDialog(owner, title, message, passwordRequired, confirmPasswordRequired);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getPassword();
    }

    private BPrivateKeyPasswordDialog(BWidget owner, String title, String message, boolean passwordRequired, boolean confirmPasswordRequired) {
        super(owner, title, true);
        this.title = title;
        this.message = message;
        this.passwordRequired = passwordRequired;
        this.confirmPasswordRequired = confirmPasswordRequired;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        this.okButton.setEnabled(true);
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(this.buildHeader());
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(logo, this.title, this.message);
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildBody() {
        BGridPane pane = new BGridPane(1);
        BGridPane passwordPane = new BGridPane(2);
        passwordPane.setRowGap(5.0);
        passwordPane.setColumnGap(5.0);
        passwordPane.setColumnAlign(BHalign.left);
        passwordPane.setStretchColumn(1);
        passwordPane.add(null, (BValue)new BLabel(lex.get("password.field.password")));
        this.passwordField = new BPasswordField();
        passwordPane.add(null, (BValue)this.passwordField);
        if (this.confirmPasswordRequired) {
            passwordPane.add(null, (BValue)new BLabel(lex.get("password.field.confirm")));
            this.confirmField = new BPasswordField();
            passwordPane.add(null, (BValue)this.confirmField);
        }
        pane.add(null, (BValue)passwordPane);
        if (!this.passwordRequired) {
            this.defaultCheckBox = new BCheckBox(lex.get("password.global.label"));
            pane.add(null, (BValue)this.defaultCheckBox);
        }
        this.linkTo(null, (BComponent)this.passwordField, (Slot)BPasswordField.textModified, (Slot)setModified);
        if (this.confirmPasswordRequired) {
            this.linkTo(null, (BComponent)this.confirmField, (Slot)BPasswordField.textModified, (Slot)setModified);
        }
        if (!this.passwordRequired) {
            this.linkTo(null, (BComponent)this.defaultCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        }
        return pane;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public BPassword getPassword() {
        return this.password;
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        try {
            if (this.defaultCheckBox != null && this.defaultCheckBox.isSelected()) {
                this.password = BPassword.DEFAULT;
            } else if (!this.confirmPasswordRequired) {
                this.password = BPassword.make((String)this.passwordField.getText());
            } else {
                BPasswordStrength.DEFAULT.isPasswordValid(this.confirmField.getText());
                this.password = BPassword.make((String)this.confirmField.getText());
            }
            this.close();
        }
        catch (Exception e) {
            Lexicon bajaLex = Lexicon.make((String)"baja");
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)bajaLex.get("user.strongPassword.invalid"), (Throwable)e);
        }
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        try {
            if (this.defaultCheckBox != null && this.defaultCheckBox.getSelected()) {
                this.okButton.setEnabled(true);
                this.passwordField.setEnabled(false);
                if (this.confirmPasswordRequired) {
                    this.confirmField.setEnabled(false);
                }
            } else if (!this.confirmPasswordRequired) {
                this.passwordField.setEnabled(true);
                this.okButton.setEnabled(true);
            } else {
                this.passwordField.setEnabled(true);
                this.confirmField.setEnabled(true);
                this.okButton.setEnabled(this.passwordField.getText().equals(this.confirmField.getText()));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception occurred while setting modified state", e);
        }
    }
}

