/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.daemon.BPlatKeyStore;
import com.tridium.platcrypto.fox.ChannelKeyStore;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BPrivateKeyPasswordDialog;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.util.BPasswordPromptDialog;
import com.tridium.workbench.util.WbUtil;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BSelfSignedDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BSelfSignedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BSelfSignedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BSelfSignedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSelfSignedDialog.class);
    private static final Lexicon lex = Lexicon.make((String)"platCrypto");
    private static final Logger LOG = Logger.getLogger("platCrypto");
    private static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    private static final Version KEY_USAGE_VERSION = new Version("4.10");
    private static final Version ADVANCED_CERT_GEN_VERSION = new Version("4.13");
    private static final int KEY_USAGE_DIGITAL_SIGNATURE = 0;
    private static final int KEY_USAGE_NON_REPUDIATION = 1;
    private static final int KEY_USAGE_KEY_ENCIPHERMENT = 2;
    private static final int KEY_USAGE_DATA_ENCIPHERMENT = 3;
    private static final int KEY_USAGE_KEY_AGREEMENT = 4;
    private static final int KEY_USAGE_CERTIFICATE_SIGNING = 5;
    private static final int KEY_USAGE_CRL_SIGNING = 6;
    private static final int KEY_USAGE_ENCIPHER_ONLY = 7;
    private static final int KEY_USAGE_DECIPHER_ONLY = 8;
    public static final int[] KEY_USAGE_VALUES = new int[]{128, 64, 32, 16, 8, 4, 2, 1, 32768};
    protected BLabel aliasLabel;
    protected BWidget aliasWidget;
    protected BLabel commonNameLabel;
    protected BWidget commonNameWidget;
    protected BLabel commonNameDescLabel;
    protected BLabel commonNameDesc;
    protected BTextField alias;
    protected BTextField commonName;
    protected BTextField organizationalUnit;
    protected BTextField organization;
    protected BTextField locality;
    protected BTextField stateProvince;
    protected BTextField countryCode;
    protected BAbsTimeFE notBefore;
    protected BAbsTimeFE notAfter;
    protected BRadioButton keySize1024;
    protected BRadioButton keySize2048;
    protected BRadioButton keySize3072;
    protected BRadioButton keySize4096;
    protected BRadioButton serverCert;
    protected BRadioButton clientCert;
    protected BRadioButton caCert;
    protected BRadioButton codeSigningCert;
    protected BLabel serverLabel;
    protected BTextField alternativeServerName;
    protected BLabel uriLabel;
    protected BTextField alternativeUri;
    protected BTextField emailAddress;
    protected BCheckBox[] keyUsages = new BCheckBox[9];
    protected BPassword pkPassword;
    protected BButton okButton;
    protected BButton cancelButton;
    protected ICoreKeyStore store;
    protected int keySize = 2048;
    protected KeyPurpose keyPurpose = KeyPurpose.SERVER_CERT;
    protected boolean canceled = true;
    protected BPassword existingPassword = null;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BCertsTable.CertGenRequest show(BWidget owner, ICoreCryptoManager mgr, ICoreKeyStore store) {
        BSelfSignedDialog dialog = new BSelfSignedDialog(owner, store);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult(mgr);
    }

    public BSelfSignedDialog() {
        BWidget dialog = this.buildDialog();
        this.setContent(dialog);
        this.setDefaultButton(this.okButton);
    }

    public BSelfSignedDialog(BWidget parent, ICoreKeyStore store) {
        super(parent, lex.getText("cert.generate.dialog.title"), true);
        this.store = store;
        BWidget dialog = this.buildDialog();
        this.setContent(dialog);
        this.setDefaultButton(this.okButton);
    }

    protected BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(this.buildHeader());
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.getTitle(), lex.getText("cert.generate.dialog.info"));
    }

    protected BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    protected BWidget buildDnTextField(BTextField field, boolean required) {
        BGridPane dngrid = new BGridPane(2);
        dngrid.setStretchColumn(0);
        dngrid.setColumnAlign(BHalign.fill);
        dngrid.add(null, (BValue)field);
        if (required) {
            dngrid.add(null, (BValue)new BLabel(lex.getText("cert.field.required")));
        } else {
            dngrid.add(null, (BValue)new BLabel());
        }
        return dngrid;
    }

    protected BWidget buildBody() {
        BGridPane grid = new BGridPane(2);
        grid.setRowGap(5.0);
        grid.setColumnGap(5.0);
        grid.setColumnAlign(BHalign.left);
        grid.setStretchColumn(1);
        this.aliasLabel = new BLabel(lex.getText("cert.field.alias"));
        grid.add(null, (BValue)this.aliasLabel);
        this.alias = new BTextField("", 40);
        this.aliasWidget = this.buildDnTextField(this.alias, true);
        grid.add(null, (BValue)this.aliasWidget);
        this.commonNameLabel = new BLabel(lex.getText("cert.field.commonName"));
        grid.add(null, (BValue)this.commonNameLabel);
        this.commonName = new BTextField("", 40);
        this.commonNameWidget = this.buildDnTextField(this.commonName, true);
        grid.add(null, (BValue)this.commonNameWidget);
        this.commonNameDescLabel = new BLabel("");
        grid.add(null, (BValue)this.commonNameDescLabel);
        this.commonNameDesc = new BLabel(lex.getText("cert.field.commonName.desc"));
        grid.add(null, (BValue)this.commonNameDesc);
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.organizationalUnit")));
        this.organizationalUnit = new BTextField("", 40);
        grid.add(null, (BValue)this.buildDnTextField(this.organizationalUnit, false));
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.organization")));
        this.organization = new BTextField("", 40);
        grid.add(null, (BValue)this.buildDnTextField(this.organization, true));
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.locality")));
        this.locality = new BTextField("", 40);
        grid.add(null, (BValue)this.buildDnTextField(this.locality, false));
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.stateProvince")));
        this.stateProvince = new BTextField("", 40);
        grid.add(null, (BValue)this.buildDnTextField(this.stateProvince, false));
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.countryCode")));
        this.countryCode = new BTextField("", 3);
        grid.add(null, (BValue)this.buildDnTextField(this.countryCode, true));
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.notBefore")));
        this.notBefore = new BAbsTimeFE();
        grid.add(null, (BValue)this.notBefore);
        this.notBefore.loadValue((BObject)BAbsTime.now());
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.notAfter")));
        this.notAfter = new BAbsTimeFE();
        grid.add(null, (BValue)this.notAfter);
        this.notAfter.loadValue((BObject)BAbsTime.make((long)(Clock.millis() + BRelTime.makeHours((int)8760).getMillis())));
        BGridPane keyGrid = new BGridPane(4);
        keyGrid.setColumnGap(7.0);
        ToggleCommandGroup group = new ToggleCommandGroup();
        if (!SecurityInitializer.getInstance().isFips()) {
            this.keySize1024 = new BRadioButton(group, lex.getText("cert.field.1024bits"), false);
            keyGrid.add(null, (BValue)this.keySize1024);
        }
        this.keySize2048 = new BRadioButton(group, lex.getText("cert.field.2048bits"), true);
        keyGrid.add(null, (BValue)this.keySize2048);
        this.keySize3072 = new BRadioButton(group, lex.getText("cert.field.3072bits"), false);
        keyGrid.add(null, (BValue)this.keySize3072);
        this.keySize4096 = new BRadioButton(group, lex.getText("cert.field.4096bits"), false);
        keyGrid.add(null, (BValue)this.keySize4096);
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.keySize")));
        grid.add(null, (BValue)keyGrid);
        this.keySize2048.setSelected(true);
        BGridPane usageGrid = new BGridPane(4);
        group = new ToggleCommandGroup();
        this.serverCert = new BRadioButton(group, lex.getText("cert.field.serverCert"), true);
        usageGrid.add(null, (BValue)this.serverCert);
        this.clientCert = new BRadioButton(group, lex.getText("cert.field.clientCert"), false);
        usageGrid.add(null, (BValue)this.clientCert);
        this.caCert = new BRadioButton(group, lex.getText("cert.field.caCert"), false);
        usageGrid.add(null, (BValue)this.caCert);
        this.codeSigningCert = new BRadioButton(group, lex.getText("cert.field.codeSigningCert"), false);
        usageGrid.add(null, (BValue)this.codeSigningCert);
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.certUsage")));
        grid.add(null, (BValue)usageGrid);
        this.serverLabel = new BLabel(lex.getText("cert.field.serverAltName"));
        grid.add(null, (BValue)this.serverLabel);
        this.alternativeServerName = new BTextField("", 40);
        grid.add(null, (BValue)this.alternativeServerName);
        this.uriLabel = new BLabel(lex.getText("cert.field.serverAltUri"));
        grid.add(null, (BValue)this.uriLabel);
        this.alternativeUri = new BTextField("", 40);
        grid.add(null, (BValue)this.alternativeUri);
        grid.add(null, (BValue)new BLabel(lex.getText("cert.field.emailAddress")));
        this.emailAddress = new BTextField("", 40);
        grid.add(null, (BValue)this.emailAddress);
        if (this.shouldShowKeyUsage()) {
            grid.add(null, (BValue)new BLabel(lex.getText("cert.field.keyUsage")));
            BGridPane keyUsageGrid = new BGridPane(1);
            grid.add(null, (BValue)keyUsageGrid);
            BGridPane keyUsageSubGrid = null;
            for (int i = 0; i < this.keyUsages.length; ++i) {
                if (i % 3 == 0) {
                    keyUsageSubGrid = new BGridPane(3);
                    keyUsageGrid.add(null, (BValue)keyUsageSubGrid);
                }
                this.keyUsages[i] = new BCheckBox(lex.getText("cert.field.keyUsage." + i));
                keyUsageSubGrid.add(null, (BValue)this.keyUsages[i]);
                this.linkTo(null, (BComponent)this.keyUsages[i], (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
            }
            this.updateKeyUsage();
        }
        BGridPane x = new BGridPane(1);
        x.add(null, (BValue)grid);
        this.linkTo(null, (BComponent)this.alias, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.commonName, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.organization, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.countryCode, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.notBefore, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.notAfter, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.serverCert, (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.clientCert, (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.caCert, (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.codeSigningCert, (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
        return x;
    }

    private Version getRemoteVersion() {
        if (this.store instanceof ChannelKeyStore) {
            return ((ChannelKeyStore)this.store).getFoxSession().getConnection().getRemoteVersion();
        }
        if (this.store instanceof BPlatKeyStore) {
            return new Version(((BPlatKeyStore)this.store).getDaemonSession().getHostProperties().getDaemonVersion());
        }
        return null;
    }

    private boolean shouldShowKeyUsage() {
        Version remoteVersion = this.getRemoteVersion();
        if (remoteVersion == null) {
            return true;
        }
        return remoteVersion.compareTo(KEY_USAGE_VERSION) > 0;
    }

    private boolean isRemoteAdvancedCertSupportedVersion() {
        Version remoteVersion = this.getRemoteVersion();
        if (remoteVersion == null) {
            return true;
        }
        return remoteVersion.compareTo(ADVANCED_CERT_GEN_VERSION) >= 0;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BAbstractButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BAbstractButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void configureForCAOnly() {
        this.alternativeServerName.setEnabled(false);
        this.alternativeUri.setEnabled(false);
        this.serverCert.setEnabled(false);
        this.clientCert.setEnabled(false);
        this.caCert.setEnabled(false);
        this.codeSigningCert.setEnabled(false);
        this.caCert.setSelected(true);
        this.updateKeyUsage();
    }

    public void configureForServerOnly() {
        this.serverCert.setEnabled(false);
        this.clientCert.setEnabled(false);
        this.caCert.setEnabled(false);
        this.codeSigningCert.setEnabled(false);
        this.serverCert.setSelected(true);
        this.updateKeyUsage();
    }

    public void setKeyPurpose(KeyPurpose purpose) {
        if (purpose == KeyPurpose.SERVER_CERT) {
            this.serverCert.setSelected(true);
        } else if (purpose == KeyPurpose.CLIENT_CERT) {
            this.clientCert.setSelected(true);
        } else if (purpose == KeyPurpose.CA_CERT) {
            this.caCert.setSelected(true);
        } else if (purpose == KeyPurpose.CODE_SIGNING_CERT) {
            this.codeSigningCert.setSelected(true);
        } else {
            throw new InvalidParameterException("Invalid key purpose: " + purpose);
        }
        this.serverCert.setEnabled(false);
        this.clientCert.setEnabled(false);
        this.caCert.setEnabled(false);
        this.codeSigningCert.setEnabled(false);
        this.setModified(null);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        boolean passwordRequired;
        block11: {
            StringBuilder errorMessage = new StringBuilder();
            this.validateFields(errorMessage);
            if (errorMessage.length() > 0) {
                BDialog.error((BWidget)this, (String)lex.getText("cert.generate.error.failure"), (Object)lex.getText("cert.generate.error.failure.description"), (String)errorMessage.toString());
                return;
            }
            this.updateKeySize();
            this.updateKeyPurpose();
            try {
                String alias;
                if (this.store == null || !this.store.containsAlias(alias = this.alias.getText())) break block11;
                if (BDialog.open((BWidget)this, (String)lex.getText("cert.generate.warning.matchingAlias"), (Object)lex.getText("cert.generate.warning.matchingAlias.description", new Object[]{alias}), (int)12, (BImage)BDialog.WARNING_ICON) == 8) {
                    return;
                }
                if (WbUtil.isSuperUser((BWidget)this.getOwner()) || CertUtils.isPrivateKeyGloballyEncrypted((String)alias, (ICoreKeyStore)this.store)) break block11;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("password required to overwrite alias " + alias);
                }
                while (true) {
                    this.existingPassword = null;
                    BPassword keyPass = BPasswordPromptDialog.open((BWidget)this.getOwner(), (String)lex.get("cert.import.keyStoreKey.dialog.title"), (String)lex.getText("cert.import.keyStoreKey.dialog.info", new Object[]{alias}));
                    if (keyPass == null) {
                        return;
                    }
                    try {
                        this.store.getKey(alias, AccessController.doPrivileged(() -> ((BPassword)keyPass).getValue()).toCharArray());
                        this.existingPassword = keyPass;
                    }
                    catch (Exception e) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.get("cert.import.keyStoreKey.errDialog.title"), (Object)lex.get("cert.import.keyStoreKey.errDialog.info"));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to determine if certificate alias already exists", e);
            }
        }
        boolean bl = passwordRequired = this.keyPurpose == KeyPurpose.CA_CERT || this.keyPurpose == KeyPurpose.CODE_SIGNING_CERT;
        if (this.isRemoteAdvancedCertSupportedVersion()) {
            this.pkPassword = BPrivateKeyPasswordDialog.open((BWidget)this, passwordRequired);
            if (this.pkPassword == null) {
                return;
            }
        }
        this.canceled = false;
        this.close();
    }

    private void validateFields(StringBuilder errorMessage) {
        String aliasText;
        if (this.alias.getText().isEmpty()) {
            errorMessage.append("- ").append(lex.getText("cert.generate.error.requiredAlias")).append('\n');
        }
        if ("default".equalsIgnoreCase(aliasText = this.alias.getText())) {
            errorMessage.append("- ").append(lex.getText("cert.generate.error.protectedAlias")).append('\n');
        }
        if (this.commonName.getText().isEmpty()) {
            errorMessage.append("- ").append(lex.getText("cert.generate.error.requiredCommonName")).append('\n');
        }
        if (this.organization.getText().isEmpty()) {
            errorMessage.append("- ").append(lex.getText("cert.generate.error.requiredOrganization")).append('\n');
        }
        if (!BSelfSignedDialog.isValidCountryCode(this.countryCode.getText())) {
            errorMessage.append("- ").append(lex.getText("cert.generate.error.requiredCountryCode")).append('\n');
        }
    }

    private void updateKeySize() {
        if (this.keySize1024 != null && this.keySize1024.getSelected()) {
            if (BDialog.open((BWidget)this, (String)lex.getText("cert.generate.warning.weakKeySize"), (Object)lex.getText("cert.generate.warning.weakKeySize.description"), (int)12, (BImage)BDialog.WARNING_ICON, (String)null) == 8) {
                return;
            }
            this.keySize = 1024;
        } else if (this.keySize2048 != null && this.keySize2048.getSelected()) {
            this.keySize = 2048;
        } else if (this.keySize3072 != null && this.keySize3072.getSelected()) {
            this.keySize = 3072;
        } else if (this.keySize4096 != null && this.keySize4096.getSelected()) {
            this.keySize = 4096;
        }
    }

    private void updateKeyPurpose() {
        if (this.serverCert.getSelected()) {
            this.keyPurpose = KeyPurpose.SERVER_CERT;
        } else if (this.clientCert.getSelected()) {
            this.keyPurpose = KeyPurpose.CLIENT_CERT;
        } else if (this.caCert.getSelected()) {
            this.keyPurpose = KeyPurpose.CA_CERT;
        } else if (this.codeSigningCert.getSelected()) {
            this.keyPurpose = KeyPurpose.CODE_SIGNING_CERT;
        }
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        this.updateKeyUsage();
        this.okButton.setEnabled(this.requiredCertificateFieldsArePopulated());
    }

    protected boolean requiredCertificateFieldsArePopulated() {
        boolean serverSelected = this.serverCert.getSelected();
        this.serverLabel.setEnabled(serverSelected);
        this.alternativeServerName.setEnabled(serverSelected);
        this.alternativeServerName.setEditable(serverSelected);
        this.alternativeUri.setEnabled(serverSelected);
        this.alternativeUri.setEditable(serverSelected);
        try {
            return !this.alias.getText().trim().isEmpty() && !this.commonName.getText().trim().isEmpty() && !this.organization.getText().trim().isEmpty() && BSelfSignedDialog.isValidCountryCode(this.countryCode.getText()) && ((BAbsTime)this.notAfter.saveValue()).getMillis() > ((BAbsTime)this.notBefore.saveValue()).getMillis();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setKeyUsages(int keyUsage) {
        if (this.keyUsages[0] == null) {
            return;
        }
        this.updateKeyUsage();
        for (int i = 0; i < this.keyUsages.length; ++i) {
            if ((keyUsage & NX509Certificate.KEY_USAGE_VALUES[i]) == 0) continue;
            this.keyUsages[i].setSelected(true);
        }
    }

    private void updateKeyUsage() {
        if (this.keyUsages[0] == null) {
            return;
        }
        for (BCheckBox keyUsage : this.keyUsages) {
            if (keyUsage.isEnabled()) continue;
            keyUsage.setSelected(false);
            keyUsage.setEnabled(true);
        }
        this.keyUsages[5].setSelected(false);
        this.keyUsages[5].setEnabled(false);
        this.keyUsages[6].setSelected(false);
        this.keyUsages[6].setEnabled(false);
        if (this.serverCert.getSelected()) {
            this.keyUsages[0].setSelected(true);
            this.keyUsages[0].setEnabled(false);
            this.keyUsages[2].setSelected(true);
            this.keyUsages[2].setEnabled(false);
        } else if (this.clientCert.getSelected()) {
            this.keyUsages[0].setSelected(true);
            this.keyUsages[0].setEnabled(false);
        } else if (this.caCert.getSelected()) {
            this.keyUsages[5].setSelected(true);
            this.keyUsages[6].setSelected(true);
        } else if (this.codeSigningCert.getSelected()) {
            this.keyUsages[0].setSelected(true);
            this.keyUsages[0].setEnabled(false);
        }
    }

    private static boolean isValidCountryCode(String countryCode) {
        boolean ok = true;
        if (countryCode.isEmpty() || countryCode.trim().length() != 2) {
            ok = false;
        } else {
            int i;
            String[] countries = Locale.getISOCountries();
            for (i = 0; i < countries.length && !countryCode.equalsIgnoreCase(countries[i]); ++i) {
            }
            if (i == countries.length) {
                ok = false;
            }
        }
        return ok;
    }

    protected int getKeyUsage() {
        if (this.keyUsages[0] == null) {
            return 0;
        }
        int keyUsage = 0;
        for (int i = 0; i < this.keyUsages.length; ++i) {
            if (!this.keyUsages[i].getSelected()) continue;
            keyUsage |= KEY_USAGE_VALUES[i];
        }
        return keyUsage;
    }

    private NCertificateParameters getCertificateParams() throws Exception {
        String dn = CertUtils.assembleDN((String)(!this.commonName.getText().trim().isEmpty() ? this.commonName.getText() : null), (String)(!this.organizationalUnit.getText().trim().isEmpty() ? this.organizationalUnit.getText() : null), (String)(!this.organization.getText().trim().isEmpty() ? this.organization.getText() : null), (String)(!this.locality.getText().trim().isEmpty() ? this.locality.getText() : null), (String)(!this.stateProvince.getText().trim().isEmpty() ? this.stateProvince.getText() : null), !this.countryCode.getText().isEmpty() ? this.countryCode.getText() : null);
        return new NCertificateParameters(this.alias.getText(), dn, dn, new Date(((BAbsTime)this.notBefore.saveValue()).getMillis()), new Date(((BAbsTime)this.notAfter.saveValue()).getMillis()), this.keySize, this.keyPurpose, !this.alternativeServerName.getText().trim().isEmpty() ? this.alternativeServerName.getText() : null, !this.alternativeUri.getText().trim().isEmpty() ? this.alternativeUri.getText() : null, !this.emailAddress.getText().trim().isEmpty() ? this.emailAddress.getText() : null, this.pkPassword != null && !this.pkPassword.isDefault() ? AccessController.doPrivileged(() -> ((BPassword)this.pkPassword).getValue()) : null, this.getKeyUsage());
    }

    public NX509CertificateBuilder getCertificateBuilder() {
        try {
            NCertificateParameters params = this.getCertificateParams();
            return CertUtils.createCertBuilderFromParameters((NCertificateParameters)params);
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Unable to generate certificate parameters - " + e.getMessage());
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BCertsTable.CertGenRequest getResult(ICoreCryptoManager mgr) {
        if (this.canceled) {
            return null;
        }
        try {
            int requestId;
            if (!this.isRemoteAdvancedCertSupportedVersion()) {
                NCertificateParameters certParams = this.getCertificateParams();
                if (mgr == null) return null;
                requestId = mgr.generateSelfSignedCert(certParams);
                if (requestId != -1) return new BCertsTable.CertGenRequest(requestId, this.alias.getText(), false);
                return null;
            }
            NX509CertificateBuilder builder = this.getCertificateBuilder();
            NRsaKeyPairGenerator generator = new NRsaKeyPairGenerator(this.keySize);
            try (SecretChars existingPasswordChars = this.existingPassword != null ? this.existingPassword.getSecretChars() : null;
                 SecretChars pkPasswordChars = this.pkPassword != null && !this.pkPassword.isDefault() ? SecretChars.fromString((String)AccessController.doPrivileged(() -> ((BPassword)this.pkPassword).getValue())) : null;){
                if (mgr != null) {
                    requestId = mgr.generateSelfSignedCert(builder, (NKeyPairGenerator)generator, existingPasswordChars, pkPasswordChars);
                    if (requestId != -1) return new BCertsTable.CertGenRequest(requestId, this.alias.getText(), false);
                }
                BCertsTable.CertGenRequest certGenRequest = null;
                return certGenRequest;
            }
        }
        catch (Exception e) {
            if (!LOG.isLoggable(Level.SEVERE)) return null;
            LOG.severe("Unable to generate certificate - " + e.getMessage());
            return null;
        }
    }

    public String getAlias() {
        return this.alias.getText();
    }

    public BPassword getPassword() {
        return this.pkPassword != null && !this.pkPassword.isDefault() ? this.pkPassword : null;
    }
}

