/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.Enumeration;
import java.util.Properties;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;

@NiagaraType
public class BX509CertificateChangedPane
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BX509CertificateChangedPane.class);
    static Lexicon lex = Lexicon.make((String)"platCrypto");
    private IX509Certificate oldCert;
    private IX509Certificate cert;
    private Properties before;
    private Properties after;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BX509CertificateChangedPane() {
        this.cert = null;
        this.before = null;
        this.after = null;
    }

    public BX509CertificateChangedPane(IX509Certificate oldCert, IX509Certificate cert) {
        this.oldCert = oldCert;
        this.cert = cert;
        this.before = null;
        this.after = null;
        this.buildCertPane();
    }

    public BX509CertificateChangedPane(NX509Certificate oldCert, NX509Certificate cert, Properties before, Properties after) {
        this.oldCert = oldCert;
        this.cert = cert;
        this.before = before;
        this.after = after;
        this.buildCertPane();
    }

    public void set(NX509Certificate oldCert, NX509Certificate cert) {
        this.set(oldCert, cert, null, null);
    }

    public void set(NX509Certificate oldCert, NX509Certificate cert, Properties before, Properties after) {
        this.oldCert = oldCert;
        this.cert = cert;
        this.before = before;
        this.after = after;
        this.buildCertPane();
    }

    private void buildCertPane() {
        BGridPane grid = new BGridPane(2);
        grid.setStretchColumn(1);
        grid.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)grid, (String)"scrolled");
        grid.setColumnAlign(BHalign.fill);
        this.appendProperties(grid, this.before);
        this.appendCertProperties(grid);
        this.appendProperties(grid, this.after);
        this.setCenter((BWidget)grid);
    }

    protected void appendProperties(BGridPane grid, Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key, null);
            if (value == null) continue;
            grid.add(null, (BValue)this.createPaddedLabel(lex.getText(key), false));
            grid.add(null, (BValue)this.createPaddedLabel(value, true));
        }
    }

    protected void appendCertProperty(BGridPane grid, String label, String oldCertProp, String newCertProp) {
        if (oldCertProp.equals(newCertProp)) {
            grid.add(null, (BValue)this.createPaddedLabel(label, false));
            grid.add(null, (BValue)this.createPaddedLabel(newCertProp, true));
        } else {
            grid.add(null, (BValue)this.createPaddedLabel(label, false));
            BEdgePane pane = new BEdgePane();
            pane.setTop(this.createPaddedLabel("(-) " + oldCertProp, true));
            pane.setBottom(this.createChangedLabel("(+) " + newCertProp));
            grid.add(null, (BValue)pane);
        }
    }

    protected void appendCertProperties(BGridPane grid) {
        if (this.cert == null || this.oldCert == null) {
            return;
        }
        this.appendCertProperty(grid, lex.getText("cert.field.version"), "v" + this.oldCert.getVersion(), "v" + this.cert.getVersion());
        this.appendCertProperty(grid, lex.getText("cert.field.serialNum"), ByteArrayUtil.toHexString((byte[])this.oldCert.getSerialNumber().toByteArray(), (String)" "), ByteArrayUtil.toHexString((byte[])this.cert.getSerialNumber().toByteArray(), (String)" "));
        this.appendCertProperty(grid, lex.getText("cert.field.issuedBy"), this.oldCert.getIssuer(), this.cert.getIssuer());
        this.appendCertProperty(grid, lex.getText("cert.field.issuerDn"), this.oldCert.getIssuerDN().toString(), this.cert.getIssuerDN().toString());
        this.appendCertProperty(grid, lex.getText("cert.field.subject"), this.oldCert.getSubject(), this.cert.getSubject());
        this.appendCertProperty(grid, lex.getText("cert.field.subjectDn"), this.oldCert.getSubjectDN().toString(), this.cert.getSubjectDN().toString());
        this.appendCertProperty(grid, lex.getText("cert.field.notBefore"), this.oldCert.getNotBefore().toString(), this.cert.getNotBefore().toString());
        this.appendCertProperty(grid, lex.getText("cert.field.notAfter"), this.oldCert.getNotAfter().toString(), this.cert.getNotAfter().toString());
        this.appendCertProperty(grid, lex.getText("cert.field.keyAlgorithm"), this.oldCert.getKeyAlgorithm(), this.cert.getKeyAlgorithm());
        this.appendCertProperty(grid, lex.getText("cert.field.keySize"), this.oldCert.getKeySize() + "", this.cert.getKeySize() + "");
        this.appendCertProperty(grid, lex.getText("cert.field.signatureAlgorithm"), this.oldCert.getSignatureAlgorithm(), this.cert.getSignatureAlgorithm());
        this.appendCertProperty(grid, lex.getText("cert.field.signatureSize"), this.oldCert.getSignatureSize() + "", this.cert.getSignatureSize() + "");
        this.appendCertProperty(grid, lex.getText("cert.field.basicConstraints"), this.oldCert.getBasicConstraints(), this.cert.getBasicConstraints());
        this.appendCertProperty(grid, lex.getText("cert.field.keyUsage"), this.oldCert.getKeyUsage(), this.cert.getKeyUsage());
        this.appendCertProperty(grid, lex.getText("cert.field.extendedKeyUsage"), this.oldCert.getExtendedKeyUsage(), this.cert.getExtendedKeyUsage());
        this.appendCertProperty(grid, lex.getText("cert.field.md5Fingerprint"), this.oldCert.getMD5Fingerprint(), this.cert.getMD5Fingerprint());
        this.appendCertProperty(grid, lex.getText("cert.field.sha1Fingerprint"), this.oldCert.getSHA1Fingerprint(), this.cert.getSHA1Fingerprint());
        this.appendCertProperty(grid, lex.getText("cert.field.valid"), this.oldCert.checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false"), this.cert.checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false"));
    }

    private BWidget createPaddedLabel(String text, boolean fixed) {
        BLabel label = new BLabel(text, BHalign.left);
        if (fixed) {
            label.setFont(Theme.label().getFixedWidthFont((IStylable)label));
        }
        BBorderPane pane = new BBorderPane((BWidget)label, 0.0, 5.0, 0.0, 15.0);
        return pane;
    }

    private BWidget createChangedLabel(String text) {
        BLabel label = new BLabel(text, BHalign.left);
        label.setFont(Theme.label().getFixedWidthFont((IStylable)label));
        StyleUtils.addStyleClass((IStylable)label, (String)"warning emphasized");
        BBorderPane pane = new BBorderPane((BWidget)label, 0.0, 5.0, 0.0, 15.0);
        return pane;
    }
}

