/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.Enumeration;
import java.util.Properties;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;

@NiagaraType
public class BX509CertificatePane
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BX509CertificatePane.class);
    static Lexicon lex = Lexicon.make((String)"platCrypto");
    private IX509Certificate cert;
    private Properties before;
    private Properties after;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BX509CertificatePane() {
        this.cert = null;
        this.before = null;
        this.after = null;
    }

    public BX509CertificatePane(IX509Certificate cert) {
        this.cert = cert;
        this.before = null;
        this.after = null;
        this.buildCertPane();
    }

    public BX509CertificatePane(IX509Certificate cert, Properties before, Properties after) {
        this.cert = cert;
        this.before = before;
        this.after = after;
        this.buildCertPane();
    }

    public void set(NX509Certificate cert) {
        this.set(cert, null, null);
    }

    public void set(NX509Certificate cert, Properties before, Properties after) {
        this.cert = cert;
        this.before = before;
        this.after = after;
        this.buildCertPane();
    }

    private void buildCertPane() {
        BGridPane grid = new BGridPane(2);
        grid.setStretchColumn(1);
        grid.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)grid, (String)"scrolled");
        grid.setColumnAlign(BHalign.fill);
        this.appendProperties(grid, this.before);
        this.appendCertProperties(grid);
        this.appendProperties(grid, this.after);
        this.setCenter((BWidget)grid);
    }

    protected void appendProperties(BGridPane grid, Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key, null);
            if (value == null) continue;
            grid.add(null, (BValue)this.createPaddedLabel(lex.getText(key), false));
            grid.add(null, (BValue)this.createPaddedLabel(value, true));
        }
    }

    protected void appendCertProperties(BGridPane grid) {
        if (this.cert == null) {
            return;
        }
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.version"), false));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.version.prefix") + this.cert.getVersion(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.serialNum"), false));
        grid.add(null, (BValue)this.createPaddedLabel(ByteArrayUtil.toHexString((byte[])this.cert.getSerialNumber().toByteArray(), (String)" "), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.issuedBy"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getIssuer(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.issuerDn"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getIssuerDN().toString(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.subject"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getSubject(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.subjectDn"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getSubjectDN().toString(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.notBefore"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getNotBefore().toString(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.notAfter"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getNotAfter().toString(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.keyAlgorithm"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getKeyAlgorithm(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.keySize"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getKeySize() + "", true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.signatureAlgorithm"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getSignatureAlgorithm(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.signatureSize"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getSignatureSize() + "", true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.basicConstraints"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getBasicConstraints(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.keyUsage"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getKeyUsage(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.extendedKeyUsage"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getExtendedKeyUsage(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.md5Fingerprint"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getMD5Fingerprint(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.sha1Fingerprint"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.getSHA1Fingerprint(), true));
        grid.add(null, (BValue)this.createPaddedLabel(lex.getText("cert.field.valid"), false));
        grid.add(null, (BValue)this.createPaddedLabel(this.cert.checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false"), true));
    }

    private BWidget createPaddedLabel(String text, boolean fixed) {
        BLabel label = new BLabel(text, BHalign.left);
        if (fixed) {
            label.setFont(Theme.label().getFixedWidthFont((IStylable)label));
        }
        BBorderPane pane = new BBorderPane((BWidget)label, 0.0, 5.0, 0.0, 15.0);
        return pane;
    }
}

