/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.util.Version;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.ui.BCertExportDialog;
import com.tridium.platcrypto.ui.BCertificateSelectFE;
import com.tridium.platcrypto.ui.BCertificateSignerDialog;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BExportResponse;
import com.tridium.platcrypto.ui.BPrivateKeyPasswordDialog;
import com.tridium.platcrypto.ui.BSelfSignedDialog;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.workbench.util.BPasswordPromptDialog;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.net.NotConnectedException;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.platform.RemoteStation;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

public class CertificateWizardModel
extends WizardModel {
    private final BDaemonSession session;
    private ICoreCryptoManager localCoreCryptoManager;
    private final BPlatCryptoManager remoteCoreCryptoManager;
    private CertWizardStep currentStep;
    private static final int DIALOG_HEIGHT = 300;
    private static final int DIALOG_WIDTH = 650;
    private static final Logger log = Logger.getLogger("platCrypto");
    private static final BImage wizImage = BImage.make((String)"module://icons/x32/user.png");
    private static final Lexicon lex = Lexicon.make((String)"platCrypto");
    private Version remoteCoreCryptoManagerVersion;

    public CertificateWizardModel(BDaemonSession pSession) throws Exception {
        this.session = pSession;
        this.remoteCoreCryptoManager = new BPlatCryptoManager(this.session);
        try {
            this.localCoreCryptoManager = (ICoreCryptoManager)AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to create the CertificateWizardModel", e);
        }
    }

    public String getTitle() {
        return lex.getText("CertWizard.title");
    }

    public boolean cancel() {
        if ((this.getCurrentStep().getMode() & 4) == 0 && BDialog.confirm((BWidget)this.getWizard(), (String)lex.getText("CertWizard.cancel.title"), (Object)lex.getText("CertWizard.cancel.message")) == 4) {
            return this.getCurrentStep().cancel();
        }
        return false;
    }

    public void init() {
        CertWizardStep step;
        for (step = new ChecklistStep(); step != null && step.isSkipped(); step = step.getNextStep()) {
        }
        this.update(step);
        assert (step != null);
        step.enter();
    }

    public void back() {
        CertWizardStep step = this.getCurrentStep().getPriorStep();
        if (step != null && this.getCurrentStep().exit()) {
            this.update(step);
            step.enter();
        }
    }

    public void next() {
        CertWizardStep step = this.getCurrentStep().getNextStep();
        if (step != null && this.getCurrentStep().exit()) {
            while (step != null && step.isSkipped()) {
                step = step.getNextStep();
            }
            assert (step != null);
            step.setPriorStep(this.getCurrentStep());
            this.update(step);
            step.enter();
        }
    }

    public boolean finish() {
        return this.getCurrentStep().exit();
    }

    private CertWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(CertWizardStep step) {
        this.currentStep = step;
        this.update(step.getWidget(), step.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(650.0, 300.0);
    }

    protected BDaemonSession getDaemonSession() {
        return this.session;
    }

    private Version getRemoteCoreCryptoManagerVersion() {
        if (this.remoteCoreCryptoManagerVersion == null) {
            try {
                this.remoteCoreCryptoManagerVersion = this.remoteCoreCryptoManager.getCryptoManagerVersion();
            }
            catch (Exception e) {
                if (log.isLoggable(Level.WARNING) && e.getMessage() != null) {
                    log.warning(e.getMessage());
                    if (e.getCause() instanceof IllegalArgumentException) {
                        log.warning(e.getCause().getMessage());
                    }
                }
                this.remoteCoreCryptoManagerVersion = Version.ZERO;
            }
        }
        return this.remoteCoreCryptoManagerVersion;
    }

    private boolean isRemoteCoreCryptoManagerVersionGreaterThanOrEqualTo(Version version) {
        Version remoteDaemonVersion = this.getRemoteCoreCryptoManagerVersion();
        return !remoteDaemonVersion.equals((Object)Version.ZERO) && remoteDaemonVersion.compareTo((Object)version) >= 0;
    }

    private boolean isRemoteCoreCryptoManagerVersionLessThan(Version version) {
        Version remoteDaemonVersion = this.getRemoteCoreCryptoManagerVersion();
        return !remoteDaemonVersion.equals((Object)Version.ZERO) && remoteDaemonVersion.compareTo((Object)version) < 0;
    }

    static /* synthetic */ BImage access$000() {
        return wizImage;
    }

    private class StatusStep
    extends CertWizardStep {
        private ProcessStep step;
        private final ChecklistStep previousStep;
        private BCertsTable.CertGenRequest serverCertRequest;
        private BCertsTable.CertGenRequest caCertRequest;
        private CertMonitor certMonitor;
        private String certsDirectoryPath;
        private String serverCertAlias;
        private BPassword serverCertPkPasswd;
        private BSslTlsEnum tlsLevel;
        private String caCertAlias;
        private String caPassword;
        private String stationName;
        private NPKCS10CertificationRequest csr;
        private final BTextEditorPane statusText;

        StatusStep(ChecklistStep previousStep) {
            this.previousStep = previousStep;
            BEdgePane edgePane = new BEdgePane();
            this.statusText = new BTextEditorPane("", 60, 15, false);
            edgePane.setCenter((BWidget)this.statusText);
            this.setContent((BWidget)edgePane);
        }

        @Override
        public void enter() {
            if (this.previousStep.isSignServerCertChecked() && this.previousStep.isSignWithLocalCASelected()) {
                if (this.previousStep.getAlias().equals((Object)BString.make((String)lex.getText("CertAlias.generateNew")))) {
                    if (this.hasRunningStation()) {
                        BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.stationrunning"), (Object)lex.getText("CertWizard.status.stationrunning.error"));
                        return;
                    }
                    this.step = ProcessStep.GENERATE_CA_CERT;
                    this.generateCaCert();
                    return;
                }
                this.caCertAlias = this.previousStep.getAlias().getString();
            }
            if (this.previousStep.isGenerateCertChecked()) {
                if (this.hasRunningStation()) {
                    BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.stationrunning"), (Object)lex.getText("CertWizard.status.stationrunning.error"));
                    return;
                }
                this.step = ProcessStep.GENERATE_SERVER_CERT;
                this.generateServerCert();
                return;
            }
            if (!this.finalSteps()) {
                return;
            }
            CertificateWizardModel.this.update(4);
            CertificateWizardModel.this.getWizard().setCancelEnabled(false);
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BLabel(lex.getText("CertWizard.status.complete.message")));
            pane.setMinWidth(200.0);
            BDialog.info((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.complete.title"), (Object)pane);
        }

        @Override
        public boolean cancel() {
            if (this.certMonitor != null && this.certMonitor.running) {
                this.certMonitor.terminate();
                BDialog.message((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.certGenerated.title"), (Object)lex.getText("CertWizard.status.certGenerated.msg"));
            }
            return true;
        }

        private boolean getCertAliasFromRemotePlatform() {
            BCertificateSelectFE certificateSelect = new BCertificateSelectFE((ICoreCryptoManager)CertificateWizardModel.this.remoteCoreCryptoManager, BCertificateSelectFE.KeyStoreType.USER_KEYSTORE, KeyPurpose.SERVER_CERT);
            certificateSelect.doLoadValue(null, null);
            certificateSelect.setEnabled(false);
            certificateSelect.setEnabled(true);
            if (certificateSelect.getItemCount() <= 0) {
                BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.server.selectionError.title"), (Object)lex.getText("CertWizard.status.server.selectionError.notFound.message"));
                return false;
            }
            BGridPane gridPane = new BGridPane(1);
            gridPane.add(null, (BValue)certificateSelect);
            int result = BDialog.open((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.server.select.message"), (Object)gridPane, (int)3);
            if (result != 1) {
                BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.server.selectionError.title"), (Object)lex.getText("CertWizard.status.server.selectionError.cancelled.message"));
                return false;
            }
            this.serverCertAlias = certificateSelect.getText();
            return true;
        }

        @Override
        public String getStepName() {
            return "statusstep";
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        private boolean hasRunningStation() {
            boolean stationRunning;
            try {
                stationRunning = BStationSurrogate.isAnyStationRunning((BDaemonSession)CertificateWizardModel.this.getDaemonSession());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not determine running station status", e);
                return true;
            }
            return stationRunning;
        }

        private void generateCaCert() {
            try {
                this.caCertRequest = this.showCaCertDialog();
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.generating.ca"));
                if (this.caCertRequest != null) {
                    this.checkCertMonitorThread(CertificateWizardModel.this.localCoreCryptoManager, this.caCertRequest);
                } else {
                    this.certificateGenerationComplete(false);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not generate CA certificate", e);
            }
        }

        private void generateServerCert() {
            try {
                this.serverCertRequest = this.showServerCertDialog();
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.generating.server"));
                if (this.serverCertRequest != null) {
                    this.checkCertMonitorThread((ICoreCryptoManager)CertificateWizardModel.this.remoteCoreCryptoManager, this.serverCertRequest);
                } else {
                    this.certificateGenerationComplete(false);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not generate server certificate", e);
            }
        }

        private BCertsTable.CertGenRequest showCaCertDialog() throws Exception {
            BSelfSignedDialog dialog = new BSelfSignedDialog(this.getWidget(), CertificateWizardModel.this.localCoreCryptoManager.getKeyStore());
            dialog.configureForCAOnly();
            dialog.setBoundsCenteredOnOwner();
            dialog.setResizable(false);
            dialog.computePreferredSize();
            dialog.setTitle(lex.getText("CertWizard.status.ca.configure.title"));
            dialog.open();
            BPassword password = dialog.getPassword();
            if (password != null) {
                this.caPassword = AccessController.doPrivileged(() -> ((BPassword)password).getValue());
            }
            return dialog.getResult(CertificateWizardModel.this.localCoreCryptoManager);
        }

        private BCertsTable.CertGenRequest showServerCertDialog() throws Exception {
            BSelfSignedDialog dialog = new BSelfSignedDialog(this.getWidget(), CertificateWizardModel.this.remoteCoreCryptoManager.getKeyStore());
            dialog.configureForServerOnly();
            dialog.setBoundsCenteredOnOwner();
            dialog.setResizable(false);
            dialog.computePreferredSize();
            dialog.setTitle(lex.getText("CertWizard.status.server.configure.title"));
            dialog.open();
            this.serverCertPkPasswd = dialog.getPassword();
            return dialog.getResult((ICoreCryptoManager)CertificateWizardModel.this.remoteCoreCryptoManager);
        }

        synchronized void checkCertMonitorThread(ICoreCryptoManager manager, BCertsTable.CertGenRequest request) {
            this.certMonitor = new CertMonitor();
            this.certMonitor.initialize(manager, request);
            this.certMonitor.start();
        }

        private void certificateGenerationComplete(boolean success) {
            switch (this.step) {
                case GENERATE_CA_CERT: {
                    if (!success) {
                        this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                        BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.ca.generationError.title"), (Object)lex.getText("CertWizard.status.ca.generationError.message"));
                        return;
                    }
                    this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                    this.caCertAlias = this.caCertRequest.getAlias();
                    if (this.previousStep.isGenerateCertChecked()) {
                        this.step = ProcessStep.GENERATE_SERVER_CERT;
                        this.generateServerCert();
                        return;
                    }
                    if (this.finalSteps()) break;
                    return;
                }
                case GENERATE_SERVER_CERT: {
                    if (!success) {
                        this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                        BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.server.generationError.title"), (Object)lex.getText("CertWizard.status.server.generationError.message"));
                        return;
                    }
                    this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                    this.serverCertAlias = this.serverCertRequest.getAlias();
                    if (this.finalSteps()) break;
                    return;
                }
            }
            CertificateWizardModel.this.update(4);
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BLabel(lex.getText("CertWizard.status.complete.message")));
            pane.setMinWidth(200.0);
            BDialog.info((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.complete.title"), (Object)pane);
        }

        private boolean finalSteps() {
            if (this.previousStep.isSignServerCertChecked()) {
                if (this.serverCertAlias == null && !this.getCertAliasFromRemotePlatform()) {
                    return false;
                }
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.generating.csr"));
                this.csr = this.generateCsr();
                if (this.csr == null) {
                    this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                    BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.csr.generationError.title"), (Object)lex.getText("CertWizard.status.csr.generationError.message"));
                    return false;
                }
                this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                if (this.previousStep.isSignWithLocalCASelected()) {
                    this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.signingCert"));
                    if (!this.signServerCert()) {
                        this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                        BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.server.signError.title"), (Object)lex.getText("CertWizard.status.server.signError.message"));
                        return false;
                    }
                    this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                    if (this.previousStep.isInstallToTargetChecked()) {
                        this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.installingCa"));
                        if (!this.installCaToTarget()) {
                            this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                            BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.ca.installError.title"), (Object)lex.getText("CertWizard.status.ca.installError.message"));
                            return false;
                        }
                        this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                    }
                    if (this.previousStep.isExportCaCertChecked()) {
                        this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.exportingCa"));
                        if (!this.exportCaCertificate()) {
                            this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                            BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.ca.exportError.title"), (Object)lex.getText("CertWizard.status.ca.exportError.message"));
                            return false;
                        }
                        this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                    }
                } else {
                    this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.exportCsr"));
                    if (!this.exportCsr()) {
                        this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                        BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.csr.exportError.title"), (Object)lex.getText("CertWizard.status.csr.exportError.message"));
                        return false;
                    }
                    this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
                }
            }
            if (this.previousStep.isSetServiceCertChecked() || this.previousStep.isSetTlsLevelChecked()) {
                boolean skipStationTlsCertAliasesUpdate = false;
                boolean skipPlatformTlsCertAliasUpdate = false;
                if (this.previousStep.isSetServiceCertChecked()) {
                    if (this.serverCertAlias == null && !this.getCertAliasFromRemotePlatform()) {
                        return false;
                    }
                    try {
                        if (CertificateWizardModel.this.isRemoteCoreCryptoManagerVersionLessThan(ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION)) {
                            CertificateWizardModel.this.remoteCoreCryptoManager.getKeyStore().getKey(this.serverCertAlias, null);
                        }
                    }
                    catch (Exception e) {
                        skipStationTlsCertAliasesUpdate = true;
                        skipPlatformTlsCertAliasUpdate = true;
                    }
                    if (!(this.serverCertPkPasswd != null || this.serverCertRequest != null || skipPlatformTlsCertAliasUpdate && (skipStationTlsCertAliasesUpdate |= CertificateWizardModel.this.isRemoteCoreCryptoManagerVersionGreaterThanOrEqualTo(ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION)))) {
                        this.serverCertPkPasswd = AccessController.doPrivileged(() -> BPrivateKeyPasswordDialog.open(this.getWidget(), lex.getText("CertWizard.status.passwordDialogTitle"), lex.getText("CertWizard.status.passwordDialogInfo", new Object[]{this.serverCertAlias}), false, false));
                    }
                }
                if (this.previousStep.isSetTlsLevelChecked()) {
                    String version = this.previousStep.getTlsLevel();
                    this.tlsLevel = BSslTlsEnum.make((String)((String)CryptoSupport.TYPE_TAG_TO_VERSION.get(version)));
                }
                if (!this.setStationTlsSettings(skipStationTlsCertAliasesUpdate)) {
                    this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                    BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.station.setError.title"), (Object)lex.getText("CertWizard.status.station.setError.message"));
                    return false;
                }
                if (!this.setDaemonTlsSettings(skipPlatformTlsCertAliasUpdate)) {
                    this.appendToStatusText(lex.getText("CertWizard.status.message.failure"));
                    BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.daemon.setError.title"), (Object)lex.getText("CertWizard.status.daemon.setError.message"));
                    return false;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean signServerCert() {
            try {
                if (this.caPassword == null) {
                    this.caPassword = AccessController.doPrivileged(() -> ((BPassword)BPasswordPromptDialog.open((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.passwordDialogTitle"), (String)lex.getText("CertWizard.status.passwordDialogInfo", new Object[]{this.caCertAlias}))).getValue());
                }
                if (this.caPassword == null) {
                    return false;
                }
                try {
                    CertificateWizardModel.this.localCoreCryptoManager.getKeyStore().getKey(this.caCertAlias, this.caPassword.toCharArray());
                }
                catch (Exception ex) {
                    return false;
                }
                BCertificateSignerDialog dialog = new BCertificateSignerDialog(this.getWidget());
                dialog.initializeForCertificateWizard(this.csr, this.caCertAlias, this.caPassword, this.serverCertAlias);
                dialog.setBoundsCenteredOnOwner();
                dialog.computePreferredSize();
                dialog.setResizable(false);
                dialog.open();
                NX509Certificate[] certChain = dialog.getCertChain();
                ICoreKeyStore keyStore = CertificateWizardModel.this.remoteCoreCryptoManager.getKeyStore();
                try (SecretChars serverCertPrivKeyPassword = AccessController.doPrivileged(() -> this.serverCertPkPasswd != null && !this.serverCertPkPasswd.isDefault() ? this.serverCertPkPasswd.getSecretChars() : null);){
                    PrivateKey pkey = (PrivateKey)keyStore.getKey(this.serverCertAlias, serverCertPrivKeyPassword != null ? serverCertPrivKeyPassword.get() : null);
                    if (pkey == null) {
                        BDialog.warning((BWidget)this.getWidget(), (String)lex.get("cert.import.privatekey.missing.title"), (Object)lex.get("cert.import.privatekey.missing.msg"));
                        boolean bl = false;
                        return bl;
                    }
                    X509Certificate[] xChain = new X509Certificate[certChain.length];
                    for (int i = 0; i < certChain.length; ++i) {
                        xChain[i] = certChain[i].getCertificate();
                    }
                    keyStore.setKeyEntry(this.serverCertAlias, (Key)pkey, serverCertPrivKeyPassword != null ? serverCertPrivKeyPassword.get() : null, xChain);
                    keyStore.save();
                    return true;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not sign server certificate", e);
                return false;
            }
        }

        private boolean installCaToTarget() {
            try {
                ICoreTrustStore trustStore = CertificateWizardModel.this.remoteCoreCryptoManager.getUserTrustStore();
                X509Certificate caCert = CertificateWizardModel.this.localCoreCryptoManager.getKeyStore().getCertificate(this.caCertAlias);
                if (!NX509Certificate.make((X509Certificate)caCert).isSelfSigned()) {
                    throw new IOException("Certificate in the trust store must be root certificates");
                }
                String alias = trustStore.findCertificate(caCert);
                if (alias != null) {
                    if (BDialog.open((BWidget)this.getWidget(), (String)lex.getText("cert.generate.warning.matchingAlias"), (Object)lex.getText("cert.generate.warning.matchingAlias.description", new Object[]{alias}), (int)12, (BImage)BDialog.WARNING_ICON) == 8) {
                        return false;
                    }
                    trustStore.deleteEntry(alias);
                }
                trustStore.setCertificateEntry(this.caCertAlias, caCert);
                trustStore.save();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not install CA certificate", e);
                return false;
            }
            return true;
        }

        private boolean exportCaCertificate() {
            boolean success;
            block14: {
                success = true;
                PrivateKey pkey = null;
                try {
                    BICertificateFormatHandler certFormatHandler;
                    ICoreKeyStore keyStore = CertificateWizardModel.this.localCoreCryptoManager.getKeyStore();
                    X509Certificate cert = keyStore.getCertificate(this.caCertAlias);
                    NX509Certificate ncert = NX509Certificate.make((X509Certificate)cert);
                    X509Certificate[] certificateChain = keyStore.getCertificateChain(this.caCertAlias);
                    int keyMode = 2;
                    BExportResponse response = BCertExportDialog.show(this.getWidget(), ncert, keyMode);
                    if (response == null) break block14;
                    if (response.getExportPrivateKey()) {
                        try {
                            pkey = (PrivateKey)keyStore.getKey(this.caCertAlias, AccessController.doPrivileged(() -> ((BPassword)response.getPrivateKeyPassword()).getValue()).toCharArray());
                        }
                        catch (Exception eke2) {
                            log.log(Level.SEVERE, "Failed to retrieve private key for certificate", eke2);
                            BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.invalidPasswordTitle"), (Object)lex.getText("CertWizard.status.invalidPasswordMessage"));
                            return false;
                        }
                    }
                    if ((certFormatHandler = response.getCertFormatHandler()) == null) {
                        certFormatHandler = BPEMCertificateHandler.INSTANCE;
                    }
                    BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getWidget());
                    String fileName = this.caCertAlias + "." + certFormatHandler.getDefaultFileExtension();
                    this.certsDirectoryPath = this.getCertsDirectoryPath();
                    chooser.setTitle(lex.getText("CertWizard.exportDialogTitle"));
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + this.certsDirectoryPath)));
                    chooser.setDefaultFileName(fileName);
                    chooser.addFilter((IFileFilter)new ExtFileFilter(certFormatHandler.getCertificateFormatFileTypeName(null), String.join((CharSequence)",", certFormatHandler.getSupportedFileExtensions())));
                    BOrd ord = chooser.show();
                    if (ord == null) {
                        return false;
                    }
                    BAbstractFile target = (BAbstractFile)ord.get();
                    if (certificateChain == null) {
                        certificateChain = new X509Certificate[]{cert};
                    }
                    if (response.getExportPrivateKey() && response.getExportCert()) {
                        certFormatHandler.writeCertAndKeyToFile(pkey, response.getEncryptPrivateKey(), response.getReusePassword() ? response.getPrivateKeyPassword() : response.getPrivateKeySavedPassword(), certificateChain, target);
                    } else if (response.getExportPrivateKey()) {
                        certFormatHandler.writeKeyToFile(pkey, response.getEncryptPrivateKey(), response.getReusePassword() ? response.getPrivateKeyPassword() : response.getPrivateKeySavedPassword(), target);
                    } else if (response.getExportCert()) {
                        certFormatHandler.writeCertToFile(certificateChain, target);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to export certificate", e);
                    BDialog.error((BWidget)this.getWidget(), (String)lex.getText("CertWizard.export.error.title"), (Object)lex.getText("CertWizard.export.error.msg"), (Throwable)e);
                    success = false;
                }
            }
            if (success) {
                BDialog.message((BWidget)this.getWidget(), (String)lex.getText("CertWizard.export.success.title"), (Object)lex.getText("CertWizard.export.success.msg"));
            }
            return success;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NPKCS10CertificationRequest generateCsr() {
            if (this.serverCertRequest == null) {
                this.serverCertPkPasswd = AccessController.doPrivileged(() -> BPrivateKeyPasswordDialog.open(this.getWidget(), lex.getText("CertWizard.status.passwordDialogTitle"), lex.getText("CertWizard.status.passwordDialogInfo", new Object[]{this.serverCertAlias}), false, false));
            }
            try (SecretChars serverCertPrivKeyPassword = AccessController.doPrivileged(() -> this.serverCertPkPasswd != null && !this.serverCertPkPasswd.isDefault() ? this.serverCertPkPasswd.getSecretChars() : null);){
                NPKCS10CertificationRequest nPKCS10CertificationRequest = CertificateWizardModel.this.remoteCoreCryptoManager.generateCSR(this.serverCertAlias, serverCertPrivKeyPassword != null ? serverCertPrivKeyPassword.asString(false) : null);
                return nPKCS10CertificationRequest;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to generate CSR", e);
                return null;
            }
        }

        private boolean exportCsr() {
            block15: {
                try {
                    if (this.csr == null) break block15;
                    BFileChooser chooser = BFileChooser.makeSave(null);
                    chooser.setTitle(lex.getText("CertWizard.csr.fileChooserDialog.title"));
                    chooser.setDefaultFileName(this.serverCertAlias + ".csr");
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + this.getCertsDirectoryPath())));
                    chooser.addFilter((IFileFilter)new ExtFileFilter(lex.getText("CertWizard.csr.extensionInfo"), "csr"));
                    BOrd ord = chooser.show();
                    if (ord == null) {
                        return false;
                    }
                    BIFile target = (BIFile)ord.get();
                    try (JcaPEMWriter pem = new JcaPEMWriter((Writer)new OutputStreamWriter(target.getOutputStream()));){
                        pem.writeObject((Object)new JcaPKCS10CertificationRequest(this.csr.getRequest().getEncoded()));
                    }
                    BConstrainedPane pane = new BConstrainedPane((BWidget)new BLabel(lex.getText("CertWizard.csr.generate.complete")));
                    pane.setMinWidth(200.0);
                    BDialog.info((BWidget)this.getWidget(), (String)lex.getText("CertWizard.csr.extension.info"), (Object)pane);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to export CSR", e);
                    return false;
                }
            }
            return true;
        }

        private String getStationName() {
            if (this.stationName != null) {
                return this.stationName;
            }
            NiagaraPlatformDaemon platformDaemon = null;
            try {
                platformDaemon = NiagaraPlatformDaemon.make((BDaemonSession)CertificateWizardModel.this.getDaemonSession(), null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to create NiagaraPlatformDaemon", e);
            }
            Object station = null;
            try {
                BStationSurrogate[] stations = BStationSurrogate.makeAll((BDaemonSession)CertificateWizardModel.this.getDaemonSession());
                ArrayList<String> stationNames = new ArrayList<String>();
                int visibleColumns = 0;
                for (BStationSurrogate stationSurrogate : stations) {
                    String name = stationSurrogate.getStationName();
                    if (visibleColumns < name.length()) {
                        visibleColumns = name.length();
                    }
                    stationNames.add(name);
                }
                BTextDropDown stationList = new BTextDropDown(stationNames, visibleColumns, false);
                stationList.setEnabled(false);
                stationList.setEnabled(true);
                BGridPane gridPane = new BGridPane(1);
                gridPane.add(null, (BValue)stationList);
                int result = BDialog.open((BWidget)this.getWidget(), (String)lex.getText("CertWizard.status.station.select"), (Object)gridPane, (int)3);
                if (result == 1) {
                    this.stationName = stationList.getText();
                    return this.stationName;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        private boolean setStationTlsSettings(boolean skipUpdatingTLSCertificateAlias) {
            if (skipUpdatingTLSCertificateAlias && this.tlsLevel == null) {
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.station.setTlsSettings.unsupportedVersion"));
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.station.setTlsSettings.noChangesRequired"));
                return true;
            }
            try {
                NiagaraPlatformDaemon platformDaemon = NiagaraPlatformDaemon.make((BDaemonSession)CertificateWizardModel.this.getDaemonSession(), null);
                if (platformDaemon.getStationManager().getAllStations().length == 0) {
                    return true;
                }
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.station.setTlsSettings"));
                String name = this.getStationName();
                if (name == null) {
                    return false;
                }
                RemoteStation station = platformDaemon.getStationManager().getStation(name);
                if (this.serverCertAlias != null) {
                    if (!skipUpdatingTLSCertificateAlias) {
                        station.updateStationCertAlias(this.serverCertAlias);
                    } else {
                        this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.station.setTlsSettings.unsupportedVersion"));
                    }
                }
                if (this.tlsLevel != null) {
                    station.updateStationTlsVersion(this.tlsLevel.getTag());
                }
                this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        private boolean setDaemonTlsSettings(boolean skipUpdatingTLSCertificateAlias) {
            if (skipUpdatingTLSCertificateAlias && this.tlsLevel == null) {
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.daemon.setTlsSettings.unsupportedVersion"));
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.daemon.setTlsSettings.noChangesRequired"));
                return true;
            }
            try {
                this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.daemon.setTlsSettings"));
                BRemoteDaemonPlatform remoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)CertificateWizardModel.this.getDaemonSession(), (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
                BPlatformSSLSettings current = remoteDaemonPlatform.getPlatformSSLSettings();
                if (this.serverCertAlias != null) {
                    if (!skipUpdatingTLSCertificateAlias) {
                        current.setKeyAlias(this.serverCertAlias);
                        if (this.serverCertPkPasswd != null) {
                            current.setKeyPassphrase(this.serverCertPkPasswd);
                        }
                    } else {
                        this.appendToStatusText("\n" + lex.getText("CertWizard.status.message.daemon.setTlsSettings.unsupportedVersion"));
                    }
                }
                if (this.tlsLevel != null) {
                    current.setSslAlgType(this.tlsLevel);
                }
                UpdateSSLSettingsMessage message = new UpdateSSLSettingsMessage(current, true, CertificateWizardModel.this.session.generateSharedSecretKey("updateTlsSettings"));
                CertificateWizardModel.this.session.sendMessage((DaemonMessage)message);
                this.appendToStatusText(lex.getText("CertWizard.status.message.complete"));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        private String getCertsDirectoryPath() {
            if (this.certsDirectoryPath == null) {
                File certificateHome = Sys.getNiagaraUserHome();
                if (certificateHome.getPath().contains("n4applet")) {
                    certificateHome = certificateHome.getParentFile().getParentFile();
                }
                if (!(certificateHome = new File(certificateHome, "certManagement")).exists() && !certificateHome.mkdirs()) {
                    throw new BajaRuntimeException("CertsTable failed to create certificate directory");
                }
                this.certsDirectoryPath = certificateHome.toString().replace("\\", "/");
            }
            return this.certsDirectoryPath;
        }

        private void appendToStatusText(String text) {
            if ("".equals(this.statusText.getText()) && text.startsWith("\n")) {
                text = text.substring(1);
            }
            this.statusText.setText(this.statusText.getText() + text);
        }

        protected class CertMonitor
        extends Thread {
            private volatile boolean running;
            ICoreCryptoManager manager;
            BCertsTable.CertGenRequest request;

            CertMonitor() {
                super("CertificateWizardModel:CertMonitorThread");
                this.running = true;
            }

            public void initialize(ICoreCryptoManager manager, BCertsTable.CertGenRequest request) {
                this.manager = manager;
                this.request = request;
            }

            @Override
            public void run() {
                while (this.running) {
                    try {
                        int status = this.manager.getCertGenerationStatus(this.request.getRequestId());
                        if (status == -1) {
                            StatusStep.this.certificateGenerationComplete(false);
                            break;
                        }
                        if (status == 2) {
                            StatusStep.this.certificateGenerationComplete(true);
                            break;
                        }
                    }
                    catch (NotConnectedException nce) {
                        StatusStep.this.certificateGenerationComplete(false);
                        break;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error occurred while checking certificate status", e);
                        StatusStep.this.certificateGenerationComplete(false);
                    }
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Exception exception) {}
                }
            }

            public void terminate() {
                this.running = false;
            }
        }
    }

    private class ChecklistStep
    extends CertWizardStep {
        private final BCheckBox generateServerCertCheckBox;
        private final BCheckBox signServerCertCheckBox;
        private BRadioButton signWithLocalCAButton;
        private BCertificateSelectFE certificateSelectFE;
        private BCheckBox installToTargetCheckBox;
        private BCheckBox exportCaCertCheckBox;
        private BRadioButton exportCsrButton;
        private final BCheckBox setServiceCertCheckBox;
        private final BCheckBox setTlsLevelCheckBox;
        private final BTextDropDown tlsLevel;
        private final StatusStep statusStep;

        ChecklistStep() {
            BIndentPane indentPane = new BIndentPane();
            indentPane.add((BWidget)new BLabel(lex.getText("CertWizard.checklist.directions")));
            this.generateServerCertCheckBox = new BCheckBox(lex.getText("CertWizard.checklist.generateServerCert"));
            this.generateServerCertCheckBox.setSelected(true);
            indentPane.add((BWidget)this.generateServerCertCheckBox);
            this.signServerCertCheckBox = new BCheckBox(lex.getText("CertWizard.checklist.signServerCertificate"));
            this.signServerCertCheckBox.setSelected(true);
            Subscriber.make(event -> {
                if (event.getId() == 0 && event.getSlotName().equals("selected")) {
                    boolean isChecked = this.signServerCertCheckBox.getSelected();
                    boolean isSelected = this.signWithLocalCAButton.getSelected();
                    this.signWithLocalCAButton.setEnabled(isChecked);
                    this.certificateSelectFE.setEnabled(isChecked && isSelected);
                    this.installToTargetCheckBox.setEnabled(isChecked && isSelected);
                    this.exportCaCertCheckBox.setEnabled(isChecked && isSelected);
                    this.exportCsrButton.setEnabled(isChecked);
                }
            }).subscribe((BComponent)this.signServerCertCheckBox);
            indentPane.add((BWidget)this.signServerCertCheckBox);
            ToggleCommandGroup group = new ToggleCommandGroup();
            BGridPane innerPane = new BGridPane(2);
            this.signWithLocalCAButton = new BRadioButton(group, lex.getText("CertWizard.checklist.signWithCA"));
            this.signWithLocalCAButton.setSelected(true);
            Subscriber.make(event -> {
                if (event.getId() == 0 && event.getSlotName().equals("selected")) {
                    boolean isChecked = this.signWithLocalCAButton.getSelected();
                    this.certificateSelectFE.setEnabled(isChecked);
                    this.installToTargetCheckBox.setEnabled(isChecked);
                    this.exportCaCertCheckBox.setEnabled(isChecked);
                }
            }).subscribe((BComponent)this.signWithLocalCAButton);
            innerPane.add(null, (BValue)this.signWithLocalCAButton);
            indentPane.indent(2);
            this.certificateSelectFE = new BCertificateSelectFE(CertificateWizardModel.this.localCoreCryptoManager, BCertificateSelectFE.KeyStoreType.USER_KEYSTORE, KeyPurpose.CA_CERT, BString.make((String)lex.getText("CertAlias.generateNew")));
            this.certificateSelectFE.doLoadValue(null, null);
            this.certificateSelectFE.setEnabled(false);
            this.certificateSelectFE.setEnabled(this.signWithLocalCAButton.getSelected());
            innerPane.add(null, (BValue)this.certificateSelectFE);
            indentPane.add((BWidget)innerPane);
            this.installToTargetCheckBox = new BCheckBox(lex.getText("CertWizard.checklist.installCaToTarget"));
            this.installToTargetCheckBox.setSelected(true);
            indentPane.indent(2);
            indentPane.add((BWidget)this.installToTargetCheckBox);
            this.exportCaCertCheckBox = new BCheckBox(lex.getText("CertWizard.checklist.exportCa"));
            this.exportCaCertCheckBox.setSelected(false);
            indentPane.add((BWidget)this.exportCaCertCheckBox);
            indentPane.unindent(2);
            this.exportCsrButton = new BRadioButton(group, lex.getText("CertWizard.checklist.exportCsr"));
            indentPane.add((BWidget)this.exportCsrButton);
            indentPane.unindent(2);
            this.setServiceCertCheckBox = new BCheckBox(lex.getText("CertWizard.checklist.setServiceCert"));
            this.setServiceCertCheckBox.setSelected(false);
            indentPane.add((BWidget)this.setServiceCertCheckBox);
            BGridPane innerPane2 = new BGridPane(2);
            this.setTlsLevelCheckBox = new BCheckBox(lex.getText("CertWizard.checklist.setTlsLevel"));
            this.setTlsLevelCheckBox.setSelected(false);
            ArrayList tlsLevels = new ArrayList();
            if (CertificateWizardModel.this.isRemoteCoreCryptoManagerVersionGreaterThanOrEqualTo(CryptoSupport.MIN_TLS_1_3_NIAGARA_VERSION)) {
                tlsLevels.add(CryptoSupport.TYPES.get("tlsv1.3"));
            } else if (CertificateWizardModel.this.getRemoteCoreCryptoManagerVersion().equals((Object)Version.ZERO)) {
                log.warning("Failed to determine remote daemon version, using legacy TLS level support");
            }
            tlsLevels.add(CryptoSupport.TYPES.get("tlsv1.2"));
            tlsLevels.add(CryptoSupport.TYPES.get("tlsv1.1"));
            tlsLevels.add(CryptoSupport.TYPES.get("tlsv1"));
            this.tlsLevel = new BTextDropDown(tlsLevels, 7, false);
            Subscriber.make(event -> {
                if (event.getId() == 0 && event.getSlotName().equals("selected")) {
                    boolean isChecked = this.setTlsLevelCheckBox.getSelected();
                    this.tlsLevel.setEnabled(isChecked);
                }
            }).subscribe((BComponent)this.setTlsLevelCheckBox);
            this.tlsLevel.setEnabled(false);
            this.tlsLevel.setEnabled(this.setTlsLevelCheckBox.getSelected());
            innerPane2.add(null, (BValue)this.setTlsLevelCheckBox);
            innerPane2.add(null, (BValue)this.tlsLevel);
            indentPane.add((BWidget)innerPane2);
            this.setContent((BWidget)indentPane);
            this.statusStep = new StatusStep(this);
            this.setNextStep(this.statusStep);
        }

        @Override
        public String getStepName() {
            return "checklistStep";
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        @Override
        public int getMode() {
            return 2;
        }

        @Override
        public boolean exit() {
            return true;
        }

        public boolean isGenerateCertChecked() {
            return this.generateServerCertCheckBox.isSelected();
        }

        public boolean isSignServerCertChecked() {
            return this.signServerCertCheckBox.isSelected();
        }

        public boolean isSignWithLocalCASelected() {
            return this.signWithLocalCAButton.isSelected();
        }

        public BString getAlias() {
            return BString.make((String)this.certificateSelectFE.getText());
        }

        public boolean isInstallToTargetChecked() {
            return this.installToTargetCheckBox.isSelected();
        }

        public boolean isExportCaCertChecked() {
            return this.exportCaCertCheckBox.isSelected();
        }

        public boolean isSetServiceCertChecked() {
            return this.setServiceCertCheckBox.isSelected();
        }

        public boolean isSetTlsLevelChecked() {
            return this.setTlsLevelCheckBox.isSelected();
        }

        public String getTlsLevel() {
            return this.tlsLevel.getText();
        }
    }

    public static abstract class CertWizardStep {
        private final BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private final BEdgePane widget = new BEdgePane((BWidget)new BWizardHeader(CertificateWizardModel.access$000(), CertificateWizardModel.access$100().getText("CertWizard.headerTitle"), CertificateWizardModel.access$100().getText("CertWizard." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        private CertWizardStep priorStep;
        private CertWizardStep nextStep;

        CertWizardStep() {
        }

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget content) {
            this.contentPane.setCenter(content);
        }

        public int getMode() {
            return 0;
        }

        CertWizardStep getPriorStep() {
            return this.priorStep;
        }

        CertWizardStep getNextStep() {
            return this.nextStep;
        }

        void setNextStep(CertWizardStep step) {
            this.nextStep = step;
        }

        public void enter() {
        }

        public boolean exit() {
            return true;
        }

        void setPriorStep(CertWizardStep step) {
            this.priorStep = step;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }

    private static enum ProcessStep {
        GENERATE_SERVER_CERT,
        GENERATE_CA_CERT;

    }
}

