/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.NGeneralName;
import com.tridium.crypto.core.cert.ext.NSubjectAlternativeName;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.json.JSONObject;
import com.tridium.platcrypto.ui.certExt.BICertExtensionParameterPane;
import com.tridium.platcrypto.ui.certExt.BSubjectAltAddPane;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

@NiagaraType
public class BSubjectAltNamePane
extends BScrollPane
implements BICertExtensionParameterPane<NSubjectAlternativeName> {
    @Generated
    public static final Type TYPE = Sys.loadType(BSubjectAltNamePane.class);
    private final AtomicInteger rowCounter = new AtomicInteger();
    private final BGridPane identities = new BGridPane(3);
    private final BButton addButton = new BButton((Command)new AddCommand());
    private static final Lexicon LEX = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String LABEL_KEY = "lbl";
    private static final String TEXT_KEY = "txt";
    private static final String DELETE_KEY = "del";
    private static final String EXT_NAME = LEX.getText("cert.field.subjectAlternativeName");
    private static final String HELP_LEX_KEY = "san";
    private static final String OID = Extension.subjectAlternativeName.getId();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSubjectAltNamePane() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)this.identities);
        BFlowPane addPane = new BFlowPane();
        addPane.setAlign(BHalign.center);
        addPane.add("addBtn", (BValue)this.addButton);
        edge.setBottom((BWidget)addPane);
        this.setContent((BWidget)edge);
    }

    @Override
    public String getExtensionOid() {
        return OID;
    }

    @Override
    public String getExtensionName() {
        return EXT_NAME;
    }

    @Override
    public String getHelpLexiconKey() {
        return HELP_LEX_KEY;
    }

    @Override
    public void loadFromJson(String json, Map<String, Object> properties) throws CertificateParseException, IOException {
        if (json.isEmpty()) {
            this.addIdentityRow((String)BSubjectAltAddPane.TYPES.getByValue((Object)2), "");
        } else {
            NSubjectAlternativeName subjectAlternativeName = (NSubjectAlternativeName)NX509Extension.decodeFromString((String)json);
            Set names = subjectAlternativeName.getNames();
            names.forEach(name -> {
                String value = new JSONObject(name.encodeToString()).getString("value");
                this.addIdentityRow((String)BSubjectAltAddPane.TYPES.getByValue((Object)name.getTagNo()), value);
            });
        }
    }

    public void load(GeneralName[] generalNames) {
        Arrays.stream(generalNames).forEach(name -> this.addIdentityRow((String)BSubjectAltAddPane.TYPES.getByValue((Object)name.getTagNo()), NGeneralName.make((GeneralName)name).getValueAsString()));
    }

    @Override
    public NSubjectAlternativeName toExtension(boolean isCritical) throws IOException {
        List<NGeneralName> values = this.getValues();
        return NSubjectAlternativeName.make((boolean)isCritical, values);
    }

    @Override
    public String toDisplayText(Context cx) {
        List<NGeneralName> values = this.getValues();
        return BSubjectAltNamePane.namesToDisplayText(values);
    }

    public static String namesToDisplayText(List<NGeneralName> values) {
        return values.stream().map(name -> String.format("%s: %s", BSubjectAltAddPane.TYPES.getByValue((Object)name.getTagNo()), name.getValueAsString())).collect(Collectors.joining(", "));
    }

    private List<NGeneralName> getValues() {
        LinkedList<NGeneralName> values = new LinkedList<NGeneralName>();
        for (int i = 0; i < this.rowCounter.get(); ++i) {
            BValue text;
            BValue label = this.identities.get(LABEL_KEY + i);
            if (!(label instanceof BLabel) || !((text = this.identities.get(TEXT_KEY + i)) instanceof BTextField)) continue;
            Integer tagNo = (Integer)BSubjectAltAddPane.TYPES.get((Object)((BLabel)label).getText());
            values.add(NGeneralName.make((GeneralName)new GeneralName(tagNo.intValue(), ((BTextField)text).getText())));
        }
        return values;
    }

    private void addIdentityRow(String typeLabelText, String value) {
        int rowIndex = this.rowCounter.getAndIncrement();
        BLabel typeLabel = new BLabel(typeLabelText);
        BTextField text = new BTextField(value);
        BButton deleteButton = new BButton((Command)new DeleteRowCommand(rowIndex));
        this.identities.add(LABEL_KEY + rowIndex, (BValue)typeLabel);
        this.identities.add(TEXT_KEY + rowIndex, (BValue)text);
        this.identities.add(DELETE_KEY + rowIndex, (BValue)deleteButton);
    }

    class DeleteRowCommand
    extends Command {
        final int rowIndex;

        public DeleteRowCommand(int rowIndex) {
            super((BWidget)BSubjectAltNamePane.this, LEX, "delete");
            this.rowIndex = rowIndex;
        }

        public CommandArtifact doInvoke() throws Exception {
            BSubjectAltNamePane.this.identities.remove(BSubjectAltNamePane.LABEL_KEY + this.rowIndex);
            BSubjectAltNamePane.this.identities.remove(BSubjectAltNamePane.TEXT_KEY + this.rowIndex);
            BSubjectAltNamePane.this.identities.remove(BSubjectAltNamePane.DELETE_KEY + this.rowIndex);
            BSubjectAltNamePane.this.identities.relayout();
            return null;
        }
    }

    class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BSubjectAltNamePane.this, LEX, "addIdentity");
        }

        public CommandArtifact doInvoke() throws Exception {
            String selectedType;
            BSubjectAltAddPane panel = new BSubjectAltAddPane();
            int dialogResult = BDialog.open((BWidget)BSubjectAltNamePane.this, (String)LEX.getText("addIdentity.label"), (Object)((Object)panel), (int)3);
            if (dialogResult == 1 && (selectedType = panel.getSelectedType()) != null) {
                BSubjectAltNamePane.this.addIdentityRow(panel.getSelectedType(), panel.getValue());
            }
            return null;
        }
    }
}

