/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.oracle.BOracleDatabase;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.BasicDataSource;

@NiagaraType
public class BOracleConnectionPool
extends BAbstractConnectionPool {
    @Generated
    public static final Type TYPE = Sys.loadType(BOracleConnectionPool.class);
    private static final String CUSTOM_JDBC_URL = "customJdbcUrl";
    private static final String SSL_VERSION_PROP = "oracle.net.ssl_version";
    private static final String TRUST_STORE_PROP = "javax.net.ssl.trustStore";
    private static final String TRUST_STORE_PASSWD_PROP = "javax.net.ssl.trustStorePassword";
    private static final String SSL_SERVER_DN_MATCH_PROP = "oracle.net.ssl_server_dn_match";
    private final Map<String, String> connectionEncryptionProperties = new ConcurrentHashMap<String, String>(4);
    private static final Map<BSslTlsEnum, String> SSL_TLS_ENUM_OJDBC_STRING_MAP = new HashMap<BSslTlsEnum, String>();
    private BasicDataSource ds;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
            Logger.getLogger("rdbOracle").fine("oracle connection stats:  numActive: " + this.getNumActive() + ",  peakNumActive: " + this.getPeakNumActive() + ",  numIdle: " + this.getNumIdle());
        }
    }

    protected Connection obtainConnection(String userName, String password) throws SQLException {
        String url;
        BOracleDatabase db = (BOracleDatabase)this.getParent();
        Property jdbcProp = db.getProperty(CUSTOM_JDBC_URL);
        String minTlsProtocol = null;
        boolean minTlsProtocolChanged = false;
        if (jdbcProp == null) {
            url = BOracleConnectionPool.makeUrl(db);
            minTlsProtocol = SSL_TLS_ENUM_OJDBC_STRING_MAP.get(db.getTlsMinProtocol());
            if (db.getUseEncryptedConnection() && minTlsProtocol == null) {
                String unsupportedTlsVersionFormatString = "The configured TLS Protocol %s is not supported by the Oracle JDBC Driver.";
                throw new SQLException(String.format(unsupportedTlsVersionFormatString, db.getTlsMinProtocol()));
            }
            minTlsProtocolChanged = !this.connectionEncryptionProperties.getOrDefault(SSL_VERSION_PROP, "").equals(minTlsProtocol);
            this.connectionEncryptionProperties.clear();
            if (db.getUseEncryptedConnection()) {
                this.connectionEncryptionProperties.putAll(BOracleConnectionPool.makeEncryptedConnectionProperties(db));
            }
        } else {
            this.connectionEncryptionProperties.clear();
            url = db.getString(jdbcProp);
            Logger.getLogger("rdb").fine("using custom jdbc connection: " + url);
        }
        if (this.ds == null) {
            Logger.getLogger("rdb").fine("initializing connection pool for " + url);
            this.ds = this.makeDataSource(url, userName, password, db.getUseEncryptedConnection());
        } else if (!this.ds.getUrl().equals(url) || !this.ds.getUsername().equals(userName) || !this.ds.getPassword().equals(password) || minTlsProtocolChanged) {
            Logger.getLogger("rdb").fine("re-initializing connection pool for " + url);
            this.ds.close();
            this.ds = this.makeDataSource(url, userName, password, db.getUseEncryptedConnection());
        }
        if (Nre.bootEnv.isRemote()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws SQLException {
                        Connection connection = null;
                        Locale current = Locale.getDefault();
                        Locale.setDefault(Locale.US);
                        connection = BOracleConnectionPool.this.ds.getConnection();
                        Locale.setDefault(current);
                        return connection;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SQLException)e.getException();
            }
        }
        return this.ds.getConnection();
    }

    private BasicDataSource makeDataSource(String url, String userName, String password, boolean addConnectionEncryptionProperties) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        ds.setUrl(url);
        ds.setUsername(userName);
        ds.setPassword(password);
        if (addConnectionEncryptionProperties) {
            String connectionPropertiesString = this.connectionEncryptionProperties.entrySet().stream().map(entry -> String.join((CharSequence)"=", (CharSequence)entry.getKey(), (CharSequence)entry.getValue())).collect(Collectors.joining(";"));
            ds.setConnectionProperties(connectionPropertiesString);
        }
        ds.setMaxTotal(this.getMaxActive());
        ds.setMaxIdle(this.getMaxIdle());
        ds.setMaxWait(Duration.ofMillis(this.getMaxWait()));
        ds.setAccessToUnderlyingConnectionAllowed(true);
        return ds;
    }

    private static String makeUrl(BOracleDatabase db) {
        String host = db.getHostname();
        int port = db.getPort();
        String protocol = db.getUseEncryptedConnection() ? "tcps" : "tcp";
        String serviceName = db.getServiceName();
        String securityOptions = "";
        if (db.getUseEncryptedConnection() && db.getVerifySubjectInCertificate()) {
            String serverCertificateDN = db.getServerCertificateSubjectIdentifier();
            securityOptions = String.format("(SECURITY=(SSL_SERVER_CERT_DN=\"%s\"))", serverCertificateDN);
        }
        String urlFormatString = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%d))(CONNECT_DATA=(SERVICE_NAME=%s))%s)";
        return String.format(urlFormatString, protocol, host, port, serviceName, securityOptions);
    }

    private static Map<String, String> makeEncryptedConnectionProperties(BOracleDatabase db) {
        HashMap<String, String> encryptedConnectionProperties = new HashMap<String, String>();
        String minTlsProtocol = SSL_TLS_ENUM_OJDBC_STRING_MAP.get(db.getTlsMinProtocol());
        encryptedConnectionProperties.put(SSL_VERSION_PROP, minTlsProtocol);
        if (!db.getServerCertificate().isEmpty()) {
            String trustStorePath = db.getTrustStorePath().toString();
            String trustStorePassword = db.getTrustStorePassword().asString(true);
            encryptedConnectionProperties.put(TRUST_STORE_PROP, trustStorePath);
            encryptedConnectionProperties.put(TRUST_STORE_PASSWD_PROP, trustStorePassword);
        }
        if (db.getVerifySubjectInCertificate()) {
            encryptedConnectionProperties.put(SSL_SERVER_DN_MATCH_PROP, String.valueOf(true));
        }
        return encryptedConnectionProperties;
    }

    static {
        SSL_TLS_ENUM_OJDBC_STRING_MAP.put(BSslTlsEnum.tlsv1, "1.2 or 1.1 or 1.0");
        SSL_TLS_ENUM_OJDBC_STRING_MAP.put(BSslTlsEnum.tlsv1_1, "1.2 or 1.1");
        SSL_TLS_ENUM_OJDBC_STRING_MAP.put(BSslTlsEnum.tlsv1_2, "1.2");
    }
}

