/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.jobs.BMbusTxRxProfile;
import com.tridium.mbus.types.BMbusPrimaryAddressRange;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.ui.BAddressAndBaudRateRange;
import com.tridium.mbus.ui.BDiscoveryCommSpeedSelectPane;
import com.tridium.mbus.ui.BDiscoveryModeSelectPane;
import com.tridium.mbus.ui.BMbusPrimaryAddressRangeFE;
import com.tridium.mbus.ui.BMbusSecondaryAddressFE;
import com.tridium.mbus.ui.BMbusSecondaryKnownAddressFE;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;

class DiscoveryWizardModel
extends WizardModel
implements BDiscoveryModeSelectPane.DiscoveryModeListener,
BDiscoveryCommSpeedSelectPane.DiscoveryCommSpeedListener {
    private int step = 1;
    private static final BImage bannerImg = BImage.make((String)"module://icons/x32/wizard.png");
    private final BWizardHeader banner = new BWizardHeader(bannerImg, "", "");
    private final BBorderPane bannerBorder = new BBorderPane((BWidget)new BNullWidget(), 10.0, 10.0, 10.0, 10.0);
    private final BEdgePane bannerPane = new BEdgePane((BWidget)this.banner, null, null, null, (BWidget)this.bannerBorder);
    private boolean finished = false;
    private static final boolean multipleRecords = false;
    private final BGridPane primaryAddRangePane = new BGridPane();
    private final BMbusPrimaryAddressRange range = new BMbusPrimaryAddressRange();
    private final BMbusPrimaryAddressRangeFE addressStep = new BMbusPrimaryAddressRangeFE();
    private BAddressAndBaudRateRange scanBaudRate;
    private BDiscoveryModeSelectPane modeSelectPane = null;
    private BDiscoveryCommSpeedSelectPane commSpeedSelectPane = null;
    private final BMbusSecondaryAddressFilters filters = new BMbusSecondaryAddressFilters();
    private final BMbusSecondaryAddressFE secondaryAddressInfo = new BMbusSecondaryAddressFE();
    private final BMbusSecondaryKnownAddressFE secondaryDirectAddressInfo = new BMbusSecondaryKnownAddressFE();
    boolean baudRateSelectable = true;

    DiscoveryWizardModel() {
    }

    public String getTitle() {
        return MbusToolkit.getText((String)"DiscoveryWizard.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(300.0, 270.0);
    }

    public void init() {
        this.modeSelectPane = new BDiscoveryModeSelectPane(this);
        this.commSpeedSelectPane = new BDiscoveryCommSpeedSelectPane(this);
        this.scanBaudRate = new BAddressAndBaudRateRange();
        this.addressStep.loadValue((BObject)this.range);
        this.secondaryAddressInfo.loadValue((BObject)this.filters);
        this.secondaryDirectAddressInfo.loadValue((BObject)this.filters);
        this.checkStep();
    }

    public void next() {
        this.step = this.baudRateSelectable ? (this.isSingleDeviceDiscover() && this.step == 2 ? 4 : ++this.step) : (this.step == 1 ? (this.isSingleDeviceDiscover() ? 4 : 3) : ++this.step);
        this.checkStep();
    }

    public void back() {
        this.step = this.baudRateSelectable ? (this.isSingleDeviceDiscover() && this.step == 4 ? 2 : --this.step) : (this.isSingleDeviceDiscover() && this.step == 4 ? 1 : (this.step == 3 ? 1 : --this.step));
        this.checkStep();
    }

    public boolean finish() {
        boolean res;
        block22: {
            res = false;
            if (this.modeSelectPane.isAddressDiscover()) {
                try {
                    this.addressStep.saveValue((BObject)this.range, null);
                    res = true;
                }
                catch (Exception e) {
                    try {
                        BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)e.getMessage(), (Throwable)e);
                        break block22;
                    }
                    catch (Exception e2) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace((String)"Error attempting to show exception dialog", (Exception)e2);
                        }
                        break block22;
                    }
                }
            }
            if (this.modeSelectPane.isSecondaryDiscover()) {
                try {
                    this.secondaryAddressInfo.saveValue((BObject)this.filters, null);
                    res = true;
                }
                catch (Exception e) {
                    try {
                        BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)e.getMessage(), (Throwable)e);
                        break block22;
                    }
                    catch (Exception e3) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace((String)"Error attempting to show exception dialog", (Exception)e);
                        }
                        break block22;
                    }
                }
            }
            if (this.modeSelectPane.isSecondaryAddressSetupDiscover()) {
                try {
                    this.secondaryDirectAddressInfo.setModified();
                    this.secondaryDirectAddressInfo.saveValue((BObject)this.filters, null);
                    res = true;
                }
                catch (Exception e) {
                    try {
                        BDialog.error((BWidget)this.getWizard(), (String)"Error", (Object)e.getMessage(), (Throwable)e);
                        break block22;
                    }
                    catch (Exception e3) {
                        if (MbusToolkit.isTraceOn()) {
                            MbusToolkit.trace((String)"Error attempting to show exception dialog", (Exception)e);
                        }
                        break block22;
                    }
                }
            }
            if (this.modeSelectPane.isSingleDeviceDiscover()) {
                if (BDialog.open((BWidget)this.getWizard(), (String)MbusToolkit.getText((String)"DiscoveryWizard.discovery"), (Object)MbusToolkit.getText((String)"DiscoveryWizard.singleDisconnection"), (int)12) == 4) {
                    res = true;
                }
            } else if (this.modeSelectPane.isScanDeviceDatabaseDiscover() || this.modeSelectPane.isSecondaryDiscover()) {
                res = true;
            }
        }
        this.finished = res;
        return res;
    }

    private void checkStep() {
        switch (this.step) {
            case 1: {
                int flags = this.modeSelectPane.isScanDeviceDatabaseDiscover() ? 4 : 2;
                this.setBannerWidget((BWidget)this.modeSelectPane, MbusToolkit.getText((String)"DiscoveryWizard.discoveryMode"), MbusToolkit.getText((String)"DiscoveryWizard.discoveryModeSelect"), flags);
                break;
            }
            case 2: {
                int completeFlags = this.modeSelectPane.isSingleDeviceDiscover() ? 6 : 2;
                this.setBannerWidget((BWidget)this.scanBaudRate, MbusToolkit.getText((String)"DiscoveryWizard.baudRateTitle"), MbusToolkit.getText((String)"DiscoveryWizard.baudRateSelect"), 1 | completeFlags);
                break;
            }
            case 3: {
                if (this.modeSelectPane.isSecondaryDiscover()) {
                    this.setBannerWidget((BWidget)this.secondaryAddressInfo, MbusToolkit.getText((String)"DiscoveryWizard.addressFiltersTitle"), MbusToolkit.getText((String)"DiscoveryWizard.AddressFilterRequest"), 7);
                    break;
                }
                if (this.modeSelectPane.isSecondaryAddressSetupDiscover()) {
                    this.setBannerWidget((BWidget)this.secondaryDirectAddressInfo, MbusToolkit.getText((String)"DiscoveryWizard.secondaryAddressTitle"), MbusToolkit.getText((String)"DiscoveryWizard.SecondaryAddressFilterRequest"), 7);
                    break;
                }
                this.setBannerWidget((BWidget)this.addressStep, MbusToolkit.getText((String)"DiscoveryWizard.addressRange"), MbusToolkit.getText((String)"DiscoveryWizard.deviceAddressRange"), 7);
                break;
            }
            case 4: {
                this.setBannerWidget((BWidget)this.commSpeedSelectPane, MbusToolkit.getText((String)"DiscoveryWizard.commSpeedTitle"), MbusToolkit.getText((String)"DiscoveryWizard.commSpeedSetup"), 5);
            }
        }
    }

    private void setBannerWidget(BWidget w, String title, String description, int flags) {
        this.bannerBorder.setContent(w);
        this.banner.setTitle(title);
        this.banner.setDescription(description);
        this.update((BWidget)this.bannerPane, flags);
    }

    @Override
    public void modeChanged() {
        this.checkStep();
    }

    @Override
    public void speedChanged() {
        this.checkStep();
    }

    boolean isSingleDeviceDiscover() {
        return this.modeSelectPane.isSingleDeviceDiscover();
    }

    boolean isScanDeviceDatabaseDiscover() {
        return this.modeSelectPane.isScanDeviceDatabaseDiscover();
    }

    boolean isAddressDiscover() {
        return this.modeSelectPane.isAddressDiscover();
    }

    boolean isFinished() {
        return this.finished;
    }

    BMbusPrimaryAddressRange getRange() {
        return this.range;
    }

    BVector getSelectedBaudRatesVector() {
        return this.scanBaudRate.getSelectedBaudRates();
    }

    public BMbusTxRxProfile getTxRxProfile() {
        return this.commSpeedSelectPane.getTxRxProfile();
    }

    boolean getMultipleRecords() {
        return false;
    }

    boolean isSecondaryDiscover() {
        return this.modeSelectPane.isSecondaryDiscover();
    }

    boolean isSpecificSecondaryAddressDiscover() {
        return this.modeSelectPane.isSecondaryAddressSetupDiscover();
    }

    BMbusSecondaryAddressFilters getFilters() {
        return this.filters;
    }

    public void setBaudSelectable(boolean newBaudRateSelectable) {
        this.baudRateSelectable = newBaudRateSelectable;
    }
}

