/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth.ui;

import com.tridium.gauth.GoogleAuthenticator;
import com.tridium.gx.GxEnv;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.svg.batik.BSvgDecoder;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.propsheet.BPropertyEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BGoogleSecretKeyFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BGoogleSecretKeyFE.class);
    static BImage newIcon = BImage.make((String)"module://icons/x16/add.png");
    static BImage resetIcon = BImage.make((String)"module://icons/x16/refresh.png");
    private static final Lexicon lex = Lexicon.make((String)"gauth");
    private static final Logger log = Logger.getLogger("gauth");
    private final BButton generateButton = new BButton((Command)new GenerateCmd());
    private String userName;
    private String station;
    BPassword value;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BGoogleSecretKeyFE() {
        this.generateButton.setButtonStyle(BButtonStyle.toolBar);
        this.setContent((BWidget)this.generateButton);
    }

    protected void doSetReadonly(boolean readonly) {
        this.generateButton.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.value = (BPassword)value;
        this.generateButton.setImage(this.value.isDefault() ? newIcon : resetIcon);
        this.userName = this.getUserName();
        this.station = this.getStationName();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return this.value;
    }

    private String getUserName() {
        try {
            for (BComponent parent = (BComponent)this.getParent(); parent != null; parent = (BComponent)parent.getParent()) {
                BObject obj = null;
                if (parent instanceof BPropertyEntry) {
                    obj = ((BPropertyEntry)parent).getTarget();
                } else if (parent instanceof BWbEditor) {
                    obj = ((BWbEditor)parent).getCurrentValue();
                }
                if (!(obj instanceof BComplex)) continue;
                while (obj != null) {
                    if (obj instanceof BUser) {
                        return ((BUser)obj).getUsername();
                    }
                    obj = ((BComplex)obj).getParent();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to get user name", e);
        }
        return "unknown";
    }

    private String getStationName() {
        try {
            for (BComponent parent = (BComponent)this.getParent(); parent != null; parent = (BComponent)parent.getParent()) {
                BObject obj = null;
                if (parent instanceof BPropertyEntry) {
                    obj = ((BPropertyEntry)parent).getTarget();
                } else if (parent instanceof BWbEditor) {
                    obj = ((BWbEditor)parent).getCurrentValue();
                }
                if (!(obj instanceof BComponent)) continue;
                for (parent = (BComponent)obj; parent != null; parent = (BComponent)parent.getParent()) {
                    if (!(parent instanceof BStation)) continue;
                    return ((BStation)parent).getStationName();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to get station name", e);
        }
        return "unknown";
    }

    private String promptToken(boolean failed) {
        BGridPane pane = new BGridPane(1);
        if (failed) {
            BLabel error = new BLabel(lex.getText("auth.incorrectToken"));
            error.setForeground(BBrush.makeSolid((BColor)BColor.red));
            pane.add("null", (BValue)error);
        }
        BLabel instructions = new BLabel(lex.getText("auth.confirmToken"));
        BTextField field = new BTextField();
        pane.add(null, (BValue)instructions);
        pane.add(null, (BValue)field);
        int result = BDialog.open((BWidget)this, (String)lex.getText("auth.confirmToken.title"), (Object)pane, (int)3);
        if (result == 2) {
            return null;
        }
        return field.getText();
    }

    private static boolean checkToken(String token, GoogleAuthenticator gauth) {
        try {
            return gauth.checkToken(Long.parseLong(token));
        }
        catch (Exception e) {
            return false;
        }
    }

    private void showQrCode(String secretKey) {
        try {
            GoogleAuthenticator gauth = new GoogleAuthenticator(secretKey);
            String svg = gauth.getQRBarcodeSVG(this.userName, this.station);
            BSvgDecoder svgDecoder = new BSvgDecoder();
            BOrd ord = BOrd.make((String)"");
            svgDecoder.decode(ord, svg.getBytes(), new BTransform.Scale(1.0, 1.0));
            BImage barcodeImage = ((AwtEnv)GxEnv.get()).makeImage(svgDecoder.getImage(), true);
            BLabel barcodeLabel = new BLabel(barcodeImage);
            barcodeLabel.setBackground(BBrush.make((String)"white"));
            BLabel instructionsLabel = new BLabel(lex.getText("auth.qrInstructions"));
            BLabel idLabel = new BLabel(secretKey + " - " + this.userName + " @ " + this.station);
            StyleUtils.addStyleClass((IStylable)idLabel, (String)"strong");
            BGridPane pane = new BGridPane(1);
            pane.setRowGap(4.0);
            pane.setHalign(BHalign.center);
            pane.setColumnAlign(BHalign.center);
            pane.add(null, (BValue)instructionsLabel);
            pane.add(null, (BValue)barcodeLabel);
            pane.add(null, (BValue)idLabel);
            BOptionDialog dialog = new BOptionDialog((BWidget)this, lex.getText("auth.qrInstructions.title"), (BWidget)pane, 1, null, null);
            dialog.setBoundsCenteredOnOwner();
            dialog.setModal(true);
            dialog.setResizable(false);
            dialog.open();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to render the Google Authenticator Code.", e);
            BDialog.error((BWidget)this, (String)lex.getText("auth.qrInstructions.title"), (Object)lex.getText("auth.qrInstructions.error"), (Throwable)e);
        }
    }

    class GenerateCmd
    extends Command {
        public GenerateCmd() {
            super((BWidget)BGoogleSecretKeyFE.this, null, null, null, null);
        }

        public CommandArtifact doInvoke() {
            String token;
            int confirmed;
            if (!BGoogleSecretKeyFE.this.value.isDefault() && (confirmed = BDialog.confirm((BWidget)BGoogleSecretKeyFE.this, (String)lex.getText("auth.confirmRegenerate.title"), (Object)lex.getText("auth.confirmRegenerate"))) != 4) {
                return null;
            }
            String secretKey = GoogleAuthenticator.createSecret();
            BGoogleSecretKeyFE.this.showQrCode(secretKey);
            GoogleAuthenticator gauth = new GoogleAuthenticator(secretKey);
            boolean failed = false;
            do {
                token = BGoogleSecretKeyFE.this.promptToken(failed);
                failed = true;
                if (token != null) continue;
                return null;
            } while (!BGoogleSecretKeyFE.checkToken(token, gauth));
            BGoogleSecretKeyFE.this.value = BPassword.make((String)secretKey);
            BGoogleSecretKeyFE.this.setModified();
            BGoogleSecretKeyFE.this.generateButton.setImage(resetIcon);
            return null;
        }
    }
}

