/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.px.editor.make;

import com.tridium.px.editor.make.BMwBoundLabel;
import com.tridium.px.editor.make.WidgetCopier;
import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.binding.ui.BTransformLabelBinding;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.px.editor.make.BLabelParamsPane;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:TransformGraph"})})
public class BMwTransformBoundLabel
extends BMwBoundLabel {
    @Generated
    public static final Type TYPE = Sys.loadType(BMwTransformBoundLabel.class);
    private static final Lexicon lex = Lexicon.make(BMwTransformBoundLabel.class);
    private static final String LBL_CELL_ROW = lex.getText("mw.boundlabel.cellrow");
    private static final String LBL_CELL_COL = lex.getText("mw.boundlabel.cellcol");
    private static final Logger log = Logger.getLogger("seriesTransform.MakeWidget");
    private final BTextField cellRow = new BTextField("0", 5);
    private final BTextField cellCol = new BTextField("0", 5);
    private final BTabbedPane tabPane = new BTabbedPane();
    private BLabelParamsPane paramsTab;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTypeSpec getSuperceedingType() {
        return BMwBoundLabel.TYPE.getTypeSpec();
    }

    public void load() {
        BObject[] drawingObjects;
        BComponent[] childComponents;
        super.load();
        this.setBindingType(BTransformLabelBinding.TYPE.getTypeSpec().toString());
        BGridPane cellEd = new BGridPane(2);
        cellEd.add(null, (BValue)new BLabel(LBL_CELL_ROW));
        cellEd.add(null, (BValue)this.cellRow);
        cellEd.add(null, (BValue)new BLabel(LBL_CELL_COL));
        cellEd.add(null, (BValue)this.cellCol);
        for (BComponent comp : childComponents = this.content.getChildComponents()) {
            this.content.remove((BComplex)comp);
        }
        BGridPane container = new BGridPane(2);
        container.add(null, (BValue)childComponents[0]);
        container.add(null, (BValue)cellEd);
        container.setColumnGap(15.0);
        container.setRowAlign(BValign.top);
        container.setColumnAlign(BHalign.left);
        this.content.add(null, (BValue)container);
        this.content.add(null, (BValue)childComponents[1]);
        for (BObject o : drawingObjects = this.mw.getDrawingObjects()) {
            if (!(o instanceof BTransformGraph)) continue;
            BTransformGraph graph = (BTransformGraph)o;
            this.paramsTab = new BLabelParamsPane((BWidget)this.mw.getEditor(), graph);
            this.tabPane.addPane((BLabelPane)this.paramsTab);
        }
        this.tabPane.setShowSingleTab(false);
        BConstrainedPane cp = new BConstrainedPane((BWidget)this.tabPane);
        cp.setMinHeight(150.0);
        cp.setMinWidth(450.0);
        this.content.add(null, (BValue)cp);
    }

    public BWidget[] makePxWidgets(WidgetCopier wc) {
        BWidget[] createdWidgets;
        for (BWidget widget : createdWidgets = super.makePxWidgets(wc)) {
            BBinding binding;
            BBinding[] bindings = widget.getBindings();
            if (bindings.length <= 0 || !((binding = bindings[0]) instanceof BTransformLabelBinding)) continue;
            BTransformLabelBinding tlb = (BTransformLabelBinding)binding;
            try {
                BTransformQuery transformQuery = this.paramsTab.getTransformQuery();
                tlb.setQuery(transformQuery);
                BOrd targetOrd = binding.getOrd();
                String target = "cell:" + this.cellCol.getText() + "," + this.cellRow.getText();
                targetOrd = BOrd.make((BOrd)targetOrd, (String)target);
                binding.setOrd(targetOrd);
            }
            catch (CannotSaveException cse) {
                log.severe("Failed to save transform label binding parameters for graph: " + binding.getOrd().toString());
            }
            catch (Exception e) {
                log.severe("Failed to create transform label bindings for PX Make Widget editor: " + e.getMessage());
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return createdWidgets;
    }
}

