/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.rollup.ui;

import com.tridium.seriestransform.functions.BFunctionMap;
import com.tridium.seriestransform.functions.ui.BFunctionMapBuilder;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.rollup.BRollupInterval;
import com.tridium.seriestransform.rollup.BRollupNode;
import com.tridium.seriestransform.rollup.ui.BRollupIntervalFE;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.popup.BIPopupEditor;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:RollupNode"})})
public class BRollupPE
extends BWbEditor
implements BIPopupEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BRollupPE.class);
    private static final Lexicon lex = Lexicon.make(BRollupPE.class);
    protected BRollupIntervalFE intervalFE = new BRollupIntervalFE();
    private BFunctionMapBuilder fdb;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbEditor getEditor() {
        return this;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BRollupNode rollup = (BRollupNode)value;
        BFunctionMap functionMap = rollup.getFunctionMap();
        functionMap.lease();
        this.fdb = new BFunctionMapBuilder(functionMap);
        this.linkTo((BComponent)this.fdb, (Slot)BConfigEditor.setModified, (Slot)setModified);
        rollup.lease(3);
        BRollupInterval interval = rollup.getInterval();
        this.intervalFE.loadValue((BObject)interval);
        this.linkTo((BComponent)this.intervalFE, (Slot)setModified, (Slot)setModified);
        BGridPane intervalDisplay = new BGridPane(2);
        intervalDisplay.add(null, (BValue)new BLabel(lex.getText("rollupIPE.intervalFE")));
        intervalDisplay.add(null, (BValue)this.intervalFE);
        BEdgePane display = new BEdgePane();
        display.setCenter((BWidget)this.fdb);
        display.setBottom((BWidget)new BBorderPane((BWidget)intervalDisplay, BInsets.make((double)5.0, (double)0.0, (double)3.0, (double)0.0)));
        this.setContent((BWidget)display);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BRollupNode rollup = (BRollupNode)value;
        rollup.lease(3);
        BFunctionMap map = this.fdb.saveMappings();
        rollup.setFunctionMap(map);
        BRollupInterval saveValue = (BRollupInterval)this.intervalFE.saveValue(cx);
        rollup.setInterval(saveValue);
        return rollup;
    }

    protected void doSetReadonly(boolean readonly) {
        this.fdb.doSetReadonly(readonly);
        this.intervalFE.setEnabled(!readonly);
    }
}

