/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.scale.ui;

import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.scale.BScaleFactor;
import com.tridium.seriestransform.scale.BScaleFactors;
import com.tridium.seriestransform.scale.BScaleNode;
import com.tridium.seriestransform.scale.ui.BScaleFactorConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComponent;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BScaleFactorsEditor
extends BConfigEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BScaleFactorsEditor.class);
    private static final Lexicon lex = Lexicon.make(BScaleFactorsEditor.class);
    private static final String TITLE = lex.getText("scaleMapEditor.title");
    private static final String DISPLAY_TITLE = lex.getText("outputSchemaEditor.schema");
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private final List<BScaleFactorConfiguration> rows = new ArrayList<BScaleFactorConfiguration>();
    private BGraphNode scaleNode;
    private BScaleFactors factors;
    private final Set<String> existingFactorFields = new HashSet<String>();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BScaleFactors open(BWidget owner, BScaleFactors collection) throws Exception {
        if (null == collection) {
            throw new Exception("Cannot edit NULL function map.");
        }
        BScaleFactorsEditor fre = new BScaleFactorsEditor(collection);
        int r = BRoundedDialog.open((BWidget)owner, (String)TITLE, (Object)((Object)fre), (int)3);
        if (r != 1) {
            return null;
        }
        collection = fre.getFactors();
        return collection;
    }

    public BScaleFactorsEditor() {
    }

    public BScaleFactorsEditor(BScaleFactors collection) {
        this.factors = collection;
        this.factors.lease();
        this.scaleNode = (BGraphNode)this.factors.getParent();
        BWidget display = this.buildTableDisplay(DISPLAY_TITLE, null);
        this.setCenter(display);
        this.loadScaleFactors();
    }

    private void loadScaleFactors() {
        BScaleFactor[] children;
        this.factors.lease();
        for (BScaleFactor factor : children = (BScaleFactor[])this.factors.getChildren(BScaleFactor.class)) {
            factor.lease();
            BTypeSpec fieldType = factor.getInputFieldType();
            boolean enabled = fieldType.getTypeInfo().is(BNumber.TYPE);
            this.addScaleFactorConfiguration(factor, enabled);
        }
        this.scaleNode.lease();
        BSeriesSchema schema = this.scaleNode.getSchema();
        Set inputFields = ((BScaleNode)this.scaleNode).getScaleInputFields();
        inputFields.stream().filter(fieldName -> !this.existingFactorFields.contains(fieldName)).forEach(fieldName -> {
            BTypeSpec fieldType = schema.getFieldType(fieldName);
            boolean enabled = fieldType.getTypeInfo().is(BNumber.TYPE);
            BScaleFactor sf = new BScaleFactor();
            sf.setInputFieldName(fieldName);
            sf.setInputFieldType(fieldType);
            if (enabled) {
                sf.setFactor(1.0);
            } else {
                sf.setFactor(Double.NaN);
            }
            this.addScaleFactorConfiguration(sf, enabled);
        });
    }

    private void addScaleFactorConfiguration(BScaleFactor factor, boolean enabled) {
        String fieldName = factor.getInputFieldName();
        if (!this.existingFactorFields.contains(fieldName)) {
            BScaleFactorConfiguration config = new BScaleFactorConfiguration(factor);
            config.setEnabled(enabled);
            this.rows.add(config);
            this.existingFactorFields.add(fieldName);
            this.linkTo((BComponent)config, (Slot)BConfigItem.modified, (Slot)setModified);
            this.addConfig(config, EMPTY_COMMANDS);
        }
    }

    public BScaleFactors getFactors() {
        this.factors.removeAll();
        for (BScaleFactorConfiguration config : this.rows) {
            BScaleFactor scaleFactor = config.getScaleFactor();
            Double check = scaleFactor.getFactor();
            if (check.isNaN()) continue;
            this.factors.add(null, (BValue)scaleFactor);
        }
        return this.factors;
    }
}

