/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.gx.BImage;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class ConfirmDialog
extends Dialog {
    protected String msg;
    protected String openMessage;

    public ConfirmDialog(String title, Command handler) {
        super(title, handler);
    }

    public ConfirmDialog(String title, Command handler, String msg) {
        this(title, handler);
        this.msg = msg;
    }

    public String getMessage(HxOp op) {
        if (this.openMessage != null) {
            return this.openMessage;
        }
        if (this.msg != null) {
            return this.msg;
        }
        return Lexicon.make(((Object)((Object)this)).getClass()).getText("areYouSure");
    }

    public BIcon getQuestionIcon(HxOp op) {
        return BIcon.make((String)Lexicon.make(((Object)((Object)this)).getClass()).get("question.icon"));
    }

    public void open(String msg, HxOp op) throws Exception {
        this.openMessage = msg;
        this.open(op);
        this.openMessage = null;
    }

    protected void writeContent(HxOp op) throws Exception {
        ConfirmDialog.writeWarning(BImage.make((BIcon)this.getQuestionIcon(op)), this.getMessage(op), op);
    }

    public static void writeWarning(String message, HxOp op) throws Exception {
        Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(ConfirmDialog.class).getModuleName());
        ConfirmDialog.writeWarning(BImage.make((BIcon)BIcon.make((String)lex.get("question.icon"))), message, op);
    }

    public static void writeWarning(BImage image, String message, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table><tr><td>");
        HxUtil.makeImageJS((BImage)image, null, null, null, (HxOp)op);
        out.w((Object)"<td> ");
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        String[] split = TextUtil.split((String)message, (char)'\n');
        for (int i = 0; i < split.length; ++i) {
            split[i] = HxTabUtil.safe(split[i]);
        }
        message = TextUtil.join((String[])split, (char)'\n');
        message = TextUtil.replace((String)message, (String)"\n", (String)"<br/>");
        out.w((Object)" <b>").w((Object)message).w((Object)"</b>");
        out.w((Object)"</td></tr></table>");
    }
}

