/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

public abstract class DialogWizardCommand
extends SmartCommand {
    protected Step[] steps = this.makeSteps();

    public DialogWizardCommand(BHxView view) {
        super(view);
    }

    @Deprecated
    public DialogWizardCommand(BHxView view, Lexicon lex) {
        super(view, lex);
    }

    public DialogWizardCommand(BHxView view, LexiconModule lexModule) {
        super(view, lexModule);
    }

    public abstract Step[] makeSteps();

    public abstract String getFirstStepName(HxOp var1);

    public final Step[] getStepNames() {
        return this.steps;
    }

    public final Step getStep(String name, HxOp op) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.steps.length; ++i) {
            if (!name.equals(this.steps[i].getName(op))) continue;
            return this.steps[i];
        }
        throw new IllegalStateException("Step not Found:" + name);
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        for (int i = 0; i < this.steps.length; ++i) {
            if (!this.steps[i].process(op)) continue;
            return true;
        }
        return false;
    }

    public void handle(HxOp op) throws Exception {
        String currentStepForm = DialogWizardCommand.getCurrentStep(op);
        String nextStepForm = DialogWizardCommand.getNextStep(op);
        this.handle(currentStepForm, nextStepForm, op);
    }

    public void handle(String currentStepForm, String nextStepForm, HxOp op) throws Exception {
        Step step;
        if (currentStepForm == null) {
            nextStepForm = this.getFirstStepName(op);
        } else {
            step = this.getStep(currentStepForm, op);
            String result = step.handle(op);
            if (result != null) {
                nextStepForm = result;
            }
        }
        if (nextStepForm != null) {
            step = this.getStep(nextStepForm, op);
            if (step.requiresOpen(op)) {
                step.open(op);
            } else {
                String newNextStep = step.handle(op);
                if (newNextStep != null) {
                    this.handle(newNextStep, null, op);
                }
            }
        }
    }

    public static void writeChoices(Object[] choices, String comment, boolean multiSelect, String formName, HxOp op) throws Exception {
        DialogWizardCommand.writeChoices(choices, comment, multiSelect, formName, null, op);
    }

    public static void writeChoices(Object[] choices, String comment, boolean multiSelect, String formName, ChoiceRenderer renderer, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table>");
        if (comment != null) {
            out.w((Object)"<tr><td colspan='2'>");
            out.w((Object)"<b>").safe((Object)comment).w((Object)"</b>");
            out.w((Object)"</td></tr>");
        }
        boolean first = !multiSelect;
        for (int i = 0; i < choices.length; ++i) {
            String value = "";
            String displayName = "";
            BImage image = null;
            if (renderer != null) {
                value = renderer.getValue(choices[i], op);
                displayName = renderer.getDisplayName(choices[i], op);
                image = renderer.getIcon(choices[i], op);
            } else if (choices[i] instanceof Step) {
                value = ((Step)((Object)choices[i])).getName(op);
                displayName = ((Step)((Object)choices[i])).getDisplayName(op);
                image = ((Step)((Object)choices[i])).getIcon(op);
            } else if (choices[i] instanceof BComplex) {
                value = ((BComplex)choices[i]).getName();
                displayName = ((BComplex)choices[i]).getDisplayName((Context)op);
            } else if (choices[i] instanceof Type) {
                value = ((Type)choices[i]).toString();
                displayName = ((Type)choices[i]).getDisplayName((Context)op);
            }
            out.w((Object)"<tr><td>");
            if (multiSelect) {
                out.w((Object)"<input type='checkbox' name='").w((Object)op.scope(formName + "-" + value)).w((Object)"'");
            } else {
                out.w((Object)"<input type='radio' name='").w((Object)op.scope(formName)).w((Object)"' value='").w((Object)value).w((Object)"'");
            }
            if (first) {
                out.w((Object)" checked");
                first = false;
            }
            out.w((Object)"/>");
            if (image != null) {
                HxUtil.makeImageJS((BImage)image, null, null, null, (HxOp)op);
                out.w((Object)"&nbsp;");
            }
            out.safe((Object)displayName);
            out.w((Object)"</td></tr>");
        }
        out.w((Object)"</table>");
    }

    public static String getCurrentStep(HxOp op) {
        return op.getFormValue("step");
    }

    public static String getNextStep(HxOp op) {
        return op.getFormValue("nextStep");
    }

    public static void writeStep(String stepName, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxSmartTableView.writeFormValue("step", stepName, op);
    }

    public static interface ChoiceRenderer {
        public String getValue(Object var1, HxOp var2);

        public String getDisplayName(Object var1, HxOp var2);

        public BImage getIcon(Object var1, HxOp var2);
    }

    public abstract class Step
    extends DynamicDialog {
        public Step(String name, Command handler) {
            super(name, handler);
        }

        public String getName(HxOp op) {
            return super.getTitle(op);
        }

        public boolean requiresOpen(HxOp op) throws Exception {
            return true;
        }

        public String handle(HxOp op) throws Exception {
            return null;
        }

        public void write(HxOp op) throws Exception {
            DialogWizardCommand.writeStep(this.getName(op), op);
            super.write(op);
        }

        public String getLexName(HxOp op) {
            return this.getName(op);
        }

        protected String getTitle(HxOp op) {
            String title = DialogWizardCommand.this.lexModule.get(this.getLexName(op) + ".title", (Context)op);
            if (title != null) {
                return title;
            }
            return this.getDisplayName(op);
        }

        public String getDisplayName(HxOp op) {
            return DialogWizardCommand.this.lexModule.getText(this.getLexName(op) + ".label", (Context)op);
        }

        public BImage getIcon(HxOp op) {
            return BImage.make((String)DialogWizardCommand.this.lexModule.getText(this.getLexName(op) + ".icon", (Context)op));
        }
    }
}

