/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import javax.baja.hx.HxOp;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.options.OptionsManager;

public class HxOptionsManager
implements OptionsManager {
    private HxOp op;
    private BObject base;

    public HxOptionsManager(HxOp op) {
        this(op.get(), op);
    }

    public HxOptionsManager(BObject base, HxOp op) {
        this.base = base;
        this.op = op;
    }

    public BOptions load(TypeInfo typeInfo) {
        return this.load(typeInfo.getTypeSpec().getResolvedType());
    }

    public BOptions load(Type type) {
        return this.load(type.toString(), type);
    }

    public BOptions load(Type type, boolean useDefaultOptions) {
        return this.load(type.toString(), type, useDefaultOptions);
    }

    public BOptions load(String key, Type type) {
        return this.load(key, type, true);
    }

    public BOptions load(String key, Type type, boolean useDefaultOptions) {
        BOptions mountedOptions = this.getMountedOptions(type);
        if (mountedOptions != null) {
            try {
                mountedOptions.loaded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mountedOptions;
        }
        BOptions sessionOptions = (BOptions)this.op.getRequest().getSession().getAttribute(HxOptionsManager.scope(type));
        if (sessionOptions == null && useDefaultOptions) {
            sessionOptions = (BOptions)this.op.getRequest().getSession().getAttribute(HxOptionsManager.scopeDefault(type));
        }
        if (sessionOptions != null) {
            try {
                sessionOptions.loaded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sessionOptions;
        }
        BOptions options = (BOptions)type.getInstance();
        try {
            options.loaded();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return options;
    }

    public void save(BOptions options) {
        if (this.getMountedOptions(options.getType()) == null) {
            this.op.getRequest().getSession().setAttribute(HxOptionsManager.scope(options.getType()), (Object)options);
        } else {
            this.saveMounted(options);
        }
    }

    public void saveMounted(BOptions options) {
        BOptions mountedOptions = this.getMountedOptions((options = (BOptions)options.newCopy()).getType());
        if (mountedOptions != null) {
            this.base.asComponent().set(mountedOptions.getPropertyInParent(), (BValue)options);
        } else {
            this.base.asComponent().add(null, (BValue)options);
        }
    }

    public BOptions getMountedOptions(Type type) {
        BOptions[] mountedOptions;
        if (this.base instanceof BComponent && (mountedOptions = (BOptions[])this.base.asComponent().getChildren(type.getTypeClass())).length > 0) {
            return mountedOptions[mountedOptions.length - 1];
        }
        return null;
    }

    public void saveDefault(BOptions options) {
        this.op.getRequest().getSession().setAttribute(HxOptionsManager.scopeDefault(options.getType()), (Object)options);
    }

    public static String scope(Type type) {
        return type.toString() + "-options";
    }

    static String scopeDefault(Type type) {
        return type.toString() + "-defaultOptions";
    }

    public void saveAll() {
        throw new IllegalStateException("No saveAll");
    }
}

