/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.box.BBoxService;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import java.util.logging.Level;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.Context;

public class HxSaveCommand
extends SmartCommand {
    public HxSaveCommand(BHxView view) {
        super(view, smartTableHxLexModule);
    }

    @Override
    public String getName(HxOp op) {
        return "save";
    }

    @Override
    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public void handle(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"hx.save();");
    }

    public static class HxPreSaveCommand
    extends SmartCommand {
        public HxPreSaveCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "preSave";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public void addOnload(HxOp op) throws Exception {
            String quote = HxUtil.getInnerQuote((HxOp)op);
            op.addOnload("hx.preSaveEvent(" + quote + op.getPath() + quote + ", " + quote + this.getId() + quote + ");");
        }

        public void handle(HxOp op) throws Exception {
            try {
                this.getView().save(op);
            }
            catch (Exception e) {
                BHxView.log.log(Level.SEVERE, "Unable to presave request", e);
                JSONWriter out = QuickJSONWriter.make((Appendable)op.getHtmlWriter());
                BBoxService.encodeException((JSONWriter)out, (Throwable)e, (Context)op);
            }
        }
    }
}

