/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BPdfGridPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.export.BExportData;
import com.tridium.smartTableHx.export.BPdfStyle;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;

@NiagaraType
public class BSmartTableToPdf
extends BPdfExporter {
    @Generated
    public static final Type TYPE = Sys.loadType(BSmartTableToPdf.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        BExportData c = (BExportData)op.get();
        BPdfStyle styles = c.getResolvedStyle();
        int height = (int)styles.getPageHeight() * 72;
        int width = (int)styles.getPageWidth() * 72;
        if (c.getLandscape()) {
            int swap = height;
            height = width;
            width = swap;
        }
        PdfDocument doc = new PdfDocument(op.getOutputStream(), width, height);
        BTable table = new BTable((TableModel)new Model(c, (Context)op));
        BLabel name = new BLabel(c.getTableTitleDisplay());
        name.setHalign(BHalign.left);
        name.setFont(styles.getTitle().getFont());
        name.setForeground(styles.getTitle().getForegroundColor().toBrush());
        name.setBackground(styles.getTitle().getBackgroundColor().toBrush());
        BPdfFlowPane flow = new BPdfFlowPane();
        BPdfGridPane grid = new BPdfGridPane();
        grid.setColumnCount(1);
        grid.setHalign(BHalign.make((int)0));
        grid.add(null, (BValue)new BLabel(styles.getImage()));
        BLabel clock = new BLabel("(" + Clock.time().toString((Context)op) + ")", styles.getClock().getFont());
        clock.setForeground(styles.getClock().getForegroundColor().toBrush());
        clock.setBackground(styles.getClock().getBackgroundColor().toBrush());
        grid.add(null, (BValue)clock);
        flow.add(null, (BValue)grid);
        flow.add(null, (BValue)name);
        flow.add(null, (BValue)new BLabel());
        flow.add(null, (BValue)table);
        flow.setupPane();
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)flow, doc, op);
    }

    class Model
    extends TableModel {
        private BExportData pdfData;
        private Context cx;

        public Model(BExportData pdfData, Context cx) {
            this.pdfData = pdfData;
            this.cx = cx;
        }

        public int getRowCount() {
            return this.pdfData.getTableContents().tr.size();
        }

        public int getColumnCount() {
            int size = this.pdfData.getTableContents().columns.td.size();
            if (size == 0 && this.pdfData.getTableContents().tr.size() > 1) {
                size = this.pdfData.getTableContents().tr.get((int)0).td.size();
            }
            return size;
        }

        public Object getValueAt(int row, int col) {
            TableContents.Tr tr = this.pdfData.getTableContents().tr.get(row);
            TableContents.Td td = tr.td.get(col);
            return td.text;
        }

        public BImage getRowIcon(int row) {
            TableContents.Tr tr = this.pdfData.getTableContents().tr.get(row);
            if (tr.icons == null) {
                return null;
            }
            return tr.icons[tr.icons.length - 1];
        }

        public String getColumnName(int col) {
            if (this.pdfData.getTableContents().columns.td.size() > 0) {
                TableContents.Td td = this.pdfData.getTableContents().columns.td.get(col);
                return td.text;
            }
            return "";
        }
    }
}

