/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionAppSchemaManager;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.accessDriver.BAccessAda;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BIAccessDriverService;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.enums.BValidationResult;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.LicenseChecker;
import com.tridiumx.entsec.LicenseCounter;
import com.tridiumx.entsec.access.AccessControlServiceUpgrade;
import com.tridiumx.entsec.access.AccessUtil;
import com.tridiumx.entsec.access.BAccessControlWorker;
import com.tridiumx.entsec.access.BAccessValidationInfo;
import com.tridiumx.entsec.access.BAdditionalPersonnelEntry;
import com.tridiumx.entsec.access.BCacheStatusEnum;
import com.tridiumx.entsec.access.BDashboard;
import com.tridiumx.entsec.access.BJaceMaintenance;
import com.tridiumx.entsec.access.BMappedFloorExt;
import com.tridiumx.entsec.access.BMappedReaderExt;
import com.tridiumx.entsec.access.BMappedZoneExt;
import com.tridiumx.entsec.access.dyntable.BAccessRightReaderReport;
import com.tridiumx.entsec.access.dyntable.BAccessRights;
import com.tridiumx.entsec.access.dyntable.BAccessZones;
import com.tridiumx.entsec.access.dyntable.BBadges;
import com.tridiumx.entsec.access.dyntable.BInfoTemplates;
import com.tridiumx.entsec.access.dyntable.BKeypadFormats;
import com.tridiumx.entsec.access.dyntable.BNiagaraIntegrationIDs;
import com.tridiumx.entsec.access.dyntable.BPersonAccessRightReport;
import com.tridiumx.entsec.access.dyntable.BPersonReaderReport;
import com.tridiumx.entsec.access.dyntable.BPersonnel;
import com.tridiumx.entsec.access.dyntable.BPersonnelChanges;
import com.tridiumx.entsec.access.dyntable.BWiegandFormats;
import com.tridiumx.entsec.access.history.BAttendanceHistoryConsolidator;
import com.tridiumx.entsec.access.history.BAttendanceOrionRec;
import com.tridiumx.entsec.access.history.BAttendanceRecord;
import com.tridiumx.entsec.access.history.BBadgeSwipeOrionRec;
import com.tridiumx.entsec.access.history.BBadgeSwipeRecord;
import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessRightLdapGroupJoin;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BKeypadFormat;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.access.orion.BLdapServer;
import com.tridiumx.entsec.access.orion.BLdapServerPersonEntry;
import com.tridiumx.entsec.access.orion.BNiagaraIntegrationID;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.query.BDoors;
import com.tridiumx.entsec.access.query.BElevators;
import com.tridiumx.entsec.access.query.BInputs;
import com.tridiumx.entsec.access.query.BModules;
import com.tridiumx.entsec.access.query.BNACControllers;
import com.tridiumx.entsec.access.query.BOutputs;
import com.tridiumx.entsec.access.query.BReaders;
import com.tridiumx.entsec.access.replicate.EntsecReplicator;
import com.tridiumx.entsec.access.schema.Upgrade_1_0_to_1_1;
import com.tridiumx.entsec.access.schema.Upgrade_1_10_to_1_11;
import com.tridiumx.entsec.access.schema.Upgrade_1_11_to_1_12;
import com.tridiumx.entsec.access.schema.Upgrade_1_12_to_1_13;
import com.tridiumx.entsec.access.schema.Upgrade_1_13_to_1_14;
import com.tridiumx.entsec.access.schema.Upgrade_1_14_to_1_15;
import com.tridiumx.entsec.access.schema.Upgrade_1_15_to_1_16;
import com.tridiumx.entsec.access.schema.Upgrade_1_16_to_1_17;
import com.tridiumx.entsec.access.schema.Upgrade_1_1_to_1_2;
import com.tridiumx.entsec.access.schema.Upgrade_1_2_to_1_3;
import com.tridiumx.entsec.access.schema.Upgrade_1_3_to_1_4;
import com.tridiumx.entsec.access.schema.Upgrade_1_4_to_1_5;
import com.tridiumx.entsec.access.schema.Upgrade_1_5_to_1_6;
import com.tridiumx.entsec.access.schema.Upgrade_1_6_to_1_7;
import com.tridiumx.entsec.access.schema.Upgrade_1_7_to_1_8;
import com.tridiumx.entsec.access.schema.Upgrade_1_8_to_1_9;
import com.tridiumx.entsec.access.schema.Upgrade_1_9_to_1_10;
import com.tridiumx.entsec.access.util.AccessZonesUpdateUtil;
import com.tridiumx.entsec.access.util.CleanupUtil;
import com.tridiumx.entsec.access.util.ValidationUtil;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedure;
import com.tridiumx.entsec.orionTools.BIMappingService;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.OrionTypeRegistrator;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import com.tridiumx.entsec.orionTools.history.BOrionNiagaraHistoryTypeExport;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BIActivityService;
import com.tridiumx.entsec.securityUtil.BIAsyncStationStarted;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDef;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefEvent;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import com.tridiumx.entsec.threat.BMappedThreatLevelGroupExt;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BDescriptor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistorySource;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQuery;
import javax.baja.rdb.ddl.AlterColumn;
import javax.baja.rdb.ddl.CreateIndex;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="displayUnknownWiegandFormats", type="boolean", defaultValue="false"), @NiagaraProperty(name="hasPinDuress", type="boolean", defaultValue="false"), @NiagaraProperty(name="pinDuressOffset", type="int", defaultValue="1"), @NiagaraProperty(name="remoteValidation", type="boolean", defaultValue="false"), @NiagaraProperty(name="softwareVersion", type="String", defaultValue="BAccessControlService.DEFAULT_VALUE_FOR_SOFTWARE_VERSION", flags=1), @NiagaraProperty(name="maxBadgeCacheSize", type="int", defaultValue="-1", flags=4, facets={@Facet(name="BFacets.MIN", value="-1")}), @NiagaraProperty(name="cacheStatus", type="BCacheStatusEnum", defaultValue="BCacheStatusEnum.inactive", flags=3, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:ToStringFE\"")}), @NiagaraProperty(name="dashboard", type="BDashboard", defaultValue="new BDashboard()", flags=8), @NiagaraProperty(name="personnel", type="BPersonnel", defaultValue="new BPersonnel()", flags=8), @NiagaraProperty(name="badges", type="BBadges", defaultValue="new BBadges()", flags=8), @NiagaraProperty(name="accessRights", type="BAccessRights", defaultValue="new BAccessRights()", flags=8), @NiagaraProperty(name="accessZones", type="BAccessZones", defaultValue="new BAccessZones()", flags=8), @NiagaraProperty(name="doors", type="BDoors", defaultValue="new BDoors()", flags=8), @NiagaraProperty(name="modules", type="BModules", defaultValue="new BModules()", flags=8), @NiagaraProperty(name="NACControllers", type="BNACControllers", defaultValue="new BNACControllers()", flags=8), @NiagaraProperty(name="readers", type="BReaders", defaultValue="new BReaders()", flags=8), @NiagaraProperty(name="inputs", type="BInputs", defaultValue="new BInputs()", flags=8), @NiagaraProperty(name="outputs", type="BOutputs", defaultValue="new BOutputs()", flags=8), @NiagaraProperty(name="elevators", type="BElevators", defaultValue="new BElevators()", flags=8), @NiagaraProperty(name="accessHistory", type="BSecurityHistoryConsolidator", defaultValue="new BSecurityHistoryConsolidator(BHistoryId.make(\"^\", \"BadgeSwipeRecord\"), BBadgeSwipeRecord.TYPE.getTypeSpec(), true)", flags=8), @NiagaraProperty(name="attendanceHistory", type="BAttendanceHistoryConsolidator", defaultValue="new BAttendanceHistoryConsolidator()", flags=8), @NiagaraProperty(name="wiegandFormats", type="BWiegandFormats", defaultValue="new BWiegandFormats()", flags=8), @NiagaraProperty(name="keypadFormats", type="BKeypadFormats", defaultValue="new BKeypadFormats()", flags=8), @NiagaraProperty(name="personInfo", type="BInfoTemplates", defaultValue="new BInfoTemplates()", flags=8), @NiagaraProperty(name="niagaraIntegrationIDs", type="BNiagaraIntegrationIDs", defaultValue="new BNiagaraIntegrationIDs()", flags=8), @NiagaraProperty(name="monitorSysDef", type="BMonitorSysDef", defaultValue="new BMonitorSysDef()", flags=4), @NiagaraProperty(name="personAccessRightReport", type="BPersonAccessRightReport", defaultValue="new BPersonAccessRightReport()", flags=8), @NiagaraProperty(name="personReaderReport", type="BPersonReaderReport", defaultValue="new BPersonReaderReport()", flags=8), @NiagaraProperty(name="accessRightReaderReport", type="BAccessRightReaderReport", defaultValue="new BAccessRightReaderReport()", flags=8), @NiagaraProperty(name="personnelChanges", type="BPersonnelChanges", defaultValue="new BPersonnelChanges(BHistoryId.make(\"^\", \"AuditHistory\"), BAuditRecord.TYPE.getTypeSpec(), true)", flags=8), @NiagaraProperty(name="jaceMaintenance", type="BJaceMaintenance", defaultValue="new BJaceMaintenance()", flags=8), @NiagaraProperty(name="additionalPersonnelEntry", type="BAdditionalPersonnelEntry", defaultValue="new BAdditionalPersonnelEntry()", flags=8), @NiagaraProperty(name="accessControlWorker", type="BAccessControlWorker", defaultValue="new BAccessControlWorker()", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="validateRemoteBadge", parameterType="BAccessValidationInfo", defaultValue="new BAccessValidationInfo()", returnType="BAccessValidationInfo", flags=4), @NiagaraAction(name="handleSysDefEvent", parameterType="BMonitorSysDefEvent", defaultValue="new BMonitorSysDefEvent()", flags=5), @NiagaraAction(name="cleanupAfterReplication", flags=16), @NiagaraAction(name="cleanupOrphanedRecords", flags=16), @NiagaraAction(name="reinitDbCache", flags=20), @NiagaraAction(name="showDbCacheStatus", flags=20), @NiagaraAction(name="validateRecord", parameterType="BAccessValidationInfo", defaultValue="new BAccessValidationInfo()", flags=20), @NiagaraAction(name="insertPersonZoneJoin", parameterType="BPersonZoneJoin", defaultValue="new BPersonZoneJoin()", flags=4), @NiagaraAction(name="updatePersonZoneJoin", parameterType="BPersonZoneJoin", defaultValue="new BPersonZoneJoin()", flags=4), @NiagaraAction(name="deletePersonZoneJoin", parameterType="BPersonZoneJoin", defaultValue="new BPersonZoneJoin()", flags=4)})
@NiagaraTopics(value={@NiagaraTopic(name="newActivity", eventType="BActivityRecord"), @NiagaraTopic(name="dataModified")})
public class BAccessControlService
extends BAbstractOrionApp
implements BIService,
BIAccessDriverService,
BIMappingService,
BIActivityService,
BIHistorySource,
BIAsyncStationStarted {
    private static final String DEFAULT_VALUE_FOR_SOFTWARE_VERSION = AccessControlServiceUpgrade.SECURITY_2_0_23.toString();
    @Generated
    public static final Property displayUnknownWiegandFormats = BAccessControlService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property hasPinDuress = BAccessControlService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property pinDuressOffset = BAccessControlService.newProperty((int)0, (int)1, null);
    @Generated
    public static final Property remoteValidation = BAccessControlService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property softwareVersion = BAccessControlService.newProperty((int)1, (String)DEFAULT_VALUE_FOR_SOFTWARE_VERSION, null);
    @Generated
    public static final Property maxBadgeCacheSize = BAccessControlService.newProperty((int)4, (int)-1, (BFacets)BFacets.make((String)"min", (int)-1));
    @Generated
    public static final Property cacheStatus = BAccessControlService.newProperty((int)3, (BValue)BCacheStatusEnum.inactive, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    @Generated
    public static final Property dashboard = BAccessControlService.newProperty((int)8, (BValue)new BDashboard(), null);
    @Generated
    public static final Property personnel = BAccessControlService.newProperty((int)8, (BValue)new BPersonnel(), null);
    @Generated
    public static final Property badges = BAccessControlService.newProperty((int)8, (BValue)new BBadges(), null);
    @Generated
    public static final Property accessRights = BAccessControlService.newProperty((int)8, (BValue)new BAccessRights(), null);
    @Generated
    public static final Property accessZones = BAccessControlService.newProperty((int)8, (BValue)new BAccessZones(), null);
    @Generated
    public static final Property doors = BAccessControlService.newProperty((int)8, (BValue)new BDoors(), null);
    @Generated
    public static final Property modules = BAccessControlService.newProperty((int)8, (BValue)new BModules(), null);
    @Generated
    public static final Property NACControllers = BAccessControlService.newProperty((int)8, (BValue)new BNACControllers(), null);
    @Generated
    public static final Property readers = BAccessControlService.newProperty((int)8, (BValue)new BReaders(), null);
    @Generated
    public static final Property inputs = BAccessControlService.newProperty((int)8, (BValue)new BInputs(), null);
    @Generated
    public static final Property outputs = BAccessControlService.newProperty((int)8, (BValue)new BOutputs(), null);
    @Generated
    public static final Property elevators = BAccessControlService.newProperty((int)8, (BValue)new BElevators(), null);
    @Generated
    public static final Property accessHistory = BAccessControlService.newProperty((int)8, (BValue)new BSecurityHistoryConsolidator(BHistoryId.make((String)"^", (String)"BadgeSwipeRecord"), BBadgeSwipeRecord.TYPE.getTypeSpec(), true), null);
    @Generated
    public static final Property attendanceHistory = BAccessControlService.newProperty((int)8, (BValue)new BAttendanceHistoryConsolidator(), null);
    @Generated
    public static final Property wiegandFormats = BAccessControlService.newProperty((int)8, (BValue)new BWiegandFormats(), null);
    @Generated
    public static final Property keypadFormats = BAccessControlService.newProperty((int)8, (BValue)new BKeypadFormats(), null);
    @Generated
    public static final Property personInfo = BAccessControlService.newProperty((int)8, (BValue)new BInfoTemplates(), null);
    @Generated
    public static final Property niagaraIntegrationIDs = BAccessControlService.newProperty((int)8, (BValue)new BNiagaraIntegrationIDs(), null);
    @Generated
    public static final Property monitorSysDef = BAccessControlService.newProperty((int)4, (BValue)new BMonitorSysDef(), null);
    @Generated
    public static final Property personAccessRightReport = BAccessControlService.newProperty((int)8, (BValue)new BPersonAccessRightReport(), null);
    @Generated
    public static final Property personReaderReport = BAccessControlService.newProperty((int)8, (BValue)new BPersonReaderReport(), null);
    @Generated
    public static final Property accessRightReaderReport = BAccessControlService.newProperty((int)8, (BValue)new BAccessRightReaderReport(), null);
    @Generated
    public static final Property personnelChanges = BAccessControlService.newProperty((int)8, (BValue)new BPersonnelChanges(BHistoryId.make((String)"^", (String)"AuditHistory"), BAuditRecord.TYPE.getTypeSpec(), true), null);
    @Generated
    public static final Property jaceMaintenance = BAccessControlService.newProperty((int)8, (BValue)new BJaceMaintenance(), null);
    @Generated
    public static final Property additionalPersonnelEntry = BAccessControlService.newProperty((int)8, (BValue)new BAdditionalPersonnelEntry(), null);
    @Generated
    public static final Property accessControlWorker = BAccessControlService.newProperty((int)5, (BValue)new BAccessControlWorker(), null);
    @Generated
    public static final Action validateRemoteBadge = BAccessControlService.newAction((int)4, (BValue)new BAccessValidationInfo(), null);
    @Generated
    public static final Action handleSysDefEvent = BAccessControlService.newAction((int)5, (BValue)new BMonitorSysDefEvent(), null);
    @Generated
    public static final Action cleanupAfterReplication = BAccessControlService.newAction((int)16, null);
    @Generated
    public static final Action cleanupOrphanedRecords = BAccessControlService.newAction((int)16, null);
    @Generated
    public static final Action reinitDbCache = BAccessControlService.newAction((int)20, null);
    @Generated
    public static final Action showDbCacheStatus = BAccessControlService.newAction((int)20, null);
    @Generated
    public static final Action validateRecord = BAccessControlService.newAction((int)20, (BValue)new BAccessValidationInfo(), null);
    @Generated
    public static final Action insertPersonZoneJoin = BAccessControlService.newAction((int)4, (BValue)new BPersonZoneJoin(), null);
    @Generated
    public static final Action updatePersonZoneJoin = BAccessControlService.newAction((int)4, (BValue)new BPersonZoneJoin(), null);
    @Generated
    public static final Action deletePersonZoneJoin = BAccessControlService.newAction((int)4, (BValue)new BPersonZoneJoin(), null);
    @Generated
    public static final Topic newActivity = BAccessControlService.newTopic((int)0, null);
    @Generated
    public static final Topic dataModified = BAccessControlService.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAccessControlService.class);
    private static Type[] serviceTypes = new Type[]{TYPE, BIAccessDriverService.TYPE, BIMappingService.TYPE};
    public OrionType[] registeredOrionTypes;
    public static final OrionType[] orionTypes = new OrionType[]{BAccessRight.ORION_TYPE, BAccReaderRec.ORION_TYPE, BAccReaderJoin.ORION_TYPE, BPerson.ORION_TYPE, BPersonAccJoin.ORION_TYPE, BBadge.ORION_TYPE, BWiegandFormat.ORION_TYPE, BNiagaraIntegrationID.ORION_TYPE, BPersonInfo.ORION_TYPE, BInfoTemplate.ORION_TYPE, BAccessZoneRec.ORION_TYPE, BPersonZoneJoin.ORION_TYPE, BEntryReaderZoneJoin.ORION_TYPE, BExitReaderZoneJoin.ORION_TYPE, BSupervisorZoneJoin.ORION_TYPE, BAccFloorRec.ORION_TYPE, BAccFloorJoin.ORION_TYPE, BKeypadFormat.ORION_TYPE, BBadgeSwipeOrionRec.ORION_TYPE, BAttendanceOrionRec.ORION_TYPE, BThreatLevelBadgeJoin.ORION_TYPE, BLdapServer.ORION_TYPE, BPersonLdapServerJoin.ORION_TYPE, BLdapGroup.ORION_TYPE, BAccessRightLdapGroupJoin.ORION_TYPE, BBadgeLdapServerJoin.ORION_TYPE, BLdapServerPersonEntry.ORION_TYPE};
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/access/cards.png");
    public static final BIcon ERROR_ICON = BIcon.make((String)"module://entsec/rc/access/cards.png\nmodule://icons/x16/badges/error.png");
    static BTypeSpec[] historyTypesToExport = new BTypeSpec[]{BBadgeSwipeRecord.TYPE.getTypeSpec(), BAttendanceRecord.TYPE.getTypeSpec()};
    private static BAbsTime upTime = Clock.time();
    private OrionSession validationSession;
    public static final Lexicon lex = Lexicon.make((String)"entsec");
    public static Logger LOG = Logger.getLogger("entsec");
    public static final Version CURRENT_SOFTWARE_VERSION = TYPE.getVendorVersion();
    private HistoryManager historyManager;
    private boolean orionReady = false;
    private MappingSupport mappingSupport = new MappingSupport(this);
    private EntsecReplicator<?> replicator = new EntsecReplicator();
    private DbCache dbCache = new DbCache();
    public static final BSchemaVersion VERSION_1_17 = BSchemaVersion.make((String)"1.17");
    public static final BSchemaVersion VERSION_1_16 = BSchemaVersion.make((String)"1.16");
    public static final BSchemaVersion VERSION_1_15 = BSchemaVersion.make((String)"1.15");
    public static final BSchemaVersion VERSION_1_14 = BSchemaVersion.make((String)"1.14");
    public static final BSchemaVersion VERSION_1_13 = BSchemaVersion.make((String)"1.13");
    public static final BSchemaVersion VERSION_1_12 = BSchemaVersion.make((String)"1.12");
    public static final BSchemaVersion VERSION_1_11 = BSchemaVersion.make((String)"1.11");
    public static final BSchemaVersion VERSION_1_10 = BSchemaVersion.make((String)"1.10");
    public static final BSchemaVersion VERSION_1_9 = BSchemaVersion.make((String)"1.9");
    public static final BSchemaVersion VERSION_1_8 = BSchemaVersion.make((String)"1.8");
    public static final BSchemaVersion VERSION_1_7 = BSchemaVersion.make((String)"1.7");
    public static final BSchemaVersion VERSION_1_6 = BSchemaVersion.make((String)"1.6");
    public static final BSchemaVersion VERSION_1_5 = BSchemaVersion.make((String)"1.5");
    public static final BSchemaVersion VERSION_1_4 = BSchemaVersion.make((String)"1.4");
    public static final BSchemaVersion VERSION_1_3 = BSchemaVersion.make((String)"1.3");
    public static final BSchemaVersion VERSION_1_2 = BSchemaVersion.make((String)"1.2");
    public static final BSchemaVersion VERSION_1_1 = BSchemaVersion.make((String)"1.1");
    public static final BSchemaVersion VERSION_1_0 = BSchemaVersion.make((String)"1.0");
    public static final BSchemaVersion CURRENT_VERSION = VERSION_1_17;
    protected OrionAppSchemaManager schemaManager = new OrionAppSchemaManager((BIOrionApp)this, new ISchemaUpgrader[]{new Upgrade_1_0_to_1_1(), new Upgrade_1_1_to_1_2(), new Upgrade_1_2_to_1_3(), new Upgrade_1_3_to_1_4(), new Upgrade_1_4_to_1_5(), new Upgrade_1_5_to_1_6(), new Upgrade_1_6_to_1_7(), new Upgrade_1_7_to_1_8(), new Upgrade_1_8_to_1_9(), new Upgrade_1_9_to_1_10(), new Upgrade_1_10_to_1_11(), new Upgrade_1_11_to_1_12(), new Upgrade_1_12_to_1_13(), new Upgrade_1_13_to_1_14(), new Upgrade_1_14_to_1_15(), new Upgrade_1_15_to_1_16(), new Upgrade_1_16_to_1_17()});
    private static final String VENDOR = "tridium";
    private static final String ACCESS_CONTROL_FEATURE = "accessControl";
    private static final String ENTSECURITY_FEATURE = "entSecurity";
    private static final String ACCESS_ZONE_LIMIT_ATTR = "accessZone.limit";
    private static final String ELEVATOR_LIMIT_ATTR = "elevator.limit";
    private static final String ADA_ATTRIBUTE_KEY = "ada";
    private static final String ADA_ATTRIBUTE_VALUE = "true";
    private boolean canStartTimer = true;
    public boolean encryptPinNumbers = false;
    public boolean alterThreatLevelGroupTable = false;

    @Generated
    public boolean getDisplayUnknownWiegandFormats() {
        return this.getBoolean(displayUnknownWiegandFormats);
    }

    @Generated
    public void setDisplayUnknownWiegandFormats(boolean v) {
        this.setBoolean(displayUnknownWiegandFormats, v, null);
    }

    @Generated
    public boolean getHasPinDuress() {
        return this.getBoolean(hasPinDuress);
    }

    @Generated
    public void setHasPinDuress(boolean v) {
        this.setBoolean(hasPinDuress, v, null);
    }

    @Generated
    public int getPinDuressOffset() {
        return this.getInt(pinDuressOffset);
    }

    @Generated
    public void setPinDuressOffset(int v) {
        this.setInt(pinDuressOffset, v, null);
    }

    @Generated
    public boolean getRemoteValidation() {
        return this.getBoolean(remoteValidation);
    }

    @Generated
    public void setRemoteValidation(boolean v) {
        this.setBoolean(remoteValidation, v, null);
    }

    @Generated
    public String getSoftwareVersion() {
        return this.getString(softwareVersion);
    }

    @Generated
    public void setSoftwareVersion(String v) {
        this.setString(softwareVersion, v, null);
    }

    @Generated
    public int getMaxBadgeCacheSize() {
        return this.getInt(maxBadgeCacheSize);
    }

    @Generated
    public void setMaxBadgeCacheSize(int v) {
        this.setInt(maxBadgeCacheSize, v, null);
    }

    @Generated
    public BCacheStatusEnum getCacheStatus() {
        return (BCacheStatusEnum)this.get(cacheStatus);
    }

    @Generated
    public void setCacheStatus(BCacheStatusEnum v) {
        this.set(cacheStatus, (BValue)v, null);
    }

    @Generated
    public BDashboard getDashboard() {
        return (BDashboard)this.get(dashboard);
    }

    @Generated
    public void setDashboard(BDashboard v) {
        this.set(dashboard, (BValue)v, null);
    }

    @Generated
    public BPersonnel getPersonnel() {
        return (BPersonnel)this.get(personnel);
    }

    @Generated
    public void setPersonnel(BPersonnel v) {
        this.set(personnel, (BValue)v, null);
    }

    @Generated
    public BBadges getBadges() {
        return (BBadges)this.get(badges);
    }

    @Generated
    public void setBadges(BBadges v) {
        this.set(badges, (BValue)v, null);
    }

    @Generated
    public BAccessRights getAccessRights() {
        return (BAccessRights)this.get(accessRights);
    }

    @Generated
    public void setAccessRights(BAccessRights v) {
        this.set(accessRights, (BValue)v, null);
    }

    @Generated
    public BAccessZones getAccessZones() {
        return (BAccessZones)this.get(accessZones);
    }

    @Generated
    public void setAccessZones(BAccessZones v) {
        this.set(accessZones, (BValue)v, null);
    }

    @Generated
    public BDoors getDoors() {
        return (BDoors)this.get(doors);
    }

    @Generated
    public void setDoors(BDoors v) {
        this.set(doors, (BValue)v, null);
    }

    @Generated
    public BModules getModules() {
        return (BModules)this.get(modules);
    }

    @Generated
    public void setModules(BModules v) {
        this.set(modules, (BValue)v, null);
    }

    @Generated
    public BNACControllers getNACControllers() {
        return (BNACControllers)this.get(NACControllers);
    }

    @Generated
    public void setNACControllers(BNACControllers v) {
        this.set(NACControllers, (BValue)v, null);
    }

    @Generated
    public BReaders getReaders() {
        return (BReaders)this.get(readers);
    }

    @Generated
    public void setReaders(BReaders v) {
        this.set(readers, (BValue)v, null);
    }

    @Generated
    public BInputs getInputs() {
        return (BInputs)this.get(inputs);
    }

    @Generated
    public void setInputs(BInputs v) {
        this.set(inputs, (BValue)v, null);
    }

    @Generated
    public BOutputs getOutputs() {
        return (BOutputs)this.get(outputs);
    }

    @Generated
    public void setOutputs(BOutputs v) {
        this.set(outputs, (BValue)v, null);
    }

    @Generated
    public BElevators getElevators() {
        return (BElevators)this.get(elevators);
    }

    @Generated
    public void setElevators(BElevators v) {
        this.set(elevators, (BValue)v, null);
    }

    @Generated
    public BSecurityHistoryConsolidator getAccessHistory() {
        return (BSecurityHistoryConsolidator)this.get(accessHistory);
    }

    @Generated
    public void setAccessHistory(BSecurityHistoryConsolidator v) {
        this.set(accessHistory, (BValue)v, null);
    }

    @Generated
    public BAttendanceHistoryConsolidator getAttendanceHistory() {
        return (BAttendanceHistoryConsolidator)this.get(attendanceHistory);
    }

    @Generated
    public void setAttendanceHistory(BAttendanceHistoryConsolidator v) {
        this.set(attendanceHistory, (BValue)v, null);
    }

    @Generated
    public BWiegandFormats getWiegandFormats() {
        return (BWiegandFormats)this.get(wiegandFormats);
    }

    @Generated
    public void setWiegandFormats(BWiegandFormats v) {
        this.set(wiegandFormats, (BValue)v, null);
    }

    @Generated
    public BKeypadFormats getKeypadFormats() {
        return (BKeypadFormats)this.get(keypadFormats);
    }

    @Generated
    public void setKeypadFormats(BKeypadFormats v) {
        this.set(keypadFormats, (BValue)v, null);
    }

    @Generated
    public BInfoTemplates getPersonInfo() {
        return (BInfoTemplates)this.get(personInfo);
    }

    @Generated
    public void setPersonInfo(BInfoTemplates v) {
        this.set(personInfo, (BValue)v, null);
    }

    @Generated
    public BNiagaraIntegrationIDs getNiagaraIntegrationIDs() {
        return (BNiagaraIntegrationIDs)this.get(niagaraIntegrationIDs);
    }

    @Generated
    public void setNiagaraIntegrationIDs(BNiagaraIntegrationIDs v) {
        this.set(niagaraIntegrationIDs, (BValue)v, null);
    }

    @Generated
    public BMonitorSysDef getMonitorSysDef() {
        return (BMonitorSysDef)this.get(monitorSysDef);
    }

    @Generated
    public void setMonitorSysDef(BMonitorSysDef v) {
        this.set(monitorSysDef, (BValue)v, null);
    }

    @Generated
    public BPersonAccessRightReport getPersonAccessRightReport() {
        return (BPersonAccessRightReport)this.get(personAccessRightReport);
    }

    @Generated
    public void setPersonAccessRightReport(BPersonAccessRightReport v) {
        this.set(personAccessRightReport, (BValue)v, null);
    }

    @Generated
    public BPersonReaderReport getPersonReaderReport() {
        return (BPersonReaderReport)this.get(personReaderReport);
    }

    @Generated
    public void setPersonReaderReport(BPersonReaderReport v) {
        this.set(personReaderReport, (BValue)v, null);
    }

    @Generated
    public BAccessRightReaderReport getAccessRightReaderReport() {
        return (BAccessRightReaderReport)this.get(accessRightReaderReport);
    }

    @Generated
    public void setAccessRightReaderReport(BAccessRightReaderReport v) {
        this.set(accessRightReaderReport, (BValue)v, null);
    }

    @Generated
    public BPersonnelChanges getPersonnelChanges() {
        return (BPersonnelChanges)this.get(personnelChanges);
    }

    @Generated
    public void setPersonnelChanges(BPersonnelChanges v) {
        this.set(personnelChanges, (BValue)v, null);
    }

    @Generated
    public BJaceMaintenance getJaceMaintenance() {
        return (BJaceMaintenance)this.get(jaceMaintenance);
    }

    @Generated
    public void setJaceMaintenance(BJaceMaintenance v) {
        this.set(jaceMaintenance, (BValue)v, null);
    }

    @Generated
    public BAdditionalPersonnelEntry getAdditionalPersonnelEntry() {
        return (BAdditionalPersonnelEntry)this.get(additionalPersonnelEntry);
    }

    @Generated
    public void setAdditionalPersonnelEntry(BAdditionalPersonnelEntry v) {
        this.set(additionalPersonnelEntry, (BValue)v, null);
    }

    @Generated
    public BAccessControlWorker getAccessControlWorker() {
        return (BAccessControlWorker)this.get(accessControlWorker);
    }

    @Generated
    public void setAccessControlWorker(BAccessControlWorker v) {
        this.set(accessControlWorker, (BValue)v, null);
    }

    @Generated
    public BAccessValidationInfo validateRemoteBadge(BAccessValidationInfo parameter) {
        return (BAccessValidationInfo)this.invoke(validateRemoteBadge, (BValue)parameter, null);
    }

    @Generated
    public void handleSysDefEvent(BMonitorSysDefEvent parameter) {
        this.invoke(handleSysDefEvent, (BValue)parameter, null);
    }

    @Generated
    public void cleanupAfterReplication() {
        this.invoke(cleanupAfterReplication, null, null);
    }

    @Generated
    public void cleanupOrphanedRecords() {
        this.invoke(cleanupOrphanedRecords, null, null);
    }

    @Generated
    public void reinitDbCache() {
        this.invoke(reinitDbCache, null, null);
    }

    @Generated
    public void showDbCacheStatus() {
        this.invoke(showDbCacheStatus, null, null);
    }

    @Generated
    public void validateRecord(BAccessValidationInfo parameter) {
        this.invoke(validateRecord, (BValue)parameter, null);
    }

    @Generated
    public void insertPersonZoneJoin(BPersonZoneJoin parameter) {
        this.invoke(insertPersonZoneJoin, (BValue)parameter, null);
    }

    @Generated
    public void updatePersonZoneJoin(BPersonZoneJoin parameter) {
        this.invoke(updatePersonZoneJoin, (BValue)parameter, null);
    }

    @Generated
    public void deletePersonZoneJoin(BPersonZoneJoin parameter) {
        this.invoke(deletePersonZoneJoin, (BValue)parameter, null);
    }

    @Override
    @Generated
    public void fireNewActivity(BActivityRecord event) {
        this.fire(newActivity, (BValue)event, null);
    }

    @Generated
    public void fireDataModified(BValue event) {
        this.fire(dataModified, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        super.serviceStarted();
        try {
            BOrionService orion = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            if (orion == null || orion.getStatus().isFault()) {
                this.configFail("non-fault OrionService required.");
                return;
            }
        }
        catch (Exception e) {
            this.configFail("non-fault OrionService required.");
        }
        try {
            BReplicationService repl = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
            repl.addListener(this.replicator);
        }
        catch (Exception e) {
            this.configFail("ReplicationService required.");
        }
        if (softwareVersion.toString().equals("0")) {
            this.setSoftwareVersion(CURRENT_SOFTWARE_VERSION.toString());
        }
        this.linkToMonitorSysDef();
    }

    public void serviceStopped() {
        this.unlinkFromMonitorSysDef();
        this.getComponentSpace().disableMixIn(BMappedFloorExt.TYPE);
        this.getComponentSpace().disableMixIn(BMappedReaderExt.TYPE);
        this.getComponentSpace().disableMixIn(BMappedZoneExt.TYPE);
        try {
            BReplicationService repl = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
            repl.removeListener(this.replicator);
        }
        catch (Exception e) {
            this.configFail("ReplicationService required.");
        }
    }

    public final void started() throws Exception {
        this.checkLicensing();
        this.getHistoryManager();
        this.mappingSupport.orionReadyAndStarted();
        if (this.isOrionReady()) {
            OrionSession session = null;
            try {
                session = this.createSession(null);
                AccessUtil.ensureDefaults(session);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        this.initCacheAfterOrionReadyAndStarted();
    }

    private void checkLicensing() {
        LicenseCounter.checkLicense(this.getEntsecLicenseFeature(), (BAbstractService)this);
        LicenseChecker licenseChecker = LicenseChecker.getChecker();
        licenseChecker.register(this.getParent(), (Slot)this.getPropertyInParent(), VENDOR, ACCESS_CONTROL_FEATURE, true).register((BComplex)this, (Slot)elevators, VENDOR, ACCESS_CONTROL_FEATURE, ELEVATOR_LIMIT_ATTR, "", true).register((BComplex)this, (Slot)accessZones, VENDOR, ENTSECURITY_FEATURE, ACCESS_ZONE_LIMIT_ATTR, "", true);
        try {
            BComponent accessNetwork = Sys.getService((Type)BAccessNetwork.TYPE);
            licenseChecker.register(BAccessAda.TYPE, (BObject)accessNetwork, VENDOR, ACCESS_CONTROL_FEATURE, ADA_ATTRIBUTE_KEY, ADA_ATTRIBUTE_VALUE, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationStarted() throws Exception {
        OrionSession orionSession;
        super.stationStarted();
        BEnterpriseSecurityService.postAsyncStationStarted(this);
        LOG.fine("Access:encryptPinNumbers: " + this.encryptPinNumbers);
        if (this.encryptPinNumbers) {
            LOG.warning("Encrypting person pin numbers");
            orionSession = null;
            try {
                orionSession = this.createSession(null);
                ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getAndUpdatePinNumbers(BPerson.class, (Context)orionSession);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
        }
        if (this.alterThreatLevelGroupTable) {
            LOG.warning("Altering threat level group table");
            orionSession = null;
            try {
                orionSession = this.createSession(null);
                SchemaUpgradeSupport.dropIndex(orionSession.getOrionDatabase(), orionSession, BThreatLevelGroupRec.ORION_TYPE, "PathIndex");
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
            try {
                orionSession = this.createSession(null);
                this.upgradeThreatLevelGroupPath(orionSession.getOrionDatabase(), orionSession);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
            orionSession = null;
            try {
                orionSession = this.createSession(null);
                this.upgradeThreatLevelGroupName(orionSession.getOrionDatabase(), orionSession);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
            try {
                orionSession = this.createSession(null);
                CreateIndex ddl2 = SchemaUpgradeSupport.createIndexForMultipleColumns(BThreatLevelGroupRec.ORION_TYPE, BThreatLevelGroupRec.threatLevelGroupName, orionSession.getOrionDatabase());
                orionSession.invokeDdl((DdlCommand)ddl2);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
        }
    }

    @Override
    public void asyncStationStarted() throws Exception {
        Version version = new Version(this.getSoftwareVersion());
        if (version.compareTo(CURRENT_SOFTWARE_VERSION) < 0) {
            try {
                AccessControlServiceUpgrade.upgrade(this, version, CURRENT_SOFTWARE_VERSION);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.log(Level.SEVERE, "Error during upgrade from " + version + " to " + CURRENT_SOFTWARE_VERSION + ".", e);
            }
        }
        if (BEnterpriseSecurityService.isWorkstation()) {
            CreatePersonCleanupProcedure.createPersonCleanupStoredProcedure();
            LOG.info("Procedure creation complete complete.");
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(maxBadgeCacheSize)) {
            this.dbCache.setMaxBadgeCacheSize(this.getMaxBadgeCacheSize());
            this.reinitDbCache();
        }
        super.changed(property, context);
    }

    public void stopped() throws Exception {
        this.closeOrionSession();
        LicenseChecker checker = LicenseChecker.getChecker();
        checker.deregister(this.getParent());
        checker.deregister((BComplex)this);
        super.stopped();
    }

    protected void finalize() {
        this.closeOrionSession();
    }

    public void closeOrionSession() {
        if (this.validationSession != null && this.validationSession.isOpen()) {
            this.validationSession.close();
            this.validationSession = null;
        }
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature(VENDOR, ACCESS_CONTROL_FEATURE);
    }

    public final Feature getEntsecLicenseFeature() {
        return Sys.getLicenseManager().getFeature(VENDOR, ENTSECURITY_FEATURE);
    }

    public final String getCredentialLimit() {
        return this.getEntsecLicenseFeature().get("credential.limit");
    }

    public final String getAccessZoneLimit() {
        String limit = this.getEntsecLicenseFeature().get(ACCESS_ZONE_LIMIT_ATTR);
        return limit;
    }

    public final boolean allowAccessZones() {
        return this.getAccessZoneLimit() != null;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 501: {
                return LicenseCounter.checkLicenseLimit(this.getEntsecLicenseFeature(), (String)a);
            }
            case 503: {
                return new Integer(LicenseCounter.getLicenseCount(this.getEntsecLicenseFeature(), (String)a));
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        Invocation invoke = new Invocation((BComponent)this, action, argument, cx);
        this.getAccessControlWorker().postAsync((Runnable)invoke);
        return null;
    }

    public BSchemaVersion getSchemaVersion() {
        return CURRENT_VERSION;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase orionDatabase, BSchemaVersion oldVersion) throws Exception {
        this.schemaManager.performSchemaUpgrade(orionDatabase, oldVersion);
    }

    public void orionReady(BOrionDatabase db) {
        this.orionReady = true;
        if (this.isRunning()) {
            OrionSession session = null;
            try {
                session = this.createSession(null);
                AccessUtil.ensureDefaults(session);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        this.getComponentSpace().enableMixIn(BMappedFloorExt.TYPE);
        this.getComponentSpace().enableMixIn(BMappedReaderExt.TYPE);
        this.getComponentSpace().enableMixIn(BMappedZoneExt.TYPE);
        this.mappingSupport.orionReadyAndStarted();
        this.getAccessHistory().validateOrionApp(this);
        this.getAttendanceHistory().validateOrionApp(this);
        this.initCacheAfterOrionReadyAndStarted();
    }

    public void initCacheAfterOrionReadyAndStarted() {
        if (!this.isOrionReady() || !this.isRunning()) {
            return;
        }
        this.dbCache.setMaxBadgeCacheSize(this.getMaxBadgeCacheSize());
        this.doReinitDbCache();
    }

    public OrionType[] getOrionTypes() {
        if (!this.orionReady || this.registeredOrionTypes == null) {
            this.registeredOrionTypes = OrionTypeRegistrator.getDistictOrionTypes(this, orionTypes, this.registeredOrionTypes);
        }
        return this.registeredOrionTypes;
    }

    @Override
    public boolean isOrionReady() {
        return this.orionReady;
    }

    @Override
    public void mappedRemoved(BComponent c) {
        this.mappingSupport.mappedRemoved(c);
    }

    @Override
    public void mappedAdded(BComponent c) {
        this.mappingSupport.mappedAdded(c);
    }

    @Override
    public void mappedUpdate(BComponent c) {
        this.mappingSupport.mappedUpdate(c);
    }

    @Override
    public void mappedPersist(BComponent c) {
        this.mappingSupport.mappedPersist(c);
    }

    public HistoryManager getHistoryManager() {
        if (this.historyManager == null) {
            this.historyManager = new HistoryManager(this, new Type[]{BAttendanceRecord.TYPE, BBadgeSwipeRecord.TYPE, BLDAPAuditRecord.TYPE});
        }
        return this.historyManager;
    }

    public BAccessValidationInfo doValidateRemoteBadge(BAccessValidationInfo remoteInfo) {
        if (!this.getRemoteValidation()) {
            return remoteInfo;
        }
        BAccessValidationInfo info = new BAccessValidationInfo();
        info.copyFrom((BComplex)remoteInfo);
        info.service = this;
        info.setStartTicks(Clock.ticks());
        info.time = BAbsTime.now();
        info.getRecord().setActivity(BBadgeActivity.granted);
        this.validateBadge(info, true);
        if (info.getRecord().getActivity().isGranted()) {
            info.getRecord().setGranted(true);
        } else {
            info.getRecord().setGranted(false);
        }
        return info;
    }

    public void doValidateRecord(BAccessValidationInfo info) {
        if (info instanceof BAccessValidationInfo) {
            BAccessValidationInfo accessInfo = info;
            ValidationUtil.record(accessInfo, this.obtainValidationSession(), this.dbCache);
        }
    }

    public void doInsertPersonZoneJoin(BPersonZoneJoin join) {
        this.obtainValidationSession().insert((BIOrionObject)join);
    }

    public void doUpdatePersonZoneJoin(BPersonZoneJoin join) {
        this.obtainValidationSession().update((BIOrionObject)join);
    }

    public void doDeletePersonZoneJoin(BPersonZoneJoin join) {
        this.obtainValidationSession().delete((BIOrionObject)join);
    }

    public BValidationResult validateBadge(BValidationInfo validationInfo) {
        BAccessValidationInfo info = new BAccessValidationInfo(validationInfo, this);
        return this.validateBadge(info, false);
    }

    public void validateBadgeTimeout(BValidationInfo info) {
        info.getAccessReader().makeAlarm(BBadgeActivity.validationTimeoutExpired, "", info.getCredential(), "", null);
        if (info.getAccessReader().enableLogging(BBadgeActivity.validationTimeoutExpired)) {
            BBadgeSwipeRecord record = new BBadgeSwipeRecord((BComponent)info.getAccessReader(), BBadgeActivity.validationTimeoutExpired, "", "", false);
            record.setBadge(info.getCredential());
            this.getHistoryManager().append(record);
        }
    }

    public BValidationResult validateBadge(BAccessValidationInfo info, boolean isRemoteRequest) {
        return ValidationUtil.validate(info, this.obtainValidationSession(), isRemoteRequest, this.dbCache);
    }

    public void badgeHolderDidNotEnter(BValidationInfo info) {
        if (info instanceof BAccessValidationInfo) {
            BAccessValidationInfo accessInfo = (BAccessValidationInfo)info;
            accessInfo.getRecord().setTimestamp(BAbsTime.now());
            accessInfo.getRecord().setActivity(BBadgeActivity.grantedButNotUsed);
            accessInfo.getRecord().setDetails("");
            accessInfo.setAccessZoneRec(new BAccessZoneRec());
            ValidationUtil.record(accessInfo, this.obtainValidationSession(), this.dbCache);
        }
    }

    public void badgeHolderEntered(BValidationInfo info) {
        if (info instanceof BAccessValidationInfo) {
            BAccessValidationInfo accessInfo = (BAccessValidationInfo)info;
            AccessZonesUpdateUtil.update(accessInfo, this.obtainValidationSession(), this, this.dbCache);
        }
    }

    public void accessAudit(BComponent device, BBadgeActivity activity, String owner, String details, boolean granted) {
        this.getHistoryManager().append(new BBadgeSwipeRecord(device, activity, owner, details, granted));
    }

    public void addBadgeSwipeOrionRec(BComponent device, BAbsTime timestamp, BBadgeActivity activity, String owner, String badge, String details, boolean granted, BUuid personId) {
        try (OrionSession session = this.createSession(null);){
            BBadgeSwipeOrionRec rec = new BBadgeSwipeOrionRec();
            rec.setGranted(granted);
            rec.setTimestamp(timestamp);
            rec.setReader(BBadgeSwipeRecord.getLocation(device));
            rec.setBadge(badge);
            rec.setOwner(owner);
            rec.setActivity(activity);
            rec.setDetails(details);
            rec.setPersonId(personId);
            session.insert((BIOrionObject)rec);
            session.commit();
        }
    }

    public void addAttendanceOrionRec(BTimeAttendEnum attendance, String owner, BUuid personId, BAbsTime timestamp) {
        try (OrionSession session = this.createSession(null);){
            BAttendanceOrionRec rec = new BAttendanceOrionRec();
            rec.setTimestamp(timestamp);
            rec.setActivityTimestamp(timestamp);
            rec.setActivity(attendance);
            rec.setOwner(owner);
            rec.setPersonId(personId);
            session.insert((BIOrionObject)rec);
            session.commit();
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        LicenseCounter.spy(out);
    }

    public BIcon getIcon() {
        return !this.getStatus().isFault() ? ICON : ERROR_ICON;
    }

    public void doCleanupAfterReplication() {
        OrionSession session = null;
        try {
            session = this.createSession(null);
            CleanupUtil.cleanupAfterReplication(session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doCleanupOrphanedRecords() {
        OrionSession session = null;
        try {
            session = this.createSession(null);
            CleanupUtil.cleanupOrphanedRecords(session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doReinitDbCache() {
        this.dbCache.init(this.obtainValidationSession());
    }

    public void doShowDbCacheStatus() {
        this.dbCache.printMaps();
    }

    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        this.getHistoryManager().historyConfigChanged(config, p);
    }

    private void linkToMonitorSysDef() {
        if (this.get("sysDefLink") != null) {
            return;
        }
        this.linkTo("sysDefLink", this.getMonitorSysDef(), (Slot)BMonitorSysDef.monitorSysDefEvent, (Slot)handleSysDefEvent);
    }

    private void unlinkFromMonitorSysDef() {
        Property p = this.getProperty("sysDefLink");
        if (p != null) {
            this.remove(p);
        }
    }

    public void doUpdateThreatLevelGroupName(OrionSession session) throws Exception {
        BogCursor c = new BogCursor((BComplex)Sys.getStation(), 1000, new Type[]{BThreatLevelGroup.TYPE}, false, null);
        Map<BUuid, BThreatLevelGroupRec> threatLevelGroupRecMap = this.getThreatLevelGroupRec(session);
        BThreatLevelGroupRec tlgRec = null;
        BThreatLevelGroupRec tlgRecParent = null;
        BatchStatement threatLevelGroupBatchStatement = session.batchUpdate(BThreatLevelGroupRec.ORION_TYPE);
        int startIndex = "/Services/EnterpriseSecurityService/threatLevelGroups".length();
        int renameIndex = 0;
        while (c.next()) {
            String path = null;
            String name = null;
            try {
                BThreatLevelGroup group = (BThreatLevelGroup)c.get();
                BMappedThreatLevelGroupExt ext = (BMappedThreatLevelGroupExt)group.getMixIn(BMappedThreatLevelGroupExt.TYPE);
                tlgRec = threatLevelGroupRecMap.get(ext.getUuid());
                path = tlgRec.getMappedDisplayPath().substring(startIndex) + "/";
                name = tlgRec.getThreatLevelGroupName();
                if (tlgRec == null || BThreatLevelGroupRec.MAX_PATH_LENGTH >= path.length() && 49 >= name.length()) continue;
                String newName = "renamed_" + renameIndex;
                String newParentName = "renamed_" + ++renameIndex;
                ++renameIndex;
                group.getParent().asComponent().rename(group.getPropertyInParent(), newName);
                tlgRec.setThreatLevelGroupName(newName);
                tlgRec.setSlotPathOrd((BObject)group);
                tlgRec.setPath(tlgRec.getMappedDisplayPath().substring(startIndex) + "/");
                threatLevelGroupBatchStatement.add((BIOrionObject)tlgRec);
                if (group.getParent() instanceof BThreatLevelGroup) {
                    group.getParent().getParent().asComponent().rename(group.getParent().getPropertyInParent(), newParentName);
                    BMappedThreatLevelGroupExt extParent = (BMappedThreatLevelGroupExt)((BThreatLevelGroup)group.getParent()).getMixIn(BMappedThreatLevelGroupExt.TYPE);
                    tlgRecParent = threatLevelGroupRecMap.get(extParent.getUuid());
                    if (tlgRecParent != null) {
                        tlgRecParent.setThreatLevelGroupName(newParentName);
                        tlgRecParent.setSlotPathOrd((BObject)group.getParent());
                        tlgRecParent.setPath(tlgRecParent.getMappedDisplayPath().substring(startIndex) + "/");
                        threatLevelGroupBatchStatement.add((BIOrionObject)tlgRecParent);
                    }
                }
                if (threatLevelGroupBatchStatement.size() > 1000) {
                    threatLevelGroupBatchStatement.execute();
                    threatLevelGroupBatchStatement.clear();
                }
                LOG.warning("Threat Level Group Name or Path too long, shortening last two names for Threat Level's with path from '" + path + "' to '" + newParentName + "/" + newName + "'.");
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Threat Level Group Name or Path too long, please fix this name or path manually before Threat Level Group can work properly: " + path, e);
                throw new Exception("Threat Level Group Name or Path too long, please fix this name or path manually before Threat Level Group can work properly: " + path, e);
            }
        }
        threatLevelGroupBatchStatement.execute();
    }

    private Map<BUuid, BThreatLevelGroupRec> getThreatLevelGroupRec(OrionSession session) throws Exception {
        HashMap<BUuid, BThreatLevelGroupRec> threatLevelGroupRecMap = new HashMap<BUuid, BThreatLevelGroupRec>();
        try {
            BSqlQuery recsQuery = BSqlQuery.make((OrionType)BThreatLevelGroupRec.ORION_TYPE);
            OrionCursor cursor = session.select((BQuery)recsQuery);
            while (cursor.next()) {
                BThreatLevelGroupRec threatLevelGroupRec = (BThreatLevelGroupRec)cursor.get();
                if (threatLevelGroupRec.getPath() == null) continue;
                threatLevelGroupRecMap.put(threatLevelGroupRec.getUuid(), threatLevelGroupRec);
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to Threat Level group from Database");
        }
        return threatLevelGroupRecMap;
    }

    public void doHandleSysDefEvent(BMonitorSysDefEvent event) throws Exception {
        String stationName = event.getStationName();
        int role = event.getRole();
        int eventType = event.getId();
        if (BMonitorSysDefEvent.isInsert(eventType)) {
            BNiagaraNetwork ntwk = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation niagaraSupervisorStation = (BNiagaraStation)ntwk.getNiagaraStation(stationName);
            if (BMonitorSysDefEvent.isSupervisor(role)) {
                try {
                    this.configureHistoryExports(niagaraSupervisorStation, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (BMonitorSysDefEvent.isDelete(eventType) && BMonitorSysDefEvent.isSupervisor(role)) {
            try {
                BNiagaraNetwork ntwk = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation niagaraSupervisorStation = (BNiagaraStation)ntwk.getNiagaraStation(stationName);
                if (niagaraSupervisorStation == null) {
                    LOG.warning("Cannot find supervisor station " + stationName + " for SysDefEvent: " + (Object)((Object)event));
                } else {
                    this.configureHistoryExports(niagaraSupervisorStation, false);
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.SEVERE, "Unhandled SysDefEvent: " + (Object)((Object)event), e);
                }
                LOG.severe("Unhandled SysDefEvent: " + (Object)((Object)event) + ": " + e.getMessage());
            }
        }
    }

    public void invokeDataModified() {
        if (this.canStartTimer) {
            this.canStartTimer = false;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BAccessControlService.this.fireDataModified(null);
                    BAccessControlService.this.canStartTimer = true;
                }
            }, 1000L);
        }
    }

    private void configureHistoryExports(BNiagaraStation station, boolean enable) {
        BDescriptor[] descriptors = station.getHistories().getDescriptors();
        for (int j = 0; j < historyTypesToExport.length; ++j) {
            BTypeSpec recType = historyTypesToExport[j];
            boolean foundExisting = false;
            for (int i = 0; i < descriptors.length; ++i) {
                BDescriptor descriptor = descriptors[i];
                if (!(descriptor instanceof BOrionNiagaraHistoryTypeExport) || !((BOrionNiagaraHistoryTypeExport)descriptor).getRecordType().equals((Object)recType)) continue;
                foundExisting = true;
                if (enable) {
                    descriptor.setEnabled(true);
                    Clock.schedule((BComponent)descriptor, (BRelTime)BRelTime.makeSeconds((int)10), (Action)BDescriptor.execute, null);
                    break;
                }
                BComponent parent = (BComponent)descriptor.getParent();
                parent.remove((BComplex)descriptor);
                break;
            }
            if (foundExisting || !enable) continue;
            BOrionNiagaraHistoryTypeExport descriptor = new BOrionNiagaraHistoryTypeExport();
            descriptor.setRecordType(recType);
            descriptor.setExecuteOnAppend(true);
            descriptor.setExecutionTime(new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make((BTime)BTime.make((int)2, (int)0, (int)0), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT, (BRelTime)BRelTime.makeMinutes((int)15))));
            descriptor.setEnabled(true);
            StringBuffer sb = new StringBuffer();
            sb.append(recType.toString());
            sb.append(" Type Export");
            station.getHistories().add(sb.toString() + "?", (BValue)descriptor);
            Clock.schedule((BComponent)descriptor, (BRelTime)BRelTime.makeSeconds((int)10), (Action)BDescriptor.execute, null);
        }
    }

    private void upgradeThreatLevelGroupPath(BOrionDatabase db, OrionSession session) throws Exception {
        AlterColumn ddl = SchemaUpgradeSupport.alterColumnWidth(BThreatLevelGroupRec.ORION_TYPE, BThreatLevelGroupRec.path, db, BThreatLevelGroupRec.MAX_PATH_LENGTH);
        session.invokeDdl((DdlCommand)ddl);
    }

    private void upgradeThreatLevelGroupName(BOrionDatabase db, OrionSession session) throws Exception {
        AlterColumn ddl = SchemaUpgradeSupport.alterColumnWidth(BThreatLevelGroupRec.ORION_TYPE, BThreatLevelGroupRec.threatLevelGroupName, db, 49);
        session.invokeDdl((DdlCommand)ddl);
    }

    public static BAbsTime getLastStationRestart() {
        return upTime;
    }

    private OrionSession obtainValidationSession() {
        if (this.validationSession == null) {
            this.validationSession = this.createSession(null);
        }
        return this.validationSession;
    }

    public DbCache getDbCache() {
        return this.dbCache;
    }
}

