/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.history;

import com.tridium.orion.OrionSession;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.access.AccessControlServiceUpgrade;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.BISummaryImage;
import com.tridiumx.entsec.orionTools.history.BSecHistoryRecord;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BIOutOfOrderHistoryRecord;
import com.tridiumx.entsec.securityUtil.BISecurityActivity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=4, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.TRUE)")}, override=true), @NiagaraProperty(name="activityTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=8, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="activity", type="BTimeAttendEnum", defaultValue="BTimeAttendEnum.none"), @NiagaraProperty(name="owner", type="String", defaultValue=""), @NiagaraProperty(name="manualEntry", type="boolean", defaultValue="false"), @NiagaraProperty(name="hidden", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="personId", type="BUuid", defaultValue="BUuid.NULL", flags=4)})
public class BAttendanceRecord
extends BSecHistoryRecord
implements BISecurityActivity,
BIOutOfOrderHistoryRecord,
BISummaryImage {
    private static final long serialVersionUID = 0L;
    @Generated
    public static final Property timestamp = BAttendanceRecord.newProperty((int)4, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property activityTimestamp = BAttendanceRecord.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property activity = BAttendanceRecord.newProperty((int)0, (BValue)BTimeAttendEnum.none, null);
    @Generated
    public static final Property owner = BAttendanceRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property manualEntry = BAttendanceRecord.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property hidden = BAttendanceRecord.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property personId = BAttendanceRecord.newProperty((int)4, (BValue)BUuid.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAttendanceRecord.class);

    @Generated
    public BAbsTime getActivityTimestamp() {
        return (BAbsTime)this.get(activityTimestamp);
    }

    @Generated
    public void setActivityTimestamp(BAbsTime v) {
        this.set(activityTimestamp, (BValue)v, null);
    }

    @Generated
    public BTimeAttendEnum getActivity() {
        return (BTimeAttendEnum)this.get(activity);
    }

    @Generated
    public void setActivity(BTimeAttendEnum v) {
        this.set(activity, (BValue)v, null);
    }

    @Generated
    public String getOwner() {
        return this.getString(owner);
    }

    @Generated
    public void setOwner(String v) {
        this.setString(owner, v, null);
    }

    @Generated
    public boolean getManualEntry() {
        return this.getBoolean(manualEntry);
    }

    @Generated
    public void setManualEntry(boolean v) {
        this.setBoolean(manualEntry, v, null);
    }

    @Generated
    public boolean getHidden() {
        return this.getBoolean(hidden);
    }

    @Generated
    public void setHidden(boolean v) {
        this.setBoolean(hidden, v, null);
    }

    @Generated
    public BUuid getPersonId() {
        return (BUuid)this.get(personId);
    }

    @Generated
    public void setPersonId(BUuid v) {
        this.set(personId, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAttendanceRecord() {
    }

    public BAttendanceRecord(BTimeAttendEnum attendance, String owner, BUuid uuid) {
        BAbsTime now = BAbsTime.now();
        this.setTimestamp(now);
        this.setActivityTimestamp(now);
        this.setActivity(attendance);
        this.setOwner(owner);
        this.setPersonId(uuid);
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    protected void doRead(DataInput in, Context cx) throws IOException {
        String stringVersion;
        this.setActivityTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(in));
        try {
            this.setActivity((BTimeAttendEnum)BTimeAttendEnum.none.decodeFromString(in.readUTF()));
        }
        catch (Exception e) {
            this.setActivity(BTimeAttendEnum.none);
        }
        this.setOwner(in.readUTF());
        this.setManualEntry(in.readBoolean());
        this.setHidden(in.readBoolean());
        if (cx != null && cx.getFacets() != null && (stringVersion = cx.getFacets().gets("version", null)) != null && new Version(stringVersion).compareTo(AccessControlServiceUpgrade.SECURITY_2_2_1) < 0) {
            return;
        }
        try {
            this.setPersonId((BUuid)BUuid.NULL.decode(in));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doWrite(DataOutput out) throws IOException {
        this.getActivityTimestamp().encode(out);
        out.writeUTF(this.getActivity().encodeToString());
        out.writeUTF(this.getOwner());
        out.writeBoolean(this.getManualEntry());
        out.writeBoolean(this.getHidden());
        this.getPersonId().encode(out);
    }

    @Override
    public BActivityRecord convertToActivity(Context cx) {
        if (this.getHidden()) {
            return null;
        }
        return new BActivityRecord(this.getActivityTimestamp(), (BObject)this, this.getActivity().toString(cx), "", this.getOwner(), this.getManualEntry() ? manualEntry.getDefaultDisplayName(cx) : "");
    }

    @Override
    public Property getOutOfOrderStringProperty() {
        return null;
    }

    @Override
    public BImage getSummaryImage(OrionSession session) {
        if (this.getPersonId().equals((Object)BUuid.DEFAULT)) {
            return BImage.DEFAULT;
        }
        BPerson person = (BPerson)session.read(BPerson.ORION_TYPE, (BSimple)this.getPersonId());
        if (person != null) {
            return person.getSummaryImage(session);
        }
        return BImage.DEFAULT;
    }
}

