/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionRefCursor;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.AccessControlConst;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BValidationBits;
import com.tridiumx.entsec.orionTools.BIPresettableUuid;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import java.math.BigInteger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraOrionType
@OrionRefCursor(name="Badges", type="BBadge", ref="wiegandFormat")
@NiagaraProperties(value={@NiagaraProperty(name="wiegandFormatId", type="BUuid", defaultValue="BUuid.NULL", flags=1, facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="wiegandFormatName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="64"), @Facet(name="DISPLAY_ID", value="true"), @Facet(name="UNIQUE", value="true"), @Facet(name="BFacets.ALLOW_NULL", value="false")}), @NiagaraProperty(name="facilityCode", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="128")}), @NiagaraProperty(name="bitLength", type="int", defaultValue="26", flags=9, facets={@Facet(name="INDEXED", value="true"), @Facet(name="BFacets.MIN", value="16"), @Facet(name="BFacets.MAX", value="MAX_BIT_LENGTH")}), @NiagaraProperty(name="credentialStart", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_BIT_LENGTH")}), @NiagaraProperty(name="credentialLength", type="int", defaultValue="1", flags=1, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_BIT_LENGTH")}), @NiagaraProperty(name="facilityStart", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_BIT_LENGTH")}), @NiagaraProperty(name="facilityLength", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_BIT_LENGTH")}), @NiagaraProperty(name="parityBits", type="int", defaultValue="0", flags=1, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="MAX_PARITY_BITS")}), @NiagaraProperty(name="format", type="String", defaultValue="N-------------------------", flags=9, facets={@Facet(name="WIDTH", value="MAX_BIT_LENGTH")}), @NiagaraProperty(name="parity", type="String", defaultValue="", flags=1, facets={@Facet(name="WIDTH", value="MAX_BIT_LENGTH*MAX_PARITY_BITS")}), @NiagaraProperty(name="validationBits", type="BValidationBits", defaultValue="BValidationBits.all")})
public class BWiegandFormat
extends BReplicableObject
implements AccessControlConst,
BIPresettableUuid {
    public static final int MAX_BIT_LENGTH = Integer.getInteger("niagara.entsec.wiegandFormat.maxBitLength", 256);
    public static final int MAX_PARITY_BITS = Integer.getInteger("niagara.entsec.wiegandFormat.maxParityBits", 5);
    @Generated
    public static final Property wiegandFormatId = BWiegandFormat.newProperty((int)1, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    @Generated
    public static final Property wiegandFormatName = BWiegandFormat.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"displayId", (boolean)true)), (BFacets)BFacets.make((String)"unique", (boolean)true)), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    @Generated
    public static final Property facilityCode = BWiegandFormat.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)128));
    @Generated
    public static final Property bitLength = BWiegandFormat.newProperty((int)9, (int)26, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"min", (int)16)), (BFacets)BFacets.make((String)"max", (int)MAX_BIT_LENGTH)));
    @Generated
    public static final Property credentialStart = BWiegandFormat.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)MAX_BIT_LENGTH)));
    @Generated
    public static final Property credentialLength = BWiegandFormat.newProperty((int)1, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)MAX_BIT_LENGTH)));
    @Generated
    public static final Property facilityStart = BWiegandFormat.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)MAX_BIT_LENGTH)));
    @Generated
    public static final Property facilityLength = BWiegandFormat.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)MAX_BIT_LENGTH)));
    @Generated
    public static final Property parityBits = BWiegandFormat.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)MAX_PARITY_BITS)));
    @Generated
    public static final Property format = BWiegandFormat.newProperty((int)9, (String)"N-------------------------", (BFacets)BFacets.make((String)"width", (int)MAX_BIT_LENGTH));
    @Generated
    public static final Property parity = BWiegandFormat.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"width", (int)(MAX_BIT_LENGTH * MAX_PARITY_BITS)));
    @Generated
    public static final Property validationBits = BWiegandFormat.newProperty((int)0, (BValue)BValidationBits.all, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWiegandFormat.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIcon.std((String)"views/hexFileEditor.png");

    @Generated
    public BUuid getWiegandFormatId() {
        return (BUuid)this.get(wiegandFormatId);
    }

    @Generated
    public void setWiegandFormatId(BUuid v) {
        this.set(wiegandFormatId, (BValue)v, null);
    }

    @Generated
    public String getWiegandFormatName() {
        return this.getString(wiegandFormatName);
    }

    @Generated
    public void setWiegandFormatName(String v) {
        this.setString(wiegandFormatName, v, null);
    }

    @Generated
    public String getFacilityCode() {
        return this.getString(facilityCode);
    }

    @Generated
    public void setFacilityCode(String v) {
        this.setString(facilityCode, v, null);
    }

    @Generated
    public int getBitLength() {
        return this.getInt(bitLength);
    }

    @Generated
    public void setBitLength(int v) {
        this.setInt(bitLength, v, null);
    }

    @Generated
    public int getCredentialStart() {
        return this.getInt(credentialStart);
    }

    @Generated
    public void setCredentialStart(int v) {
        this.setInt(credentialStart, v, null);
    }

    @Generated
    public int getCredentialLength() {
        return this.getInt(credentialLength);
    }

    @Generated
    public void setCredentialLength(int v) {
        this.setInt(credentialLength, v, null);
    }

    @Generated
    public int getFacilityStart() {
        return this.getInt(facilityStart);
    }

    @Generated
    public void setFacilityStart(int v) {
        this.setInt(facilityStart, v, null);
    }

    @Generated
    public int getFacilityLength() {
        return this.getInt(facilityLength);
    }

    @Generated
    public void setFacilityLength(int v) {
        this.setInt(facilityLength, v, null);
    }

    @Generated
    public int getParityBits() {
        return this.getInt(parityBits);
    }

    @Generated
    public void setParityBits(int v) {
        this.setInt(parityBits, v, null);
    }

    @Generated
    public String getFormat() {
        return this.getString(format);
    }

    @Generated
    public void setFormat(String v) {
        this.setString(format, v, null);
    }

    @Generated
    public String getParity() {
        return this.getString(parity);
    }

    @Generated
    public void setParity(String v) {
        this.setString(parity, v, null);
    }

    @Generated
    public BValidationBits getValidationBits() {
        return (BValidationBits)this.get(validationBits);
    }

    @Generated
    public void setValidationBits(BValidationBits v) {
        this.set(validationBits, (BValue)v, null);
    }

    @Generated
    public BadgesCursor getBadges(OrionSession session) {
        return new BadgesCursor(session.select(BBadge.ORION_TYPE, new PropertyValue(BBadge.wiegandFormat, (BValue)BRef.make((BIOrionObject)this))));
    }

    @Override
    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public BWiegandFormat() {
    }

    public BWiegandFormat(String description, String format, String parity, String facCode, int credS, int credL, int facS, int facL, int parityBits, BUuid uuid) {
        this.setWiegandFormatName(description);
        this.setFormat(format);
        this.setBitLength(format.length());
        this.setParity(parity);
        this.setFacilityCode(facCode);
        this.setCredentialLength(credL);
        this.setCredentialStart(credS);
        this.setFacilityLength(facL);
        this.setFacilityStart(facS);
        this.setParityBits(parityBits);
        this.setWiegandFormatId(uuid);
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        Property[] props = this.getFrozenPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (props[i] == wiegandFormatName || props[i] == lastModified || props[i] == facilityCode || props[i] == validationBits || !this.isModified(props[i]) || !this.inUse(session)) continue;
            throw new BajaRuntimeException("This Wiegand Format's " + props[i].getDefaultDisplayName(null) + " cannot be updated when in use by badges:" + this.getWiegandFormatName());
        }
        return super.beforeUpdate(session);
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        if (this.inUse(session)) {
            throw new BajaRuntimeException("This Wiegand Format cannot be deleted when in use by badges:" + this.getWiegandFormatName());
        }
        return super.beforeDelete(session);
    }

    @Override
    public boolean isDefault() {
        for (int i = 0; i < DEFAULT_WIEGAND_FORMAT_IDS.length; ++i) {
            if (!DEFAULT_WIEGAND_FORMAT_IDS[i].equals((Object)this.getWiegandFormatId())) continue;
            return true;
        }
        return false;
    }

    public boolean inUse(OrionSession session) {
        int count = CountingUtil.getCount((OrionType)BBadge.ORION_TYPE, (Property)BBadge.wiegandFormat, (BSimple)BRef.make((BIOrionObject)this), (OrionSession)session);
        return count > 0;
    }

    public BBadge getBadge(String hexBadge) {
        BBadge[] badges = BWiegandFormat.getUnknownBadgeInfo(hexBadge, new BWiegandFormat[]{this});
        if (badges[0].getWiegandFormat().isBound()) {
            return badges[0];
        }
        return null;
    }

    public static BBadge validationBitBadge(BBadge[] badges, BWiegandFormat[] formats, BAbsTime time, OrionSession session) {
        BBadge lastBadge = null;
        for (int i = 0; i < badges.length; ++i) {
            BValidationBits validationBits;
            BWiegandFormat format = BWiegandFormat.getWiegandFormat(badges[i], formats);
            if (format == null || (validationBits = format.getValidationBits()) == BValidationBits.all) continue;
            Array a = new Array(PropertyValue.class);
            a.add((Object)new PropertyValue(BBadge.wiegandFormat, (BValue)BRef.make((BIOrionObject)format)));
            if (validationBits == BValidationBits.credentialAndFacilityCode || validationBits == BValidationBits.credentialOnly) {
                a.add((Object)new PropertyValue(BBadge.credential, badges[i].get(BBadge.credential)));
            }
            if (validationBits == BValidationBits.credentialAndFacilityCode) {
                a.add((Object)new PropertyValue(BBadge.facilityCode, badges[i].get(BBadge.facilityCode)));
            }
            OrionCursor c = session.select(BBadge.ORION_TYPE, (PropertyValue[])a.trim());
            while (c.next()) {
                lastBadge = (BBadge)c.get();
                if (!lastBadge.getOwner().isBound() || lastBadge.getStatus() != BBadgeStatus.active || lastBadge.isDisabled(time)) continue;
                return lastBadge;
            }
        }
        return lastBadge;
    }

    public static BWiegandFormat getWiegandFormat(BBadge badge, BWiegandFormat[] formats) {
        if (!badge.getWiegandFormat().isBound()) {
            return null;
        }
        BUuid id = (BUuid)badge.getWiegandFormat().getId();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].getWiegandFormatId().equals((Object)id)) continue;
            return formats[i];
        }
        return null;
    }

    public static BBadge[] getUnknownBadgeInfo(String hexBadge, OrionSession session) {
        return BWiegandFormat.getUnknownBadgeInfo(hexBadge, (BWiegandFormat[])session.scan(ORION_TYPE).toArray());
    }

    public static BBadge[] getUnknownBadgeInfo(String hexBadge, BWiegandFormat[] wiegandFormats) {
        Array possibleBadges = new Array(BBadge.class);
        String originalBadgeId = "";
        try {
            originalBadgeId = BWiegandFormat.convert(hexBadge, 16, 2);
        }
        catch (Exception e) {
            BAccessControlService.LOG.fine("exception on " + originalBadgeId);
            BBadge badge = new BBadge();
            badge.setBadgeId(hexBadge);
            badge.setBDescription("Unknown");
            badge.setFacilityCode("Unknown");
            badge.setCredential(hexBadge);
            return new BBadge[]{badge};
        }
        int padding = originalBadgeId.length();
        int j = 0;
        while (padding + j < hexBadge.length() * 4) {
            originalBadgeId = "0" + originalBadgeId;
            ++j;
        }
        for (int i = 0; i < wiegandFormats.length; ++i) {
            int wiegandBitLength = wiegandFormats[i].getBitLength();
            String badgeId = originalBadgeId;
            int badgeIdLength = badgeId.length();
            if (badgeIdLength - wiegandBitLength > 7 || badgeIdLength - wiegandBitLength < 0) {
                BAccessControlService.LOG.fine(badgeIdLength + " != " + wiegandBitLength);
                continue;
            }
            BAccessControlService.LOG.fine(badgeIdLength + " == " + wiegandBitLength);
            int modEightBitLength = wiegandBitLength % 8;
            if (modEightBitLength != 0) {
                boolean extraBits = false;
                for (int j2 = originalBadgeId.length() + modEightBitLength - 8; j2 < originalBadgeId.length(); ++j2) {
                    if (originalBadgeId.charAt(j2) != '1') continue;
                    BAccessControlService.LOG.fine(wiegandBitLength + " has a extra bits, no match");
                    extraBits = true;
                }
                if (extraBits) continue;
                wiegandBitLength += 8 - modEightBitLength;
            }
            for (int j3 = 0; j3 < wiegandBitLength - badgeIdLength; ++j3) {
                badgeId = "0" + badgeId;
            }
            int cS = wiegandFormats[i].getCredentialStart();
            int cL = wiegandFormats[i].getCredentialLength();
            int fS = wiegandFormats[i].getFacilityStart();
            int fL = wiegandFormats[i].getFacilityLength();
            String credential = badgeId.substring(cS, cS + cL);
            String facilityCode = badgeId.substring(fS, fS + fL);
            credential = wiegandFormats[i].getCorrectLengthCredential(BWiegandFormat.convert(credential, 2, 10));
            facilityCode = facilityCode.length() > 0 ? BWiegandFormat.convert(facilityCode, 2, 10) : "0";
            BBadge newBadge = new BBadge();
            newBadge.setBadgeId(hexBadge);
            newBadge.setCredential(credential);
            newBadge.setFacilityCode(facilityCode);
            newBadge.setWiegandFormat(BRef.make((BIOrionObject)wiegandFormats[i]));
            possibleBadges.add((Object)newBadge);
        }
        if (possibleBadges.size() == 0) {
            BBadge badge = new BBadge();
            badge.setBadgeId(hexBadge);
            badge.setBDescription("Unknown Wiegand Format");
            badge.setFacilityCode("Unknown");
            badge.setCredential(hexBadge);
            return new BBadge[]{badge};
        }
        return (BBadge[])possibleBadges.trim();
    }

    public static BBadge[] getPossibleBadgesFromBadgeId(String badgeId, String[] possibleBadgeFormats, OrionSession session) {
        Array badgeList = new Array(BBadge.class);
        for (String uuid : possibleBadgeFormats) {
            try (OrionCursor cursor = session.select(ORION_TYPE, new PropertyValue(wiegandFormatId, (BValue)BUuid.make((String)SlotPath.unescape((String)uuid))));){
                if (!cursor.next()) continue;
                BWiegandFormat format = (BWiegandFormat)cursor.get();
                badgeList.add((Object)format.getBadge(badgeId));
            }
        }
        return (BBadge[])badgeList.trim();
    }

    public boolean isPossibleBadgeFormat(String[] possibleBadgeFormats) {
        for (String uuid : possibleBadgeFormats) {
            if (!this.getWiegandFormatId().equals((Object)BUuid.make((String)SlotPath.unescape((String)uuid)))) continue;
            return true;
        }
        return false;
    }

    public String getCredentialNumber(String badgeId) {
        badgeId = BWiegandFormat.convert(badgeId, 16, 2);
        int badgeIdLength = badgeId.length();
        int wiegandBitLength = this.getBitLength();
        if (wiegandBitLength % 8 != 0) {
            wiegandBitLength += 8 - wiegandBitLength % 8;
        }
        for (int i = 0; i < wiegandBitLength - badgeIdLength; ++i) {
            badgeId = "0" + badgeId;
        }
        int start = this.getCredentialStart();
        int length = this.getCredentialLength();
        if (this.getCredentialLength() == 0 || start + length > badgeId.length()) {
            return "-1";
        }
        String credential = badgeId.substring(this.getCredentialStart(), this.getCredentialStart() + this.getCredentialLength());
        String credBase10 = BWiegandFormat.convert(credential, 2, 10);
        return this.getCorrectLengthCredential(credBase10);
    }

    public String getCorrectLengthCredential(String credBase10) {
        double digits = Math.log(Math.pow(2.0, this.getCredentialLength())) / Math.log(10.0);
        int iDigit = (int)Math.ceil(digits);
        int j = 0;
        while (credBase10.length() < iDigit) {
            credBase10 = "0" + credBase10;
            ++j;
        }
        return credBase10;
    }

    public String getFacilityCode(String badgeId) {
        badgeId = BWiegandFormat.convert(badgeId, 16, 2);
        int badgeIdLength = badgeId.length();
        int wiegandBitLength = this.getBitLength();
        if (wiegandBitLength % 8 != 0) {
            wiegandBitLength += 8 - wiegandBitLength % 8;
        }
        for (int i = 0; i < wiegandBitLength - badgeIdLength; ++i) {
            badgeId = "0" + badgeId;
        }
        int start = this.getFacilityStart();
        int length = this.getFacilityLength();
        if (this.getFacilityLength() == 0 || start + length > badgeId.length()) {
            return "0";
        }
        String facilityCode = badgeId.substring(this.getFacilityStart(), this.getFacilityStart() + this.getFacilityLength());
        return BWiegandFormat.convert(facilityCode, 2, 10);
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public static String convert(String number, int fromRadix, int toRadix) {
        BigInteger bigInt = new BigInteger(number, fromRadix);
        return bigInt.toString(toRadix);
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertWiegandFormat(this, session);
        service.invokeDataModified();
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateWiegandFormat(this, session);
        service.invokeDataModified();
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteWiegandFormat(this, session);
        service.invokeDataModified();
    }

    public BIcon getIcon() {
        return ICON;
    }

    @Generated
    public static class BadgesCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private BadgesCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BBadge getBadge() {
            return (BBadge)this.cursor.get();
        }
    }
}

