/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schedule.nd;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.schedule.BScheduleAddInfo;
import com.tridiumx.entsec.access.schedule.util.MatchUtil;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.query.BCalendarSchedules;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
public class BDistributedScheduleAddJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BDistributedScheduleAddJob.class);
    private boolean canceled = false;
    private BString[] names = null;
    private BString[] values = null;
    private BComponent container;
    private BNiagaraScheduleDeviceExt scheduleDeviceExt;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDistributedScheduleAddJob() {
    }

    public BDistributedScheduleAddJob(BNiagaraScheduleDeviceExt scheduleDeviceExt, BScheduleAddInfo addInfo) {
        this.scheduleDeviceExt = scheduleDeviceExt;
        if (addInfo.getNames() != null) {
            this.names = (BString[])addInfo.getNames().getChildren(BString.class);
        }
        if (addInfo.getValues() != null) {
            this.values = (BString[])addInfo.getValues().getChildren(BString.class);
        }
        this.container = (BComponent)addInfo.getContainer().resolve((BObject)scheduleDeviceExt).get();
    }

    public void doCancel(Context cx) {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        this.canceled = false;
        BFoxSession foxSession = null;
        String interest = "DistributedScheduleAdd" + System.identityHashCode((Object)this);
        try {
            BNiagaraStation station = (BNiagaraStation)this.scheduleDeviceExt.getParent();
            foxSession = RemoteUtil.getFoxSession(station);
            if (foxSession == null) {
                throw new IllegalArgumentException("Failed to get fox session");
            }
            foxSession.engageNoRetry(interest);
            BComponent[] remoteSchedules = this.getRemoteSchedules(foxSession, this.values, cx);
            if (remoteSchedules.length != this.names.length) {
                throw new IllegalArgumentException("remoteSchedules.length != names.length");
            }
            BNiagaraNetwork remoteNiagaraNetwork = (BNiagaraNetwork)foxSession.getService(BNiagaraNetwork.TYPE);
            if (remoteNiagaraNetwork == null) {
                throw new IllegalArgumentException("Failed to find remote network");
            }
            String stationName = Sys.getStation().getStationName();
            BNiagaraStation remoteStation = RemoteUtil.findStation((BComponent)remoteNiagaraNetwork, stationName);
            if (remoteStation == null) {
                throw new IllegalArgumentException("Failed to find remote station '" + stationName + "'");
            }
            remoteStation.lease();
            BNiagaraScheduleDeviceExt remoteScheduleDeviceExt = remoteStation.getSchedules();
            remoteScheduleDeviceExt.lease();
            BComponent calendarScheduleContainer = this.getCalendarScheduleContainer();
            for (int i = 0; i < remoteSchedules.length; ++i) {
                this.progress((i + 1) * 100 / remoteSchedules.length);
                if (this.canceled) {
                    this.canceled();
                    break;
                }
                try {
                    if (this.container.get(this.names[i].getString()) != null) {
                        throw new Exception("a schedule with this name already exists");
                    }
                    remoteSchedules[i].lease();
                    BUuid uuid = MappingSupport.getMappedUuidRemotely(remoteSchedules[i]);
                    BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                    OrionSession session = null;
                    try {
                        session = service.createSession(null);
                        BScheduleRec rec = (BScheduleRec)session.read(BScheduleRec.ORION_TYPE, (BSimple)uuid);
                        if (rec != null) {
                            throw new Exception("a schedule with this uuid already exists: " + rec.getMappedDisplayPath());
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                            session = null;
                        }
                    }
                    this.addCalendarSchedules(foxSession, remoteSchedules[i], calendarScheduleContainer);
                    Property prop = this.container.add(this.names[i].getString(), remoteSchedules[i].newCopy(true));
                    BComponent newSchedule = (BComponent)this.container.get(prop);
                    if (newSchedule == null) continue;
                    MatchUtil.matchSchedule(foxSession, remoteScheduleDeviceExt, remoteSchedules[i], newSchedule, this.names[i].getString(), null, cx);
                    continue;
                }
                catch (Exception e) {
                    this.log().failed("Failed to add " + SlotPath.unescape((String)this.names[i].getString()) + ": " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            this.progress(100);
            if (!this.canceled) {
                this.success();
            }
        }
        finally {
            if (foxSession != null && foxSession.isEngaged(interest)) {
                foxSession.disengage(interest);
            }
        }
    }

    private BComponent[] getRemoteSchedules(BFoxSession foxSession, BString[] values, Context cx) {
        BOrd[] remoteOrds = new BOrd[values.length];
        for (int i = 0; i < values.length; ++i) {
            String remoteScheduleOrd = values[i].getString();
            remoteOrds[i] = remoteScheduleOrd.indexOf("station:|") == -1 ? BOrd.make((String)("station:|" + remoteScheduleOrd)) : BOrd.make((String)remoteScheduleOrd);
        }
        BatchResolve resolvedOrds = this.getResolvedOrds(remoteOrds, (BObject)foxSession);
        if (resolvedOrds == null) {
            return new BAbstractSchedule[0];
        }
        return resolvedOrds.getTargetComponents();
    }

    private BatchResolve getResolvedOrds(BOrd[] ords, BObject base) {
        BatchResolve batchResolveOrds = new BatchResolve(ords);
        if (batchResolveOrds != null) {
            batchResolveOrds.resolve(base);
        }
        return batchResolveOrds;
    }

    private BComponent getCalendarScheduleContainer() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (service != null) {
            BCalendarSchedules[] kids = (BCalendarSchedules[])service.getChildren(BCalendarSchedules.class);
            if (kids.length > 0) {
                return kids[0];
            }
            Property prop = service.add("calendarSchedules?", (BValue)new BCalendarSchedules());
            BComponent scheduleContainer = (BComponent)service.get(prop);
            if (scheduleContainer != null) {
                return scheduleContainer;
            }
        }
        return Sys.getStation();
    }

    private void addCalendarSchedules(BFoxSession foxSession, BComponent remoteSchedule, BComponent calendarScheduleContainer) {
        BOrd ord = BOrd.make((BOrd)remoteSchedule.getSlotPathOrd(), (String)"bql:select ref from schedule:ScheduleReference stop");
        BITable table = (BITable)ord.resolve((BObject)remoteSchedule).get();
        TableCursor tableCursor = table.cursor();
        Array arrValues = new Array(BString.class);
        while (tableCursor.next()) {
            Column idCol = table.getColumns().get(0);
            BOrd ref = BOrd.make((String)tableCursor.cell(idCol).toString());
            arrValues.add((Object)BString.make((String)ref.toString()));
        }
        BString[] values = new BString[arrValues.size()];
        System.arraycopy(arrValues.array(), 0, values, 0, values.length);
        BComponent[] remoteCalendarSchedules = this.getRemoteSchedules(foxSession, values, null);
        for (int j = 0; j < remoteCalendarSchedules.length; ++j) {
            if (calendarScheduleContainer.get(remoteCalendarSchedules[j].getName()) != null) continue;
            calendarScheduleContainer.add(remoteCalendarSchedules[j].getName(), remoteCalendarSchedules[j].newCopy(true));
        }
    }
}

