/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridiumx.entsec.access.schema.PinConverter;
import com.tridiumx.entsec.access.schema.exception.RetainInvalidPinException;

class AXToN48PinConverter
extends PinConverter {
    AXToN48PinConverter() {
    }

    @Override
    public String convert(AesSysKeyEncoder encoder, String textToBeEncrypted) throws Exception {
        try {
            if (textToBeEncrypted == null) {
                return this.getNullPassword(encoder);
            }
            String[] split = textToBeEncrypted.split(":");
            if (split.length == 2) {
                String decryptedPinNumber = encoder.decrypt(split[0] + ":" + split[1]);
                return this.getKeyAlias() + encoder.encrypt(decryptedPinNumber);
            }
            return this.nullifyInvalidPins(encoder);
        }
        catch (RetainInvalidPinException pinEx) {
            throw pinEx;
        }
        catch (Exception e) {
            return this.nullifyInvalidPins(encoder);
        }
    }
}

