/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridiumx.entsec.access.schema.PinConverter;
import com.tridiumx.entsec.access.schema.exception.RetainInvalidPinException;

class N46ToN48PinConverter
extends PinConverter {
    private AesSysKeyEncoder n46PINEncoder;

    public N46ToN48PinConverter(AesSysKeyEncoder n46PINEncoder) {
        this.n46PINEncoder = n46PINEncoder;
    }

    @Override
    public String convert(AesSysKeyEncoder encoder, String textToBeEncrypted) throws Exception {
        try {
            String[] split = textToBeEncrypted.split(":");
            if (split.length == 3) {
                String decryptedPinNumber = this.n46PINEncoder.decrypt(split[1] + ":" + split[2]);
                return this.getKeyAlias() + encoder.encrypt(decryptedPinNumber);
            }
            if (split.length == 2) {
                return this.getNullPassword(encoder);
            }
            return this.nullifyInvalidPins(encoder);
        }
        catch (RetainInvalidPinException pinException) {
            throw pinException;
        }
        catch (Exception e) {
            return this.nullifyInvalidPins(encoder);
        }
    }
}

