/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.AddColumn;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_16_to_1_17
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BAccessControlService.VERSION_1_16;
    private static final BSchemaVersion TO_VERSION = BAccessControlService.VERSION_1_17;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        try {
            AddColumn addColumn = SchemaUpgradeSupport.addColumnAsLastProperty(BAccessZoneRec.ORION_TYPE, BAccessZoneRec.accessZoneTypeSpec, db);
            session.invokeDdl((DdlCommand)addColumn);
            this.updateAccessZoneTypeSpec(session);
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Upgrade_1_16_to_1_17 Schema Upgrade either not needed or failed", e);
        }
    }

    private void updateAccessZoneTypeSpec(OrionSession session) {
        try (OrionCursor cursor = session.scan(BAccessZoneRec.ORION_TYPE);){
            BatchStatement accessZoneRecUpdater = session.batchUpdate(BAccessZoneRec.ORION_TYPE);
            while (cursor.next()) {
                BAccessZoneRec accessZoneRec = (BAccessZoneRec)cursor.get();
                if (!accessZoneRec.getAccessZoneTypeSpec().isNull()) continue;
                accessZoneRec.setAccessZoneTypeSpec(BAccessZone.TYPE.getTypeSpec());
                accessZoneRecUpdater.add((BIOrionObject)accessZoneRec);
            }
            accessZoneRecUpdater.execute();
        }
    }
}

