/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.TableBuilder;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.CreateIndex;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.rdb.ddl.DropIndex;

public class Upgrade_1_5_to_1_6
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BAccessControlService.VERSION_1_5;
    private static final BSchemaVersion TO_VERSION = BAccessControlService.VERSION_1_6;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        try {
            TableBuilder tb = new TableBuilder((BOrionDatabase)db, BPerson.ORION_TYPE);
            String indexName = SchemaUpgradeSupport.makeIndexName(session.getRdbmsContext(), tb.getTableName(), BPerson.lastName.getName());
            DropIndex dropCommand = new DropIndex(tb.getTableName(), indexName);
            session.invokeDdl((DdlCommand)dropCommand);
            indexName = SchemaUpgradeSupport.makeIndexName(session.getRdbmsContext(), tb.getTableName(), BPerson.firstName.getName());
            dropCommand = new DropIndex(tb.getTableName(), indexName);
            session.invokeDdl((DdlCommand)dropCommand);
            CreateIndex createIndex = new CreateIndex(new BPerson().getIndexes()[0].getName(), tb.getTableName(), false, new String[]{"firstName", "lastName"});
            session.invokeDdl((DdlCommand)createIndex);
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Upgrade_1_5_to_1_6 Schema Upgrade either not needed or failed", e);
        }
    }
}

